/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.LinkedList;
import java.util.Queue;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockSkippableElements;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ChunkContainer;
import net.sf.okapi.filters.openxml.ContentCategoriesDetection;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.MarkupComponentParser;
import net.sf.okapi.filters.openxml.NumberingDefinitions;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.Parser;
import net.sf.okapi.filters.openxml.RunBuilder;
import net.sf.okapi.filters.openxml.RunBuilderSkipper;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunMerger;
import net.sf.okapi.filters.openxml.RunParser;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesParser;
import net.sf.okapi.filters.openxml.RunSkippableElements;
import net.sf.okapi.filters.openxml.SkippableElement;
import net.sf.okapi.filters.openxml.SkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BlockParser
implements Parser<Block> {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String LOCAL_SIMPLE_FIELD = "fldSimple";
    private final StartElementContext startElementContext;
    private final IdGenerator nestedIds;
    private final StyleDefinitions styleDefinitions;
    private final StyleOptimisation styleOptimisation;
    private final NumberingDefinitions numberingDefinitions;
    private final ContentCategoriesDetection contentCategoriesDetection;
    private final StrippableAttributes drawingRunPropertiesStrippableAttributes;
    private final StrippableAttributes wordParagraphRevisions;
    private final SkippableElements emptySkippableElements;
    private final SkippableElements defaultSkippableElements;
    private final SkippableElements blockPropertiesSkippableElements;
    private final BlockSkippableElements blockSkippableElements;
    private final RunBuilderSkipper runBuilderSkipper;
    private final Block.Builder builder;
    private final Queue<XMLEvent> deferredEvents;
    private String paragraphStyle;

    BlockParser(StartElementContext startElementContext, StyleDefinitions styleDefinitions, StyleOptimisation styleOptimisation, NumberingDefinitions numberingDefinitions, ContentCategoriesDetection contentCategoriesDetection) {
        this.startElementContext = startElementContext;
        this.nestedIds = new IdGenerator(null);
        this.styleDefinitions = styleDefinitions;
        this.styleOptimisation = styleOptimisation;
        this.numberingDefinitions = numberingDefinitions;
        this.contentCategoriesDetection = contentCategoriesDetection;
        this.drawingRunPropertiesStrippableAttributes = new StrippableAttributes.DrawingRunProperties(startElementContext.getConditionalParameters(), startElementContext.getEventFactory());
        this.wordParagraphRevisions = new StrippableAttributes.WordParagraphRevisions(startElementContext.getEventFactory());
        this.emptySkippableElements = new SkippableElements.Empty();
        this.defaultSkippableElements = new SkippableElements.Default(new SkippableElement[0]);
        this.blockPropertiesSkippableElements = new SkippableElements.RevisionProperty(new SkippableElements.Property(new SkippableElements.Default(SkippableElement.RunProperty.RUN_PROPERTY_RTL_DML, SkippableElement.RunProperty.RUN_PROPERTY_LANGUAGE, SkippableElement.RunProperty.RUN_PROPERTY_NO_SPELLING_OR_GRAMMAR, SkippableElement.RevisionProperty.RUN_PROPERTY_INSERTED_PARAGRAPH_MARK, SkippableElement.RevisionProperty.RUN_PROPERTY_MOVED_PARAGRAPH_TO, SkippableElement.RevisionProperty.RUN_PROPERTY_MOVED_PARAGRAPH_FROM, SkippableElement.RevisionProperty.PARAGRAPH_PROPERTIES_CHANGE, SkippableElement.RevisionProperty.RUN_PROPERTIES_CHANGE), startElementContext.getConditionalParameters()), startElementContext.getConditionalParameters());
        this.blockSkippableElements = new BlockSkippableElements(startElementContext);
        this.runBuilderSkipper = new RunBuilderSkipper();
        this.builder = new Block.Builder();
        this.deferredEvents = new LinkedList<XMLEvent>();
    }

    private static boolean isSimpleFieldStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_SIMPLE_FIELD);
    }

    private void addRunsToBuilder(Block.Builder builder, RunMerger runMerger) throws XMLStreamException {
        for (Chunk chunk : runMerger.getRuns()) {
            builder.add(chunk);
        }
        runMerger.reset();
    }

    private void parseRunContainer(ChunkContainer chunkContainer, StartElement runContainerStart) throws XMLStreamException {
        RunContainer.Builder rcb = new RunContainer.Builder(this.startElementContext.getConditionalParameters(), this.startElementContext.getEventFactory(), runContainerStart);
        RunMerger runMerger = new RunMerger(this.startElementContext.getConditionalParameters());
        rcb.addType(RunContainer.Type.fromString(runContainerStart.getName().getLocalPart()));
        rcb.addToStartMarkup(MarkupComponentFactory.createStartMarkupComponent(this.startElementContext.getEventFactory(), runContainerStart));
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent e = this.startElementContext.getEventReader().nextEvent();
            if (e.isEndElement() && runContainerStart.getName().equals(e.asEndElement().getName())) {
                rcb.add(runMerger.getRuns());
                runMerger.reset();
                rcb.addToEndMarkup(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
                chunkContainer.add(rcb.build());
                return;
            }
            if (XMLEventHelpers.isRunStartEvent(e)) {
                this.processRun(runMerger, e.asStartElement());
                continue;
            }
            if (RunContainer.isStart(e)) {
                rcb.add(runMerger.getRuns());
                runMerger.reset();
                this.parseRunContainer(rcb, e.asStartElement());
                continue;
            }
            if (RunContainer.isPropertiesStart(e)) {
                rcb.addToStartMarkup(new MarkupComponentParser().parseBlockProperties(new StartElementContext(e.asStartElement(), this.startElementContext), this.drawingRunPropertiesStrippableAttributes, this.emptySkippableElements));
                continue;
            }
            if (RunContainer.isContentStart(e)) {
                rcb.addToStartMarkup(MarkupComponentFactory.createStartMarkupComponent(this.startElementContext.getEventFactory(), e.asStartElement()));
                continue;
            }
            if (!RunContainer.isContentEnd(e)) continue;
            rcb.addToEndMarkup(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
        }
        throw new IllegalStateException("Invalid content? Unterminated run container");
    }

    @Override
    public Block parse() throws XMLStreamException {
        this.log("startBlock: " + String.valueOf(this.startElementContext.getStartElement()));
        this.builder.addToMarkup(new MarkupComponent.StyledStart(this.startElementContext.getEventFactory(), this.styleDefinitions, this.wordParagraphRevisions.strip(this.startElementContext.getStartElement())));
        RunMerger runMerger = new RunMerger(this.startElementContext.getConditionalParameters());
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent e = this.startElementContext.getEventReader().nextEvent();
            if (XMLEventHelpers.isParagraphPropertiesStartEvent(e)) {
                StartElementContext blockPropertiesElementContext = new StartElementContext(e.asStartElement(), this.startElementContext);
                ParagraphBlockProperties blockProperties = new MarkupComponentParser().parseParagraphBlockProperties(blockPropertiesElementContext, this.drawingRunPropertiesStrippableAttributes, this.blockPropertiesSkippableElements);
                if (!blockProperties.isEmpty()) {
                    if (blockProperties.containsRunPropertyDeletedParagraphMark()) {
                        this.builder.mergeable(true);
                    } else {
                        this.builder.addToMarkup(blockProperties);
                    }
                }
                this.paragraphStyle = blockProperties.paragraphStyle();
                runMerger.setParagraphStyle(this.paragraphStyle);
                continue;
            }
            if (XMLEventHelpers.isRunStartEvent(e)) {
                this.processRun(runMerger, e.asStartElement());
                if (this.deferredEvents.isEmpty() || !XMLEventHelpers.isParagraphEndEvent(this.deferredEvents.peek())) continue;
                this.addRunsToBuilder(this.builder, runMerger);
                this.builder.addToMarkup(MarkupComponentFactory.createEndMarkupComponent(this.deferredEvents.poll().asEndElement()));
                this.builder.addDeferredEvents(this.deferredEvents);
                this.builder.styleOptimisation(this.styleOptimisation);
                this.builder.numberingDefinitions(this.numberingDefinitions);
                return this.builder.build();
            }
            if (this.startElementContext.getConditionalParameters().getAddLineSeparatorCharacter() && XMLEventHelpers.isLineBreakStartEvent(e) && runMerger.hasRunBuilder()) {
                runMerger.addToRunTextInRunBuilder(String.valueOf(this.startElementContext.getConditionalParameters().getLineSeparatorReplacement()));
                this.defaultSkippableElements.skip(new StartElementContext(e.asStartElement(), this.startElementContext));
                continue;
            }
            if (RunContainer.isStart(e)) {
                StartElement runContainerStart = e.asStartElement();
                this.addRunsToBuilder(this.builder, runMerger);
                this.parseRunContainer(this.builder, runContainerStart);
                continue;
            }
            if (BlockParser.isSimpleFieldStartEvent(e)) {
                this.addRunsToBuilder(this.builder, runMerger);
                StartElementContext simpleFieldElementContext = new StartElementContext(e.asStartElement(), this.startElementContext);
                for (XMLEvent fldEvent : XMLEventHelpers.gatherEvents(simpleFieldElementContext)) {
                    this.builder.addToMarkup(fldEvent);
                }
                this.builder.flushMarkup();
                continue;
            }
            if (e.isStartElement() && ("rPr".equals(e.asStartElement().getName().getLocalPart()) || "endParaRPr".equals(e.asStartElement().getName().getLocalPart()))) {
                RunProperties runProperties = new RunPropertiesParser(new StartElementContext(e.asStartElement(), this.startElementContext), new RunSkippableElements(this.startElementContext)).parse();
                this.addRunsToBuilder(this.builder, runMerger);
                if (this.builder.chunksEmpty()) {
                    this.builder.flushMarkup();
                }
                this.builder.addToMarkup(runProperties);
                continue;
            }
            if (this.blockSkippableElements.skip(e)) {
                if (!this.blockSkippableElements.blockCrossed()) continue;
                this.builder.skipped(true);
                this.builder.skippedExtraStructure(this.blockSkippableElements.extraStructureCrossed());
                this.builder.styleOptimisation(new StyleOptimisation.Bypass());
                this.builder.numberingDefinitions(this.numberingDefinitions);
                return this.builder.build();
            }
            if (XMLEventHelpers.isWhitespace(e)) continue;
            this.addRunsToBuilder(this.builder, runMerger);
            if (e.isEndElement() && this.startElementContext.getStartElement().getName().equals(e.asEndElement().getName())) {
                this.log("End block: " + String.valueOf(e));
                if (this.builder.chunksEmpty()) {
                    this.builder.flushMarkup();
                }
                this.builder.addToMarkup(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
                this.builder.styleOptimisation(this.styleOptimisation);
                this.builder.numberingDefinitions(this.numberingDefinitions);
                return this.builder.build();
            }
            this.builder.addToMarkup(e);
        }
        throw new IllegalStateException("Invalid content? Unterminated paragraph");
    }

    private void processRun(RunMerger runMerger, StartElement startEl) throws XMLStreamException {
        StartElementContext runElementContext = new StartElementContext(startEl, this.startElementContext);
        RunBuilder runBuilder = new RunParser(runElementContext, this.nestedIds, this.styleDefinitions, this.styleOptimisation, this.numberingDefinitions, this.contentCategoriesDetection, this.paragraphStyle, this.builder.hidden()).parse();
        this.deferredEvents.addAll(runBuilder.deferredEvents());
        if (this.runBuilderSkipper.canSkip(runBuilder)) {
            return;
        }
        this.builder.runName(startEl.getName());
        this.builder.textName(runBuilder.getTextName());
        this.builder.mergeable(runBuilder.containsMergeableMarkup());
        runMerger.add(runBuilder);
    }

    private void log(String s) {
        this.LOGGER.debug(s);
    }
}

