/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.openxml.AdditiveCollection;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunPropertiesClarification;
import net.sf.okapi.filters.openxml.RunPropertiesPairWithDetectedRunFonts;
import net.sf.okapi.filters.openxml.TextUnitWriter;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlockTextUnitWriter
implements TextUnitWriter {
    private static final String EMPTY = "";
    private final Logger LOGGER = LoggerFactory.getLogger(BlockTextUnitWriter.class);
    private final ConditionalParameters parameters;
    private final XMLEventFactory eventFactory;
    private final LocaleId locale;
    private final QName runName;
    private final QName textName;
    private final RunPropertiesPairWithDetectedRunFonts baseRunPropertiesPairWithDetectedRunFonts;
    private final List<XMLEvents> leadingCodes;
    private final Map<Integer, Object> codes;
    private final AdditiveCollection<XMLEvent> xmlEvents;
    private final RunPropertiesClarification runPropertiesClarification;
    private final Deque<RunPropertiesPairWithDetectedRunFonts> currentRunPropertiesPairWithDetectedRunFonts;
    private StringBuilder textContent;
    private boolean runOpen;

    BlockTextUnitWriter(ConditionalParameters parameters, XMLEventFactory eventFactory, LocaleId locale, QName runName, QName textName, RunPropertiesPairWithDetectedRunFonts baseRunPropertiesPairWithDetectedRunFonts, List<XMLEvents> leadingCodes, Map<Integer, Object> codes, AdditiveCollection<XMLEvent> xmlEvents, RunPropertiesClarification runPropertiesClarification) {
        this(parameters, eventFactory, locale, runName, textName, baseRunPropertiesPairWithDetectedRunFonts, leadingCodes, codes, xmlEvents, runPropertiesClarification, new ArrayDeque<RunPropertiesPairWithDetectedRunFonts>());
    }

    BlockTextUnitWriter(ConditionalParameters parameters, XMLEventFactory eventFactory, LocaleId locale, QName runName, QName textName, RunPropertiesPairWithDetectedRunFonts baseRunPropertiesPairWithDetectedRunFonts, List<XMLEvents> leadingCodes, Map<Integer, Object> codes, AdditiveCollection<XMLEvent> xmlEvents, RunPropertiesClarification runPropertiesClarification, Deque<RunPropertiesPairWithDetectedRunFonts> currentRunPropertiesPairWithDetectedRunFonts) {
        this.parameters = parameters;
        this.eventFactory = eventFactory;
        this.locale = locale;
        this.runName = runName;
        this.textName = textName;
        this.baseRunPropertiesPairWithDetectedRunFonts = baseRunPropertiesPairWithDetectedRunFonts;
        this.leadingCodes = leadingCodes;
        this.codes = codes;
        this.xmlEvents = xmlEvents;
        this.runPropertiesClarification = runPropertiesClarification;
        this.currentRunPropertiesPairWithDetectedRunFonts = currentRunPropertiesPairWithDetectedRunFonts;
    }

    @Override
    public void write(TextContainer tc) {
        this.textContent = new StringBuilder();
        boolean firstSegmentWritten = false;
        for (Segment segment : tc.getSegments()) {
            if (!firstSegmentWritten) {
                this.writeFirstSegment(tc.getFirstSegment());
                firstSegmentWritten = true;
                continue;
            }
            this.writeSegment(segment);
        }
        this.flushText(true);
    }

    private void writeFirstSegment(Segment segment) {
        for (XMLEvents events : this.leadingCodes) {
            this.xmlEvents.addAll(events.getEvents());
        }
        this.writeSegment(segment);
    }

    private void writeSegment(Segment segment) {
        try {
            TextFragment content = segment.getContent();
            String codedText = content.getCodedText();
            List<Code> codes = content.getCodes();
            for (int i = 0; i < codedText.length(); ++i) {
                char c = codedText.charAt(i);
                if (TextFragment.isMarker(c)) {
                    int codeIndex = TextFragment.toIndex(codedText.charAt(++i));
                    this.writeCode(codes.get(codeIndex));
                    continue;
                }
                this.writeChar(c);
            }
        }
        catch (Exception e) {
            this.LOGGER.error("Threw {} writing segment id {} '{}'", new Object[]{e.getClass().getSimpleName(), segment.getId(), segment.toString()});
            throw e;
        }
    }

    private void writeChar(char c) {
        this.textContent.append(c);
    }

    private void writeCode(Code code) {
        if (code.isMarkerMasking()) {
            String data = code.getData();
            for (int i = 0; i < data.length(); ++i) {
                char c = data.charAt(i);
                this.writeChar(c);
            }
            return;
        }
        int id = code.getId();
        Object codeObject = this.codes.get(id);
        switch (code.getTagType()) {
            case OPENING: {
                this.flushText(true);
                if (codeObject instanceof RunPropertiesPairWithDetectedRunFonts) {
                    this.currentRunPropertiesPairWithDetectedRunFonts.push((RunPropertiesPairWithDetectedRunFonts)codeObject);
                    break;
                }
                if (codeObject instanceof RunContainer) {
                    RunContainer rc = (RunContainer)codeObject;
                    this.xmlEvents.addAll(rc.startMarkupEvents());
                    this.currentRunPropertiesPairWithDetectedRunFonts.push(rc.defaultRunPropertiesPairWithDetectedRunFonts());
                    break;
                }
                throw new IllegalStateException("Unexpected code contents for opening code '" + String.valueOf(code) + "': " + String.valueOf(codeObject));
            }
            case PLACEHOLDER: {
                if (codeObject instanceof String) {
                    this.textContent.append(codeObject);
                    break;
                }
                if (codeObject instanceof Run.Markup) {
                    this.flush((Run.Markup)codeObject);
                    break;
                }
                if (codeObject instanceof XMLEvents) {
                    this.flushText(true);
                    this.xmlEvents.addAll(((XMLEvents)codeObject).getEvents());
                    break;
                }
                throw new IllegalStateException("Unexpected code contents for isolated code '" + String.valueOf(code) + "': " + String.valueOf(codeObject));
            }
            case CLOSING: {
                this.flushText(true);
                if (codeObject instanceof RunPropertiesPairWithDetectedRunFonts) {
                    this.currentRunPropertiesPairWithDetectedRunFonts.pop();
                    break;
                }
                if (codeObject instanceof RunContainer) {
                    RunContainer rc = (RunContainer)codeObject;
                    this.xmlEvents.addAll(rc.endMarkupEvents());
                    this.currentRunPropertiesPairWithDetectedRunFonts.pop();
                    break;
                }
                throw new IllegalStateException("Unexpected code contents for closing code '" + String.valueOf(code) + "':" + String.valueOf(codeObject));
            }
        }
    }

    private void flush(Run.Markup codeEvents) {
        this.flushText(false);
        this.flushRunStart();
        for (MarkupComponent mc : codeEvents.components()) {
            if (mc instanceof MarkupComponent.Start && XMLEventHelpers.isLineBreakStartEvent(mc.getEvents().get(0))) {
                this.flushRunEnd();
                if ("w".equals(((MarkupComponent.Start)mc).getName().getPrefix())) {
                    this.flushRunStart();
                }
            }
            this.xmlEvents.addAll(mc.getEvents());
        }
    }

    private void flushRunStart() {
        if (!this.runOpen) {
            this.writeRunStart();
        }
    }

    private void flushRunEnd() {
        if (this.runOpen) {
            this.writeRunEnd();
        }
    }

    private void flushText(boolean terminateRun) {
        RunPropertiesPairWithDetectedRunFonts rppwdrf = this.runPropertiesPairWithDetectedRunFonts();
        if (this.textContent.length() > 0) {
            String text = this.textContent.toString();
            this.runPropertiesClarification.prepareContextWith(rppwdrf.combined(), rppwdrf.detectedRunFonts(), text);
            this.flushRunStart();
            this.writeRunText(text);
            this.textContent = new StringBuilder();
        } else {
            this.runPropertiesClarification.prepareContextWith(rppwdrf.combined(), rppwdrf.detectedRunFonts(), EMPTY);
        }
        if (terminateRun) {
            this.flushRunEnd();
        }
    }

    private RunPropertiesPairWithDetectedRunFonts runPropertiesPairWithDetectedRunFonts() {
        return this.currentRunPropertiesPairWithDetectedRunFonts.isEmpty() ? this.baseRunPropertiesPairWithDetectedRunFonts : this.currentRunPropertiesPairWithDetectedRunFonts.peek();
    }

    private void writeRunStart() {
        RunPropertiesPairWithDetectedRunFonts rpp = this.runPropertiesPairWithDetectedRunFonts();
        this.xmlEvents.add(this.eventFactory.createStartElement(this.runName, null, null));
        this.runPropertiesClarification.performFor(rpp.direct());
        this.xmlEvents.addAll(rpp.direct().getEvents());
        this.runOpen = true;
    }

    private void writeRunText(String text) {
        if (this.textName.getPrefix().isEmpty()) {
            this.writeTextIfNeeded(new StringBuilder(text));
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (c == this.parameters.getLineSeparatorReplacement() && this.parameters.getAddLineSeparatorCharacter()) {
                this.writeTextIfNeeded(sb);
                this.writeLineBreakAt(sb.length());
                sb.setLength(0);
                continue;
            }
            if (c == '\t' && this.parameters.getAddTabAsCharacter() && "w".equals(this.textName.getPrefix())) {
                this.writeTextIfNeeded(sb);
                sb.setLength(0);
                this.writeTab();
                continue;
            }
            sb.append(c);
        }
        this.writeTextIfNeeded(sb);
    }

    private void writeTextIfNeeded(StringBuilder buffer) {
        if (buffer.length() > 0) {
            this.flushRunStart();
            this.writeText(buffer.toString());
        }
    }

    private void writeTab() {
        QName br = XMLEventHelpers.createQName("tab", this.textName);
        this.xmlEvents.add(this.eventFactory.createStartElement(br, null, null));
        this.xmlEvents.add(this.eventFactory.createEndElement(br, null));
    }

    private void writeLineBreakAt(int position) {
        if (!this.runOpen) {
            this.writeRunStart();
        }
        if ("a".equals(this.textName.getPrefix())) {
            if (this.runOpen && 0 < position) {
                this.writeRunEnd();
                this.writeRunStart();
            }
            this.writeText(EMPTY);
            this.writeRunEnd();
        } else {
            this.writeRunEnd();
            this.writeRunStart();
        }
        QName br = XMLEventHelpers.createQName("br", this.textName);
        this.xmlEvents.add(this.eventFactory.createStartElement(br, null, null));
        if ("a".equals(this.textName.getPrefix())) {
            RunPropertiesPairWithDetectedRunFonts rpp = this.runPropertiesPairWithDetectedRunFonts();
            this.runPropertiesClarification.performFor(rpp.direct());
            this.xmlEvents.addAll(rpp.direct().getEvents());
        }
        this.xmlEvents.add(this.eventFactory.createEndElement(br, null));
    }

    private void writeText(String text) {
        boolean needsPreserveSpace = BlockTextUnitWriter.needsXmlSpacePreserve(text);
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        if (needsPreserveSpace && !Namespaces.DrawingML.containsName(this.textName)) {
            attrs.add(this.eventFactory.createAttribute("xml", Namespaces.XML.getURI(), "space", "preserve"));
        }
        this.xmlEvents.add(this.eventFactory.createStartElement(this.textName, attrs.iterator(), null));
        this.xmlEvents.add(this.eventFactory.createCharacters(text));
        this.xmlEvents.add(this.eventFactory.createEndElement(this.textName, null));
    }

    private void writeRunEnd() {
        this.xmlEvents.add(this.eventFactory.createEndElement(this.runName, null));
        this.runOpen = false;
    }

    static boolean needsXmlSpacePreserve(String text) {
        for (char c : text.toCharArray()) {
            if (!Character.isWhitespace(c) && c != '\u00a0') continue;
            return true;
        }
        return false;
    }
}

