/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.events.Attribute;

enum CellType {
    BOOLEAN("b"),
    DATE("d"),
    ERROR("e"),
    NUMBER("n"),
    STRING("str"),
    INLINE_STRING("inlineStr"),
    SHARED_STRING("s");

    private static final Map<String, CellType> stringLookup;
    private final String value;

    private CellType(String value) {
        this.value = value;
    }

    static CellType from(Attribute attribute) {
        if (null == attribute) {
            return NUMBER;
        }
        return CellType.from(attribute.getValue());
    }

    static CellType from(String string) {
        return stringLookup.getOrDefault(string, NUMBER);
    }

    public String toString() {
        return this.value;
    }

    static {
        stringLookup = Arrays.stream(CellType.values()).collect(Collectors.toMap(c -> c.value, c -> c));
    }
}

