/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Relationship;
import net.sf.okapi.filters.openxml.Relationships;

interface ChartFragments {
    public ExternalSource externalSource();

    public QName externalDataName();

    public List<XMLEvent> events();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public static final class ExternalSource {
        private final String id;
        private final String path;

        ExternalSource(String id, String path) {
            this.id = id;
            this.path = path;
        }

        String id() {
            return this.id;
        }

        String path() {
            return this.path;
        }
    }

    public static final class Default
    implements ChartFragments {
        private static final String CHART_SPACE = "chartSpace";
        private static final String EXTERNAL_DATA = "externalData";
        private static final String ID = "id";
        private final Relationships relationships;
        private final List<XMLEvent> events;
        private QName id;
        private ExternalSource externalSource;
        private QName externalDataName;

        Default(Relationships relationships) {
            this(relationships, new ArrayList<XMLEvent>());
        }

        Default(Relationships relationships, List<XMLEvent> events) {
            this.relationships = relationships;
            this.events = events;
        }

        @Override
        public ExternalSource externalSource() {
            if (null == this.externalSource) {
                this.externalSource = Empty.externalSource;
            }
            return this.externalSource;
        }

        @Override
        public QName externalDataName() {
            if (null == this.externalDataName) {
                this.externalDataName = Empty.name;
            }
            return this.externalDataName;
        }

        @Override
        public List<XMLEvent> events() {
            return this.events;
        }

        @Override
        public void readWith(XMLEventReader eventReader) throws XMLStreamException {
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (e.isStartElement()) {
                    StartElement el = e.asStartElement();
                    if (CHART_SPACE.equals(el.getName().getLocalPart())) {
                        this.qualifyNames(el);
                    } else if (EXTERNAL_DATA.equals(el.getName().getLocalPart())) {
                        Attribute id = el.getAttributeByName(this.id);
                        if (null != id) {
                            this.externalSource = new ExternalSource(id.getValue(), this.relationshipTargetFor(id.getValue()));
                        }
                        this.externalDataName = el.getName();
                    }
                }
                this.events.add(e);
            }
        }

        private void qualifyNames(StartElement startElement) {
            this.id = new QName(startElement.getNamespaceURI("r"), ID, "r");
        }

        private String relationshipTargetFor(String id) {
            Iterator<Relationship> ri = this.relationships.with(id).iterator();
            if (!ri.hasNext()) {
                throw new IllegalStateException("A non-existent relationship is requested: " + id);
            }
            return ri.next().target();
        }
    }

    public static final class Empty
    implements ChartFragments {
        private static final String STRING = "";
        private static final ExternalSource externalSource = new ExternalSource("", "");
        private static final QName name = new QName("");

        @Override
        public ExternalSource externalSource() {
            return externalSource;
        }

        @Override
        public QName externalDataName() {
            return name;
        }

        @Override
        public List<XMLEvent> events() {
            return Collections.emptyList();
        }

        @Override
        public void readWith(XMLEventReader eventReader) throws XMLStreamException {
        }
    }
}

