/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.IndexedColors;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.RunFonts;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.SystemColorValues;
import net.sf.okapi.filters.openxml.Theme;

class ClarificationContext {
    private final ConditionalParameters conditionalParameters;
    private final CreationalParameters creationalParameters;
    private final PresetColorValues presetColorValues;
    private final PresetColorValues highlightColorValues;
    private final SystemColorValues systemColorValues;
    private final IndexedColors indexedColors;
    private final Theme theme;
    private final LocaleId sourceLocale;
    private final LocaleId targetLocale;
    private Boolean sourceRtl;
    private Boolean targetRtl;
    private Boolean targetHasCharactersAsNumeralSeparators;
    private StyleDefinitions styleDefinitions;
    private ParagraphBlockProperties combinedParagraphProperties;
    private String paragraphStyle;
    private RunProperties combinedRunProperties;
    private RunFonts detectedRunFonts;
    private String runText;
    private MarkupComponent.Context markupComponentContext;

    ClarificationContext(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, PresetColorValues presetColorValues, PresetColorValues highlightColorValues, SystemColorValues systemColorValues, IndexedColors indexedColors, Theme theme, LocaleId sourceLocale, LocaleId targetLocale) {
        this.conditionalParameters = conditionalParameters;
        this.creationalParameters = creationalParameters;
        this.presetColorValues = presetColorValues;
        this.highlightColorValues = highlightColorValues;
        this.systemColorValues = systemColorValues;
        this.indexedColors = indexedColors;
        this.theme = theme;
        this.sourceLocale = sourceLocale;
        this.targetLocale = targetLocale;
    }

    ConditionalParameters conditionalParameters() {
        return this.conditionalParameters;
    }

    CreationalParameters creationalParameters() {
        return this.creationalParameters;
    }

    PresetColorValues presetColorValues() {
        return this.presetColorValues;
    }

    PresetColorValues highlightColorValues() {
        return this.highlightColorValues;
    }

    SystemColorValues systemColorValues() {
        return this.systemColorValues;
    }

    IndexedColors indexedColors() {
        return this.indexedColors;
    }

    Theme theme() {
        return this.theme;
    }

    boolean sourceLtr() {
        return !this.sourceRtl();
    }

    boolean sourceRtl() {
        if (null == this.sourceRtl) {
            this.sourceRtl = LocaleId.isBidirectional(this.sourceLocale);
        }
        return this.sourceRtl;
    }

    boolean targetLtr() {
        return !this.targetRtl();
    }

    boolean targetRtl() {
        if (null == this.targetRtl) {
            this.targetRtl = LocaleId.isBidirectional(this.targetLocale);
        }
        return this.targetRtl;
    }

    boolean targetHasCharactersAsNumeralSeparators() {
        if (null == this.targetHasCharactersAsNumeralSeparators) {
            this.targetHasCharactersAsNumeralSeparators = LocaleId.hasCharactersAsNumeralSeparators(this.targetLocale);
        }
        return this.targetHasCharactersAsNumeralSeparators;
    }

    LocaleId targetLocale() {
        return this.targetLocale;
    }

    void adjust(StyleDefinitions styleDefinitions) {
        this.styleDefinitions = styleDefinitions;
    }

    private StyleDefinitions styleDefinitions() {
        if (null == this.styleDefinitions) {
            this.styleDefinitions = new StyleDefinitions.Empty();
        }
        return this.styleDefinitions;
    }

    void adjustCombinedParagraphPropertiesAndParagraphStyleFor(ParagraphBlockProperties paragraphProperties) {
        this.combinedParagraphProperties = this.styleDefinitions.combinedParagraphBlockProperties(paragraphProperties);
        this.paragraphStyle = paragraphProperties.paragraphStyle();
    }

    ParagraphBlockProperties combinedParagraphProperties() {
        return this.combinedParagraphProperties;
    }

    void adjustCombinedRunPropertiesFor(RunProperties runProperties) {
        RunProperty.StyleRunProperty runStyleProperty = runProperties.getRunStyleProperty();
        this.combinedRunProperties = this.styleDefinitions().combinedRunProperties(this.paragraphStyle, null == runStyleProperty ? null : runStyleProperty.value(), runProperties);
    }

    void adjustCombinedRunProperties(RunProperties combinedRunProperties) {
        this.combinedRunProperties = combinedRunProperties;
    }

    RunProperties combinedRunProperties() {
        return this.combinedRunProperties;
    }

    void adjustDetectedRunFonts(RunFonts detectedRunFonts) {
        this.detectedRunFonts = detectedRunFonts;
    }

    RunFonts detectedRunFonts() {
        return this.detectedRunFonts;
    }

    void adjustRunText(String runText) {
        this.runText = runText;
    }

    String runText() {
        return this.runText;
    }

    void adjust(MarkupComponent.Context context) {
        this.markupComponentContext = context;
    }

    MarkupComponent.Context markupComponentContext() {
        return this.markupComponentContext;
    }
}

