/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ColorScheme;
import net.sf.okapi.filters.openxml.IndexedColors;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.SystemColorValues;
import net.sf.okapi.filters.openxml.Theme;

public interface Color {
    public Value value();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static interface Value {
        default public boolean lessThanOrEqualTo(Value value) {
            int thisRed = Integer.valueOf(this.asRgb().substring(0, 2), 16);
            int thisGreen = Integer.valueOf(this.asRgb().substring(2, 4), 16);
            int thisBlue = Integer.valueOf(this.asRgb().substring(4, 6), 16);
            int otherRed = Integer.valueOf(value.asRgb().substring(0, 2), 16);
            int otherGreen = Integer.valueOf(value.asRgb().substring(2, 4), 16);
            int otherBlue = Integer.valueOf(value.asRgb().substring(4, 6), 16);
            return thisRed <= otherRed && thisGreen <= otherGreen && thisBlue <= otherBlue;
        }

        public boolean matches(String var1);

        public String asInternalName();

        public String asExternalName();

        public String asRgb();

        public static final class Empty
        implements Value {
            private static final String EMPTY = "";

            @Override
            public boolean lessThanOrEqualTo(Value value) {
                return true;
            }

            @Override
            public boolean matches(String value) {
                return EMPTY.equals(value);
            }

            @Override
            public String asInternalName() {
                return EMPTY;
            }

            @Override
            public String asExternalName() {
                return EMPTY;
            }

            @Override
            public String asRgb() {
                return EMPTY;
            }
        }
    }

    public static final class Preset
    implements Color {
        static final String NAME = "prstClr";
        static final String HIGHLIGHT_NAME = "highlight";
        private final PresetColorValues presetColorValues;
        private final Default defaultColor;
        private Value value;

        Preset(PresetColorValues presetColorValues, Default defaultColor) {
            this.presetColorValues = presetColorValues;
            this.defaultColor = defaultColor;
        }

        @Override
        public Value value() {
            if (null == this.value) {
                this.value = this.presetColorValues.valueFor(this.defaultColor.value().asInternalName());
            }
            return this.value;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.defaultColor.readWith(reader);
        }

        @Override
        public Markup asMarkup() {
            return this.defaultColor.asMarkup();
        }
    }

    public static final class Scheme
    implements Color {
        static final String NAME = "schemeClr";
        private final PresetColorValues presetColorValues;
        private final ColorScheme colorScheme;
        private final Default defaultColor;
        private net.sf.okapi.filters.openxml.Color$Value value;

        Scheme(PresetColorValues presetColorValues, ColorScheme colorScheme, Default defaultColor) {
            this.presetColorValues = presetColorValues;
            this.colorScheme = colorScheme;
            this.defaultColor = defaultColor;
        }

        @Override
        public net.sf.okapi.filters.openxml.Color$Value value() {
            if (null == this.value) {
                this.value = new Value(this.presetColorValues, this.colorScheme, this.defaultColor.value().asInternalName());
            }
            return this.value;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.defaultColor.readWith(reader);
        }

        @Override
        public Markup asMarkup() {
            return this.defaultColor.asMarkup();
        }

        static final class Value
        implements net.sf.okapi.filters.openxml.Color$Value {
            private final PresetColorValues presetColorValues;
            private final ColorScheme colorScheme;
            private final int index;
            private net.sf.okapi.filters.openxml.Color$Value presetColorValue;
            private String internalName;
            private String externalName;
            private String rgb;

            Value(PresetColorValues presetColorValues, ColorScheme colorScheme, String index) {
                this(presetColorValues, colorScheme, Integer.parseUnsignedInt(index));
            }

            Value(PresetColorValues presetColorValues, ColorScheme colorScheme, int index) {
                this.presetColorValues = presetColorValues;
                this.colorScheme = colorScheme;
                this.index = index;
            }

            @Override
            public boolean matches(String value) {
                String rgb = this.asRgb();
                net.sf.okapi.filters.openxml.Color$Value cv = this.presetColorValueFor(rgb);
                return rgb.equals(value) || cv.asExternalName().equalsIgnoreCase(value) || cv.asInternalName().equals(value);
            }

            private net.sf.okapi.filters.openxml.Color$Value presetColorValueFor(String string) {
                if (null == this.presetColorValue) {
                    this.presetColorValue = this.presetColorValues.valueFor(string);
                }
                return this.presetColorValue;
            }

            @Override
            public String asInternalName() {
                if (null == this.internalName) {
                    this.internalName = this.presetColorValueFor(this.asRgb()).asInternalName();
                }
                return this.internalName;
            }

            @Override
            public String asExternalName() {
                if (null == this.externalName) {
                    this.externalName = this.presetColorValueFor(this.asRgb()).asExternalName();
                }
                return this.externalName;
            }

            @Override
            public String asRgb() {
                if (null == this.rgb) {
                    this.rgb = this.colorScheme.colorValueFor(this.index);
                }
                return this.rgb;
            }
        }
    }

    public static final class System
    implements Color {
        static final String NAME = "sysClr";
        static final String DEFAULT_BACKGROUND_NAME = "window";
        static final String DEFAULT_FOREGROUND_NAME = "windowText";
        static final String INFO_TEXT_NAME = "infoText";
        private static final QName LAST_COLOR = new QName("lastClr");
        private final Default defaultColor;
        private Value value;

        System(Default defaultColor) {
            this.defaultColor = defaultColor;
        }

        @Override
        public net.sf.okapi.filters.openxml.Color$Value value() {
            if (null == this.value) {
                this.value = new Value(this.defaultColor.value().asInternalName(), this.defaultColor.startElement.getAttributeByName(LAST_COLOR).getValue());
            }
            return this.value;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.defaultColor.readWith(reader);
        }

        @Override
        public Markup asMarkup() {
            return this.defaultColor.asMarkup();
        }

        static final class Value
        implements net.sf.okapi.filters.openxml.Color$Value {
            static final String DEFAULT_BACKGROUND = "FFFFFF";
            static final String DEFAULT_FOREGROUND = "000000";
            private static final String EMPTY = "";
            private final String name;
            private final String rgb;

            Value(String name, String rgb) {
                this.name = name;
                this.rgb = rgb;
            }

            @Override
            public boolean matches(String value) {
                return this.rgb.equals(value) || this.name.equals(value);
            }

            @Override
            public String asInternalName() {
                return this.name;
            }

            @Override
            public String asExternalName() {
                return EMPTY;
            }

            @Override
            public String asRgb() {
                return this.rgb;
            }
        }
    }

    public static final class Hsl
    implements Color {
        static final String NAME = "hslClr";
        private static final String HUE = "hue";
        private static final String LUMINANCE = "lum";
        private static final String SATURATION = "sat";
        private final PresetColorValues presetColorValues;
        private final Default defaultColor;
        private net.sf.okapi.filters.openxml.Color$Value value;

        Hsl(PresetColorValues presetColorValues, Default defaultColor) {
            this.presetColorValues = presetColorValues;
            this.defaultColor = defaultColor;
        }

        @Override
        public net.sf.okapi.filters.openxml.Color$Value value() {
            if (null == this.value) {
                String hue = "";
                String luminance = "";
                String saturation = "";
                Iterator<Attribute> iterator = this.defaultColor.startElement.getAttributes();
                block10: while (iterator.hasNext()) {
                    Attribute a = iterator.next();
                    switch (a.getName().getLocalPart()) {
                        case "hue": {
                            hue = a.getValue();
                            continue block10;
                        }
                        case "lum": {
                            luminance = a.getValue();
                            continue block10;
                        }
                        case "sat": {
                            saturation = a.getValue();
                            continue block10;
                        }
                    }
                    throw new IllegalStateException("Unsupported attribute: ".concat(a.getName().getLocalPart()));
                }
                this.value = new Value(this.presetColorValues, hue, saturation, luminance);
            }
            return this.value;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.defaultColor.readWith(reader);
        }

        @Override
        public Markup asMarkup() {
            return this.defaultColor.asMarkup();
        }

        static final class Value
        implements net.sf.okapi.filters.openxml.Color$Value {
            private static final int DEGREE_SCALE = 60000;
            private final PresetColorValues presetColorValues;
            private final double hue;
            private final double saturation;
            private final double luminance;
            private net.sf.okapi.filters.openxml.Color$Value presetColorValue;
            private String internalName;
            private String externalName;
            private String rgb;

            Value(PresetColorValues presetColorValues, String hue, String saturation, String luminance) {
                this(presetColorValues, Double.parseDouble(hue) / 60000.0, Double.parseDouble(saturation) / 100000.0, Double.parseDouble(luminance) / 100000.0);
            }

            Value(PresetColorValues presetColorValues, double hue, double saturation, double luminance) {
                this.presetColorValues = presetColorValues;
                this.hue = hue;
                this.saturation = saturation;
                this.luminance = luminance;
            }

            @Override
            public boolean matches(String value) {
                String rgb = this.asRgb();
                net.sf.okapi.filters.openxml.Color$Value cv = this.presetColorValueFor(rgb);
                return rgb.equals(value) || cv.asExternalName().equalsIgnoreCase(value) || cv.asInternalName().equals(value);
            }

            private net.sf.okapi.filters.openxml.Color$Value presetColorValueFor(String string) {
                if (null == this.presetColorValue) {
                    this.presetColorValue = this.presetColorValues.valueFor(string);
                }
                return this.presetColorValue;
            }

            @Override
            public String asInternalName() {
                if (null == this.internalName) {
                    this.internalName = this.presetColorValueFor(this.asRgb()).asInternalName();
                }
                return this.internalName;
            }

            @Override
            public String asExternalName() {
                if (null == this.externalName) {
                    this.externalName = this.presetColorValueFor(this.asRgb()).asExternalName();
                }
                return this.externalName;
            }

            @Override
            public String asRgb() {
                if (null == this.rgb) {
                    double a = this.saturation * Math.min(this.luminance, 1.0 - this.luminance);
                    this.rgb = new PercentageRgb.Value(this.presetColorValues, Value.colorChannelValueFor(this.hue, this.luminance, a, 0.0), Value.colorChannelValueFor(this.hue, this.luminance, a, 8.0), Value.colorChannelValueFor(this.hue, this.luminance, a, 4.0)).asRgb();
                }
                return this.rgb;
            }

            private static double colorChannelValueFor(double h, double l, double a, double n) {
                double k = (n + h / 30.0) % 12.0;
                double t1 = Math.min(k - 3.0, 9.0 - k);
                double t2 = Math.min(t1, 1.0);
                return l - a * Math.max(-1.0, t2);
            }
        }
    }

    public static final class Argb
    implements Color {
        static final String RGB_NAME = "rgbColor";
        static final String BACKGROUND_NAME = "bgColor";
        static final String FOREGROUND_NAME = "fgColor";
        private static final String AUTO = "auto";
        private static final String INDEXED = "indexed";
        private static final String RGB = "rgb";
        private static final String THEME = "theme";
        private static final String TINT = "tint";
        private final PresetColorValues presetColorValues;
        private final SystemColorValues systemColorValues;
        private final IndexedColors indexedColors;
        private final Theme theme;
        private final Default defaultColor;
        private net.sf.okapi.filters.openxml.Color$Value value;

        Argb(PresetColorValues presetColorValues, SystemColorValues systemColorValues, IndexedColors indexedColors, Theme theme, Default defaultColor) {
            this.presetColorValues = presetColorValues;
            this.systemColorValues = systemColorValues;
            this.indexedColors = indexedColors;
            this.theme = theme;
            this.defaultColor = defaultColor;
        }

        @Override
        public net.sf.okapi.filters.openxml.Color$Value value() {
            if (null == this.value) {
                String tint = "";
                Iterator<Attribute> iterator = this.defaultColor.startElement.getAttributes();
                block14: while (iterator.hasNext()) {
                    Attribute a = iterator.next();
                    switch (a.getName().getLocalPart()) {
                        case "auto": {
                            this.value = new AutoValue(this.systemColorValues, this.defaultColor.startElement.getName().getLocalPart());
                        }
                        case "indexed": {
                            this.value = new IndexedColorValue(this.presetColorValues, this.indexedColors, a.getValue());
                            continue block14;
                        }
                        case "rgb": {
                            this.value = new Value(this.presetColorValues, a.getValue());
                            continue block14;
                        }
                        case "theme": {
                            this.value = new ThemeValue(this.presetColorValues, this.theme, a.getValue());
                            continue block14;
                        }
                        case "tint": {
                            tint = a.getValue();
                            continue block14;
                        }
                    }
                    throw new IllegalStateException("Unsupported attribute name: ".concat(a.getName().getLocalPart()));
                }
                if (!tint.isEmpty()) {
                    this.value = new ValueWithTint(this.presetColorValues, new PercentageRgb.Value(this.presetColorValues, this.value.asRgb()), tint);
                }
            }
            return this.value;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.defaultColor.readWith(reader);
        }

        @Override
        public Markup asMarkup() {
            return this.defaultColor.asMarkup();
        }

        static final class AutoValue
        implements net.sf.okapi.filters.openxml.Color$Value {
            private static final String EMPTY = "";
            private final SystemColorValues systemColorValues;
            private final String internalName;
            private net.sf.okapi.filters.openxml.Color$Value systemColorValue;
            private String rgb;

            AutoValue(SystemColorValues systemColorValues, String internalName) {
                this.systemColorValues = systemColorValues;
                this.internalName = internalName;
            }

            @Override
            public boolean matches(String value) {
                net.sf.okapi.filters.openxml.Color$Value cv = this.systemColorValueFor(this.internalName);
                return cv.asRgb().equals(value) || cv.asInternalName().equals(value);
            }

            private net.sf.okapi.filters.openxml.Color$Value systemColorValueFor(String internalName) {
                if (null == this.systemColorValue) {
                    this.systemColorValue = this.systemColorValues.valueFor(internalName);
                }
                return this.systemColorValue;
            }

            @Override
            public String asInternalName() {
                return this.internalName;
            }

            @Override
            public String asExternalName() {
                return EMPTY;
            }

            @Override
            public String asRgb() {
                if (null == this.rgb) {
                    this.rgb = this.systemColorValueFor(this.internalName).asRgb();
                }
                return this.rgb;
            }
        }

        static final class IndexedColorValue
        implements net.sf.okapi.filters.openxml.Color$Value {
            private final PresetColorValues presetColorValues;
            private final IndexedColors indexedColors;
            private final int index;
            private net.sf.okapi.filters.openxml.Color$Value presetColorValue;
            private String internalName;
            private String externalName;
            private String rgb;

            IndexedColorValue(PresetColorValues presetColorValues, IndexedColors indexedColors, String index) {
                this(presetColorValues, indexedColors, Integer.parseUnsignedInt(index));
            }

            IndexedColorValue(PresetColorValues presetColorValues, IndexedColors indexedColors, int index) {
                this.presetColorValues = presetColorValues;
                this.indexedColors = indexedColors;
                this.index = index;
            }

            @Override
            public boolean matches(String value) {
                String rgb = this.asRgb();
                net.sf.okapi.filters.openxml.Color$Value cv = this.presetColorValueFor(rgb);
                return rgb.equals(value) || cv.asExternalName().equalsIgnoreCase(value) || cv.asInternalName().equals(value);
            }

            private net.sf.okapi.filters.openxml.Color$Value presetColorValueFor(String string) {
                if (null == this.presetColorValue) {
                    this.presetColorValue = this.presetColorValues.valueFor(string);
                }
                return this.presetColorValue;
            }

            @Override
            public String asInternalName() {
                if (null == this.internalName) {
                    String rgb = this.asRgb();
                    net.sf.okapi.filters.openxml.Color$Value cv = this.presetColorValueFor(rgb);
                    this.internalName = cv.asInternalName();
                }
                return this.internalName;
            }

            @Override
            public String asExternalName() {
                if (null == this.externalName) {
                    String rgb = this.asRgb();
                    net.sf.okapi.filters.openxml.Color$Value cv = this.presetColorValueFor(rgb);
                    this.externalName = cv.asExternalName();
                }
                return this.externalName;
            }

            @Override
            public String asRgb() {
                if (null == this.rgb) {
                    this.rgb = this.indexedColors.rgbValueFor(this.index);
                }
                return this.rgb;
            }
        }

        static final class Value
        implements net.sf.okapi.filters.openxml.Color$Value {
            private static final String HEX_COLOR_REGEX = "([\\dA-Fa-f]{2})";
            private static final Pattern argbPattern = Pattern.compile("^".concat("([\\dA-Fa-f]{2})").concat("([\\dA-Fa-f]{2})").concat("([\\dA-Fa-f]{2})").concat("([\\dA-Fa-f]{2})").concat("$"));
            private final PresetColorValues presetColorValues;
            private final String argb;
            private net.sf.okapi.filters.openxml.Color$Value presetColorValue;
            private String internalName;
            private String externalName;
            private String rgb;

            Value(PresetColorValues presetColorValues, String argb) {
                this.presetColorValues = presetColorValues;
                this.argb = argb;
            }

            @Override
            public boolean matches(String value) {
                String rgb = this.asRgb();
                net.sf.okapi.filters.openxml.Color$Value cv = this.presetColorValueFor(rgb);
                return rgb.equals(value) || cv.asExternalName().equalsIgnoreCase(value) || cv.asInternalName().equals(value);
            }

            private net.sf.okapi.filters.openxml.Color$Value presetColorValueFor(String string) {
                if (null == this.presetColorValue) {
                    this.presetColorValue = this.presetColorValues.valueFor(string);
                }
                return this.presetColorValue;
            }

            @Override
            public String asInternalName() {
                if (null == this.internalName) {
                    this.internalName = this.presetColorValueFor(this.asRgb()).asInternalName();
                }
                return this.internalName;
            }

            @Override
            public String asExternalName() {
                if (null == this.externalName) {
                    this.externalName = this.presetColorValueFor(this.asRgb()).asExternalName();
                }
                return this.externalName;
            }

            @Override
            public String asRgb() {
                if (null == this.rgb) {
                    Matcher m = argbPattern.matcher(this.argb);
                    if (!m.matches()) {
                        throw new IllegalArgumentException("Unsupported ARGB value: ".concat(this.argb));
                    }
                    double alpha = (double)Integer.parseInt(m.group(1), 16) / 255.0;
                    int red = Integer.parseInt(m.group(2), 16);
                    int green = Integer.parseInt(m.group(3), 16);
                    int blue = Integer.parseInt(m.group(4), 16);
                    this.rgb = String.format("%06X", Math.round(alpha * (double)red) << 16 | Math.round(alpha * (double)green) << 8 | Math.round(alpha * (double)blue));
                }
                return this.rgb;
            }
        }

        static final class ThemeValue
        implements net.sf.okapi.filters.openxml.Color$Value {
            private final PresetColorValues presetColorValues;
            private final Theme theme;
            private final int index;
            private net.sf.okapi.filters.openxml.Color$Value presetColorValue;
            private String internalName;
            private String externalName;
            private String rgb;

            ThemeValue(PresetColorValues presetColorValues, Theme theme, String index) {
                this(presetColorValues, theme, Integer.parseUnsignedInt(index));
            }

            ThemeValue(PresetColorValues presetColorValues, Theme theme, int index) {
                this.presetColorValues = presetColorValues;
                this.theme = theme;
                this.index = index;
            }

            @Override
            public boolean matches(String value) {
                String rgb = this.asRgb();
                net.sf.okapi.filters.openxml.Color$Value cv = this.presetColorValueFor(rgb);
                return rgb.equals(value) || cv.asExternalName().equalsIgnoreCase(value) || cv.asInternalName().equals(value);
            }

            private net.sf.okapi.filters.openxml.Color$Value presetColorValueFor(String string) {
                if (null == this.presetColorValue) {
                    this.presetColorValue = this.presetColorValues.valueFor(string);
                }
                return this.presetColorValue;
            }

            @Override
            public String asInternalName() {
                if (null == this.internalName) {
                    this.internalName = this.presetColorValueFor(this.asRgb()).asInternalName();
                }
                return this.internalName;
            }

            @Override
            public String asExternalName() {
                if (null == this.externalName) {
                    this.externalName = this.presetColorValueFor(this.asRgb()).asExternalName();
                }
                return this.externalName;
            }

            @Override
            public String asRgb() {
                if (null == this.rgb) {
                    this.rgb = this.theme.rgbColorValueFor(this.index);
                }
                return this.rgb;
            }
        }

        static final class ValueWithTint
        implements net.sf.okapi.filters.openxml.Color$Value {
            private final PresetColorValues presetColorValues;
            private final PercentageRgb.Value value;
            private final double tint;
            private net.sf.okapi.filters.openxml.Color$Value presetColorValue;
            private String internalName;
            private String externalName;
            private String rgb;

            ValueWithTint(PresetColorValues presetColorValues, PercentageRgb.Value value, String tint) {
                this(presetColorValues, value, Double.parseDouble(tint));
            }

            ValueWithTint(PresetColorValues presetColorValues, PercentageRgb.Value value, double tint) {
                this.presetColorValues = presetColorValues;
                this.value = value;
                this.tint = tint;
            }

            @Override
            public boolean matches(String value) {
                String rgb = this.asRgb();
                net.sf.okapi.filters.openxml.Color$Value cv = this.presetColorValueFor(rgb);
                return rgb.equals(value) || cv.asExternalName().equalsIgnoreCase(value) || cv.asInternalName().equals(value);
            }

            private net.sf.okapi.filters.openxml.Color$Value presetColorValueFor(String string) {
                if (null == this.presetColorValue) {
                    this.presetColorValue = this.presetColorValues.valueFor(string);
                }
                return this.presetColorValue;
            }

            @Override
            public String asInternalName() {
                if (null == this.internalName) {
                    this.internalName = this.presetColorValueFor(this.asRgb()).asInternalName();
                }
                return this.internalName;
            }

            @Override
            public String asExternalName() {
                if (null == this.externalName) {
                    this.externalName = this.presetColorValueFor(this.asRgb()).asExternalName();
                }
                return this.externalName;
            }

            @Override
            public String asRgb() {
                if (null == this.rgb) {
                    String[] hsl = this.value.asHsl();
                    double l = Double.parseDouble(hsl[2]) / 100000.0;
                    String luminance = 0.0 == this.tint ? hsl[2] : (0.0 > this.tint ? String.format("%d", Math.round(l * (1.0 + this.tint) * 100000.0)) : String.format("%d", Math.round(l * (1.0 - this.tint) + (1.0 - (1.0 - this.tint)) * 100000.0)));
                    this.rgb = new Hsl.Value(this.presetColorValues, hsl[0], hsl[1], luminance).asRgb();
                }
                return this.rgb;
            }
        }
    }

    public static final class PercentageRgb
    implements Color {
        static final String NAME = "scrgbClr";
        private static final String R = "r";
        private static final String G = "g";
        private static final String B = "b";
        private final PresetColorValues presetColorValues;
        private final Default defaultColor;
        private net.sf.okapi.filters.openxml.Color$Value value;

        PercentageRgb(PresetColorValues presetColorValues, Default defaultColor) {
            this.presetColorValues = presetColorValues;
            this.defaultColor = defaultColor;
        }

        @Override
        public net.sf.okapi.filters.openxml.Color$Value value() {
            if (null == this.value) {
                Iterator<Attribute> iterator = this.defaultColor.startElement.getAttributes();
                String r = "";
                String g = "";
                String b = "";
                block10: while (iterator.hasNext()) {
                    Attribute a = iterator.next();
                    switch (a.getName().getLocalPart()) {
                        case "r": {
                            r = a.getValue();
                            continue block10;
                        }
                        case "g": {
                            g = a.getValue();
                            continue block10;
                        }
                        case "b": {
                            b = a.getValue();
                            continue block10;
                        }
                    }
                    throw new IllegalStateException("Unsupported attribute name: ".concat(a.getName().getLocalPart()));
                }
                this.value = new Value(this.presetColorValues, r, g, b);
            }
            return this.value;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.defaultColor.readWith(reader);
        }

        @Override
        public Markup asMarkup() {
            return this.defaultColor.asMarkup();
        }

        static class Value
        implements net.sf.okapi.filters.openxml.Color$Value {
            private static final int SCALE = 100000;
            private static final int MAX_PER_CHANNEL = 255;
            private static final int RADIX = 16;
            private final PresetColorValues presetColorValues;
            private final double redPercentage;
            private final double greenPercentage;
            private final double bluePercentage;
            private net.sf.okapi.filters.openxml.Color$Value presetColorValue;
            private String internalName;
            private String externalName;
            private String rgb;

            Value(PresetColorValues presetColorValues, String rgb) {
                this(presetColorValues, (double)Math.round((double)Integer.parseInt(rgb.substring(0, 2), 16) / 255.0 * 100000.0) / 100000.0, (double)Math.round((double)Integer.parseInt(rgb.substring(2, 4), 16) / 255.0 * 100000.0) / 100000.0, (double)Math.round((double)Integer.parseInt(rgb.substring(4, 6), 16) / 255.0 * 100000.0) / 100000.0);
            }

            Value(PresetColorValues presetColorValues, String redPercentage, String greenPercentage, String bluePercentage) {
                this(presetColorValues, Double.parseDouble(redPercentage) / 100000.0, Double.parseDouble(greenPercentage) / 100000.0, Double.parseDouble(bluePercentage) / 100000.0);
            }

            Value(PresetColorValues presetColorValues, double redPercentage, double greenPercentage, double bluePercentage) {
                this.presetColorValues = presetColorValues;
                this.redPercentage = redPercentage;
                this.greenPercentage = greenPercentage;
                this.bluePercentage = bluePercentage;
            }

            @Override
            public boolean matches(String value) {
                String rgb = this.asRgb();
                net.sf.okapi.filters.openxml.Color$Value cv = this.presetColorValueFor(rgb);
                return rgb.equals(value) || cv.asExternalName().equalsIgnoreCase(value) || cv.asInternalName().equals(value);
            }

            private net.sf.okapi.filters.openxml.Color$Value presetColorValueFor(String string) {
                if (null == this.presetColorValue) {
                    this.presetColorValue = this.presetColorValues.valueFor(string);
                }
                return this.presetColorValue;
            }

            @Override
            public String asInternalName() {
                if (null == this.internalName) {
                    this.internalName = this.presetColorValueFor(this.asRgb()).asInternalName();
                }
                return this.internalName;
            }

            @Override
            public String asExternalName() {
                if (null == this.externalName) {
                    this.externalName = this.presetColorValueFor(this.asRgb()).asExternalName();
                }
                return this.externalName;
            }

            @Override
            public String asRgb() {
                if (null == this.rgb) {
                    this.rgb = String.format("%02X%02X%02X", Math.round(255.0 * this.redPercentage), Math.round(255.0 * this.greenPercentage), Math.round(255.0 * this.bluePercentage));
                }
                return this.rgb;
            }

            String[] asHsl() {
                double[] percentages = this.asPercentages();
                double r = percentages[0] / 100000.0;
                double g = percentages[1] / 100000.0;
                double b = percentages[2] / 100000.0;
                double cMin = Math.min(Math.min(r, g), b);
                double cMax = Math.max(Math.max(r, g), b);
                double c = cMax - cMin;
                double h = 0.0 == cMax ? 0.0 : (r == cMax ? (g - b) / c + (double)(g < b ? 6 : 0) : (g == cMax ? (b - r) / c + 2.0 : (r - g) / c + 4.0));
                double l = (cMin + cMax) / 2.0;
                double s = c / (1.0 - Math.abs(2.0 * l - 1.0));
                return new String[]{String.format("%d", Math.round(h * 60.0 * 60000.0)), String.format("%d", Math.round(s * 100000.0)), String.format("%d", Math.round(l * 100000.0))};
            }

            double[] asPercentages() {
                return new double[]{Math.round(this.redPercentage * 100000.0), Math.round(this.greenPercentage * 100000.0), Math.round(this.bluePercentage * 100000.0)};
            }
        }
    }

    public static final class Default
    implements Color {
        static final String NAME = "srgbClr";
        private static final String HEX_COLOR_REGEX = "([\\dA-Fa-f]{2})";
        private static final Pattern rgbPattern = Pattern.compile("^".concat("([\\dA-Fa-f]{2})").concat("([\\dA-Fa-f]{2})").concat("([\\dA-Fa-f]{2})").concat("$"));
        private static final String EMPTY = "";
        private final PresetColorValues presetColorValues;
        private final StartElement startElement;
        private final QName valueAttributeName;
        private final List<XMLEvent> innerEvents;
        private EndElement endElement;
        private net.sf.okapi.filters.openxml.Color$Value value;

        Default(PresetColorValues presetColorValues, StartElement startElement) {
            this(presetColorValues, startElement, new QName("val"));
        }

        Default(PresetColorValues presetColorValues, StartElement startElement, QName valueAttributeName) {
            this(presetColorValues, startElement, valueAttributeName, new LinkedList<XMLEvent>());
        }

        Default(PresetColorValues presetColorValues, StartElement startElement, QName valueAttributeName, List<XMLEvent> innerEvents) {
            this.presetColorValues = presetColorValues;
            this.startElement = startElement;
            this.valueAttributeName = valueAttributeName;
            this.innerEvents = innerEvents;
        }

        @Override
        public net.sf.okapi.filters.openxml.Color$Value value() {
            if (null == this.value) {
                Matcher m;
                String sv = this.startElement.getAttributeByName(this.valueAttributeName).getValue();
                net.sf.okapi.filters.openxml.Color$Value cv = this.presetColorValues.valueFor(sv);
                this.value = cv.asInternalName().isEmpty() && cv.asExternalName().isEmpty() && cv.asRgb().isEmpty() ? ((m = rgbPattern.matcher(sv)).matches() ? new Value(EMPTY, EMPTY, sv) : new Value(sv, EMPTY, EMPTY)) : cv;
            }
            return this.value;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                this.innerEvents.add(e);
            }
        }

        @Override
        public Markup asMarkup() {
            if (null == this.endElement) {
                throw new IllegalStateException("The end element is not available");
            }
            MarkupBuilder mb = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>(1)), new ArrayList<XMLEvent>(2 + this.innerEvents.size()));
            mb.add(this.startElement);
            mb.addAll(this.innerEvents);
            mb.add(this.endElement);
            return mb.build();
        }

        static final class Value
        implements net.sf.okapi.filters.openxml.Color$Value {
            private final String internalName;
            private final String externalName;
            private final String rgb;

            Value(String internalName, String externalName, int red, int green, int blue) {
                this(internalName, externalName, String.format("%06X", red << 16 | green << 8 | blue));
            }

            Value(String internalName, String externalName, String rgb) {
                this.internalName = internalName;
                this.externalName = externalName;
                this.rgb = rgb;
            }

            @Override
            public boolean matches(String value) {
                return this.rgb.equals(value) || this.externalName.equalsIgnoreCase(value) || this.internalName.equals(value);
            }

            @Override
            public String asInternalName() {
                return this.internalName;
            }

            @Override
            public String asExternalName() {
                return this.externalName;
            }

            @Override
            public String asRgb() {
                return this.rgb;
            }
        }
    }

    public static final class Empty
    implements Color {
        private Value value;

        @Override
        public Value value() {
            if (null == this.value) {
                this.value = new Value.Empty();
            }
            return this.value;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
        }

        @Override
        public Markup asMarkup() {
            return new Markup.Empty();
        }
    }
}

