/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.filters.fontmappings.DefaultFontMappings;
import net.sf.okapi.common.filters.fontmappings.FontMapping;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.common.filters.fontmappings.ParametersStringFontMappingsInput;
import net.sf.okapi.common.filters.fontmappings.ParametersStringFontMappingsOutput;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;
import net.sf.okapi.filters.openxml.Color;
import net.sf.okapi.filters.openxml.ParametersStringWorksheetConfigurationsInput;
import net.sf.okapi.filters.openxml.ParametersStringWorksheetConfigurationsOutput;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.WorksheetConfiguration;
import net.sf.okapi.filters.openxml.WorksheetConfigurations;

public class ConditionalParameters
extends StringParameters
implements ISimplifierRulesParameters {
    static final String EMPTY_SUBFILTER_CONFIGURATION = "";
    private static final String MAX_ATTRIBUTE_SIZE = "maxAttributeSize";
    private static final String TRANSLATEDOCPROPERTIES = "bPreferenceTranslateDocProperties";
    private static final String TRANSLATE_POWERPOINT_DOC_PROPERTIES = "translatePowerpointDocProperties";
    private static final String REORDER_POWERPOINT_DOC_PROPERTIES = "reorderPowerpointDocProperties";
    private static final String REORDER_POWERPOINT_RELATIONSHIPS = "reorderPowerpointRelationships";
    private static final String TRANSLATE_POWERPOINT_DIAGRAM_DATA = "translatePowerpointDiagramData";
    private static final String REORDER_POWERPOINT_DIAGRAM_DATA = "reorderPowerpointDiagramData";
    private static final String TRANSLATE_POWERPOINT_CHARTS = "translatePowerpointCharts";
    private static final String REORDER_POWERPOINT_CHARTS = "reorderPowerpointCharts";
    private static final String TRANSLATECOMMENTS = "bPreferenceTranslateComments";
    private static final String TRANSLATE_POWERPOINT_COMMENTS = "translatePowerpointComments";
    private static final String REORDER_POWERPOINT_COMMENTS = "reorderPowerpointComments";
    private static final String AGGRESSIVECLEANUP = "bPreferenceAggressiveCleanup";
    private static final String IGNORE_WHITESPACE_STYLES = "ignoreWhitespaceStyles";
    private static final String PRESERVE_ASCII_AND_HIGH_ANSI_FONT_CATEGORIES_ON_DETECTION = "preserveAsciiAndHighAnsiFontCategoriesOnDetection";
    private static final String REMOVE_EMBEDDED_EXCEL = "removeEmbeddedExcel";
    private static final String AUTOMATICALLY_ACCEPT_REVISIONS = "bPreferenceAutomaticallyAcceptRevisions";
    private static final String TRANSLATEPOWERPOINTNOTES = "bPreferenceTranslatePowerpointNotes";
    private static final String REORDER_POWERPOINT_NOTES = "bPreferenceReorderPowerpointNotes";
    private static final String TRANSLATEPOWERPOINTMASTERS = "bPreferenceTranslatePowerpointMasters";
    private static final String IGNOREPLACEHOLDERSINPOWERPOINTMASTERS = "bPreferenceIgnorePlaceholdersInPowerpointMasters";
    private static final String TRANSLATEWORDHEADERSFOOTERS = "bPreferenceTranslateWordHeadersFooters";
    private static final String TRANSLATE_WORD_NUMBERING_LEVEL_TEXT = "translateWordNumberingLevelText";
    private static final String TRANSLATE_WORD_HIDDEN = "bPreferenceTranslateWordHidden";
    private static final String TRANSLATEEXCELEXCLUDECOLORS = "bPreferenceTranslateExcelExcludeColors";
    private static final String TRANSLATEEXELSHEETNAMES = "bPreferenceTranslateExcelSheetNames";
    private static final String TRANSLATE_EXCEL_CELLS_COPIED = "translateExcelCellsCopied";
    private static final String TRANSLATE_EXCEL_DIAGRAM_DATA = "bPreferenceTranslateExcelDiagramData";
    private static final String TRANSLATE_EXCEL_DRAWINGS = "bPreferenceTranslateExcelDrawings";
    private static final String TRANSLATE_POWERPOINT_HIDDEN = "bPreferenceTranslatePowerpointHidden";
    @Deprecated
    private static final String TRANSLATEWORDEXCLUDEGRAPHICMETADATA = "bPreferenceTranslateWordExcludeGraphicMetaData";
    private static final String TRANSLATE_WORD_GRAPHIC_NAME = "translateWordGraphicName";
    private static final String TRANSLATE_WORD_GRAPHIC_DESCRIPTION = "translateWordGraphicDescription";
    private static final String TRANSLATE_POWERPOINT_GRAPHIC_NAME = "translatePowerpointGraphicName";
    private static final String TRANSLATE_POWERPOINT_GRAPHIC_DESCRIPTION = "translatePowerpointGraphicDescription";
    private static final String TRANSLATE_POWERPOINT_CACHED_CHART_STRINGS = "translatePowerpointCachedChartStrings";
    private static final String TRANSLATE_POWERPOINT_CACHED_CHART_NUMBERS = "translatePowerpointCachedChartNumbers";
    private static final String TRANSLATE_EXCEL_HIDDEN = "bPreferenceTranslateExcelHidden";
    private static final String EXTRACT_EXTERNAL_HYPERLINKS = "bExtractExternalHyperlinks";
    private static final String TRANSLATE_WORD_EXCLUDE_STYLE_MODE = "bInExcludeMode";
    private static final String TRANSLATE_WORD_EXCLUDE_HIGHLIGHT_MODE = "bInExcludeHighlightMode";
    private static final String TRANSLATE_WORD_EXCLUDE_COLORS = "bPreferenceTranslateWordExcludeColors";
    private static final String ADDTABASCHARACTER = "bPreferenceAddTabAsCharacter";
    private static final String ADDLINESEPARATORASCHARACTER = "bPreferenceAddLineSeparatorAsCharacter";
    private static final String LINESEPARATORREPLACEMENT = "sPreferenceLineSeparatorReplacement";
    private static final String REPLACE_NO_BREAK_HYPHEN_TAG = "bPreferenceReplaceNoBreakHyphenTag";
    private static final String IGNORE_SOFT_HYPHEN_TAG = "bPreferenceIgnoreSoftHyphenTag";
    private static final String POWERPOINT_INCLUDED_SLIDE_NUMBERS_ONLY = "bPreferencePowerpointIncludedSlideNumbersOnly";
    @Deprecated
    private static final String REORDER_POWERPOINT_NOTES_AND_COMMENTS = "bReorderPowerpointNotesAndComments";
    private static final String IGNORE_WORD_FONT_COLORS = "ignoreWordFontColors";
    private static final String WORD_FONT_COLORS_MIN_IGNORANCE_THRESHOLD = "wordFontColorsMinIgnoranceThreshold";
    private static final String WORD_FONT_COLORS_MAX_IGNORANCE_THRESHOLD = "wordFontColorsMaxIgnoranceThreshold";
    private static final String ALLOW_WORD_STYLE_OPTIMISATION = "allowWordStyleOptimisation";
    private static final String PRESERVE_EXCEL_STYLES_IN_TARGET_COLUMNS = "preserveExcelStylesInTargetColumns";
    private static final String TREAT_EXCEL_SOURCE_COLUMN_STYLES_FOR_EXCLUSION = "treatExcelSourceColumnStylesForExclusion";
    private static final String EXTRACT_EXCEL_SOURCE_AND_TARGET_COLUMNS_JOINED = "extractExcelSourceAndTargetColumnsJoined";
    private static final String EXTRACT_EXCEL_WORKSHEETS_EXPLICITLY_SPECIFIED = "extractExcelWorksheetsExplicitlySpecified";
    private static final String EXTRACT_EXCEL_CELLS_EXPLICITLY_SPECIFIED = "extractExcelCellsExplicitlySpecified";
    private static final String ALLOW_EMPTY_TARGETS = "bPreferenceAllowEmptyTargets";
    private static final String SUBFILTER = "subfilter";
    private static final String USE_CODE_FINDER = "useCodeFinder";
    private static final String CODE_FINDER_RULES = "codeFinderRules";
    public static final int MSWORD = 1;
    public TreeSet<String> tsComplexFieldDefinitionsToExtract;
    public TreeSet<String> tsExcelExcludedColors;
    public TreeSet<String> tsExcludeWordStyles;
    public TreeSet<String> tsWordHighlightColors;
    public TreeSet<String> tsWordExcludedColors;
    public TreeSet<Integer> tsPowerpointIncludedSlideNumbers;
    public ParseType nFileType = ParseType.MSWORD;
    private WorksheetConfigurations worksheetConfigurations;
    private FontMappings fontMappings;
    private InlineCodeFinder codeFinder;

    public int getMaxAttributeSize() {
        return this.getInteger(MAX_ATTRIBUTE_SIZE);
    }

    public void setMaxAttributeSize(int maxAttributeSize) {
        this.setInteger(MAX_ATTRIBUTE_SIZE, maxAttributeSize);
    }

    public boolean getTranslateDocProperties() {
        return this.getBoolean(TRANSLATEDOCPROPERTIES);
    }

    public void setTranslateDocProperties(boolean translateDocProperties) {
        this.setBoolean(TRANSLATEDOCPROPERTIES, translateDocProperties);
    }

    public boolean getTranslatePowerpointDocProperties() {
        return this.getBoolean(TRANSLATE_POWERPOINT_DOC_PROPERTIES);
    }

    public void setTranslatePowerpointDocProperties(boolean value) {
        this.setBoolean(TRANSLATE_POWERPOINT_DOC_PROPERTIES, value);
    }

    public boolean getReorderPowerpointDocProperties() {
        return this.getBoolean(REORDER_POWERPOINT_DOC_PROPERTIES);
    }

    public void setReorderPowerpointDocProperties(boolean value) {
        this.setBoolean(REORDER_POWERPOINT_DOC_PROPERTIES, value);
    }

    public void setReorderPowerpointRelationships(boolean value) {
        this.setBoolean(REORDER_POWERPOINT_RELATIONSHIPS, value);
    }

    public boolean getReorderPowerpointRelationships() {
        return this.getBoolean(REORDER_POWERPOINT_RELATIONSHIPS);
    }

    public boolean getTranslatePowerpointDiagramData() {
        return this.getBoolean(TRANSLATE_POWERPOINT_DIAGRAM_DATA);
    }

    public void setTranslatePowerpointDiagramData(boolean value) {
        this.setBoolean(TRANSLATE_POWERPOINT_DIAGRAM_DATA, value);
    }

    public boolean getReorderPowerpointDiagramData() {
        return this.getBoolean(REORDER_POWERPOINT_DIAGRAM_DATA);
    }

    public void setReorderPowerpointDiagramData(boolean value) {
        this.setBoolean(REORDER_POWERPOINT_DIAGRAM_DATA, value);
    }

    public boolean getTranslatePowerpointCharts() {
        return this.getBoolean(TRANSLATE_POWERPOINT_CHARTS);
    }

    public void setTranslatePowerpointCharts(boolean value) {
        this.setBoolean(TRANSLATE_POWERPOINT_CHARTS, value);
    }

    public boolean getReorderPowerpointCharts() {
        return this.getBoolean(REORDER_POWERPOINT_CHARTS);
    }

    public void setReorderPowerpointCharts(boolean value) {
        this.setBoolean(REORDER_POWERPOINT_CHARTS, value);
    }

    public boolean getTranslateComments() {
        return this.getBoolean(TRANSLATECOMMENTS);
    }

    public void setTranslateComments(boolean translateComments) {
        this.setBoolean(TRANSLATECOMMENTS, translateComments);
    }

    public boolean getTranslatePowerpointComments() {
        return this.getBoolean(TRANSLATE_POWERPOINT_COMMENTS);
    }

    public void setTranslatePowerpointComments(boolean value) {
        this.setBoolean(TRANSLATE_POWERPOINT_COMMENTS, value);
    }

    public boolean getReorderPowerpointComments() {
        return this.getBoolean(REORDER_POWERPOINT_COMMENTS);
    }

    public void setReorderPowerpointComments(boolean value) {
        this.setBoolean(REORDER_POWERPOINT_COMMENTS, value);
    }

    public boolean getCleanupAggressively() {
        return this.getBoolean(AGGRESSIVECLEANUP);
    }

    public void setCleanupAggressively(boolean aggressiveCleanup) {
        this.setBoolean(AGGRESSIVECLEANUP, aggressiveCleanup);
    }

    public boolean getIgnoreWhitespaceStyles() {
        return this.getBoolean(IGNORE_WHITESPACE_STYLES);
    }

    public void setIgnoreWhitespaceStyles(boolean value) {
        this.setBoolean(IGNORE_WHITESPACE_STYLES, value);
    }

    public boolean getPreserveAsciiAndHighAnsiFontCategoriesOnDetection() {
        return this.getBoolean(PRESERVE_ASCII_AND_HIGH_ANSI_FONT_CATEGORIES_ON_DETECTION);
    }

    public void setPreserveAsciiAndHighAnsiFontCategoriesOnDetection(boolean value) {
        this.setBoolean(PRESERVE_ASCII_AND_HIGH_ANSI_FONT_CATEGORIES_ON_DETECTION, value);
    }

    public boolean getRemoveEmbeddedExcel() {
        return this.getBoolean(REMOVE_EMBEDDED_EXCEL);
    }

    public void setRemoveEmbeddedExcel(boolean removeEmbeddedExcel) {
        this.setBoolean(REMOVE_EMBEDDED_EXCEL, removeEmbeddedExcel);
    }

    public boolean getAutomaticallyAcceptRevisions() {
        return this.getBoolean(AUTOMATICALLY_ACCEPT_REVISIONS);
    }

    public void setAutomaticallyAcceptRevisions(boolean automaticallyAcceptRevisions) {
        this.setBoolean(AUTOMATICALLY_ACCEPT_REVISIONS, automaticallyAcceptRevisions);
    }

    public boolean getTranslatePowerpointNotes() {
        return this.getBoolean(TRANSLATEPOWERPOINTNOTES);
    }

    public void setTranslatePowerpointNotes(boolean translatePowerpointNotes) {
        this.setBoolean(TRANSLATEPOWERPOINTNOTES, translatePowerpointNotes);
    }

    public boolean getReorderPowerpointNotes() {
        return this.getBoolean(REORDER_POWERPOINT_NOTES);
    }

    public void setReorderPowerpointNotes(boolean value) {
        this.setBoolean(REORDER_POWERPOINT_NOTES, value);
    }

    public boolean getTranslatePowerpointMasters() {
        return this.getBoolean(TRANSLATEPOWERPOINTMASTERS);
    }

    public void setTranslatePowerpointMasters(boolean translatePowerpointMasters) {
        this.setBoolean(TRANSLATEPOWERPOINTMASTERS, translatePowerpointMasters);
    }

    public void setIgnorePlaceholdersInPowerpointMasters(boolean ignorePlaceholdersInPowerpointMasters) {
        this.setBoolean(IGNOREPLACEHOLDERSINPOWERPOINTMASTERS, ignorePlaceholdersInPowerpointMasters);
    }

    public boolean getIgnorePlaceholdersInPowerpointMasters() {
        return this.getBoolean(IGNOREPLACEHOLDERSINPOWERPOINTMASTERS);
    }

    public boolean getTranslateWordHeadersFooters() {
        return this.getBoolean(TRANSLATEWORDHEADERSFOOTERS);
    }

    public void setTranslateWordHeadersFooters(boolean translateWordHeadersFooters) {
        this.setBoolean(TRANSLATEWORDHEADERSFOOTERS, translateWordHeadersFooters);
    }

    public void setTranslateWordNumberingLevelText(boolean value) {
        this.setBoolean(TRANSLATE_WORD_NUMBERING_LEVEL_TEXT, value);
    }

    public boolean getTranslateWordNumberingLevelText() {
        return this.getBoolean(TRANSLATE_WORD_NUMBERING_LEVEL_TEXT);
    }

    public boolean getTranslateWordHidden() {
        return this.getBoolean(TRANSLATE_WORD_HIDDEN);
    }

    public void setTranslateWordHidden(boolean translateWordHidden) {
        this.setBoolean(TRANSLATE_WORD_HIDDEN, translateWordHidden);
    }

    public boolean getTranslatePowerpointHidden() {
        return this.getBoolean(TRANSLATE_POWERPOINT_HIDDEN);
    }

    public void setTranslatePowerpointHidden(boolean translatePowerpointHidden) {
        this.setBoolean(TRANSLATE_POWERPOINT_HIDDEN, translatePowerpointHidden);
    }

    public boolean getTranslateExcelHidden() {
        return this.getBoolean(TRANSLATE_EXCEL_HIDDEN);
    }

    public void setTranslateExcelHidden(boolean translateExcelHidden) {
        this.setBoolean(TRANSLATE_EXCEL_HIDDEN, translateExcelHidden);
    }

    public boolean getTranslateExcelExcludeColors() {
        return this.getBoolean(TRANSLATEEXCELEXCLUDECOLORS);
    }

    public void setTranslateExcelExcludeColors(boolean translateExcelExcludeColors) {
        this.setBoolean(TRANSLATEEXCELEXCLUDECOLORS, translateExcelExcludeColors);
    }

    public boolean getTranslateExcelSheetNames() {
        return this.getBoolean(TRANSLATEEXELSHEETNAMES);
    }

    public void setTranslateExcelSheetNames(boolean translateExcelSheetNames) {
        this.setBoolean(TRANSLATEEXELSHEETNAMES, translateExcelSheetNames);
    }

    public boolean getTranslateExcelCellsCopied() {
        return this.getBoolean(TRANSLATE_EXCEL_CELLS_COPIED);
    }

    public void setTranslateExcelCellsCopied(boolean value) {
        this.setBoolean(TRANSLATE_EXCEL_CELLS_COPIED, value);
    }

    public boolean getTranslateExcelDiagramData() {
        return this.getBoolean(TRANSLATE_EXCEL_DIAGRAM_DATA);
    }

    public void setTranslateExcelDiagramData(boolean translateExcelDiagramData) {
        this.setBoolean(TRANSLATE_EXCEL_DIAGRAM_DATA, translateExcelDiagramData);
    }

    public boolean getTranslateExcelDrawings() {
        return this.getBoolean(TRANSLATE_EXCEL_DRAWINGS);
    }

    public void setTranslateExcelDrawings(boolean translateExcelDrawings) {
        this.setBoolean(TRANSLATE_EXCEL_DRAWINGS, translateExcelDrawings);
    }

    public boolean getTranslateWordGraphicName() {
        return this.getBoolean(TRANSLATE_WORD_GRAPHIC_NAME);
    }

    public void setTranslateWordGraphicName(boolean value) {
        this.setBoolean(TRANSLATE_WORD_GRAPHIC_NAME, value);
    }

    public boolean getTranslateWordGraphicDescription() {
        return this.getBoolean(TRANSLATE_WORD_GRAPHIC_DESCRIPTION);
    }

    public void setTranslateWordGraphicDescription(boolean value) {
        this.setBoolean(TRANSLATE_WORD_GRAPHIC_DESCRIPTION, value);
    }

    public boolean getTranslatePowerpointGraphicName() {
        return this.getBoolean(TRANSLATE_POWERPOINT_GRAPHIC_NAME);
    }

    public void setTranslatePowerpointGraphicName(boolean value) {
        this.setBoolean(TRANSLATE_POWERPOINT_GRAPHIC_NAME, value);
    }

    public boolean getTranslatePowerpointGraphicDescription() {
        return this.getBoolean(TRANSLATE_POWERPOINT_GRAPHIC_DESCRIPTION);
    }

    public void setTranslatePowerpointGraphicDescription(boolean value) {
        this.setBoolean(TRANSLATE_POWERPOINT_GRAPHIC_DESCRIPTION, value);
    }

    public boolean getTranslatePowerpointCachedChartStrings() {
        return this.getBoolean(TRANSLATE_POWERPOINT_CACHED_CHART_STRINGS);
    }

    public void setTranslatePowerpointCachedChartStrings(boolean value) {
        this.setBoolean(TRANSLATE_POWERPOINT_CACHED_CHART_STRINGS, value);
    }

    public boolean getTranslatePowerpointCachedChartNumbers() {
        return this.getBoolean(TRANSLATE_POWERPOINT_CACHED_CHART_NUMBERS);
    }

    public void setTranslatePowerpointCachedChartNumbers(boolean value) {
        this.setBoolean(TRANSLATE_POWERPOINT_CACHED_CHART_NUMBERS, value);
    }

    public boolean getAddTabAsCharacter() {
        return this.getBoolean(ADDTABASCHARACTER);
    }

    public void setAddTabAsCharacter(boolean bAddTabAsCharacter) {
        this.setBoolean(ADDTABASCHARACTER, bAddTabAsCharacter);
    }

    public boolean getAddLineSeparatorCharacter() {
        return this.getBoolean(ADDLINESEPARATORASCHARACTER);
    }

    public void setAddLineSeparatorCharacter(boolean bAddLineSeparatorAsCharacter) {
        this.setBoolean(ADDLINESEPARATORASCHARACTER, bAddLineSeparatorAsCharacter);
    }

    public char getLineSeparatorReplacement() {
        return this.getString(LINESEPARATORREPLACEMENT).charAt(0);
    }

    public void setLineSeparatorReplacement(char lineSeparatorReplacement) {
        this.setString(LINESEPARATORREPLACEMENT, String.valueOf(lineSeparatorReplacement));
    }

    public boolean getReplaceNoBreakHyphenTag() {
        return this.getBoolean(REPLACE_NO_BREAK_HYPHEN_TAG);
    }

    public void setReplaceNoBreakHyphenTag(boolean bReplaceNoBreakHyphenTag) {
        this.setBoolean(REPLACE_NO_BREAK_HYPHEN_TAG, bReplaceNoBreakHyphenTag);
    }

    public boolean getIgnoreSoftHyphenTag() {
        return this.getBoolean(IGNORE_SOFT_HYPHEN_TAG);
    }

    public void setIgnoreSoftHyphenTag(boolean bIgnoreSoftHyphenTag) {
        this.setBoolean(IGNORE_SOFT_HYPHEN_TAG, bIgnoreSoftHyphenTag);
    }

    public void setExtractExternalHyperlinks(boolean bExtractExternalHyperlinks) {
        this.setBoolean(EXTRACT_EXTERNAL_HYPERLINKS, bExtractExternalHyperlinks);
    }

    public boolean getExtractExternalHyperlinks() {
        return this.getBoolean(EXTRACT_EXTERNAL_HYPERLINKS);
    }

    public void setPowerpointIncludedSlideNumbersOnly(boolean bIncludedSlideNumbersOnly) {
        this.setBoolean(POWERPOINT_INCLUDED_SLIDE_NUMBERS_ONLY, bIncludedSlideNumbersOnly);
    }

    public boolean getPowerpointIncludedSlideNumbersOnly() {
        return this.getBoolean(POWERPOINT_INCLUDED_SLIDE_NUMBERS_ONLY);
    }

    public boolean getTranslateWordInExcludeStyleMode() {
        return this.getBoolean(TRANSLATE_WORD_EXCLUDE_STYLE_MODE);
    }

    public void setTranslateWordInExcludeStyleMode(boolean inExcludeMode) {
        this.setBoolean(TRANSLATE_WORD_EXCLUDE_STYLE_MODE, inExcludeMode);
    }

    public boolean getTranslateWordInExcludeHighlightMode() {
        return this.getBoolean(TRANSLATE_WORD_EXCLUDE_HIGHLIGHT_MODE);
    }

    public void setTranslateWordInExcludeHighlightMode(boolean inExcludeHighlightMode) {
        this.setBoolean(TRANSLATE_WORD_EXCLUDE_HIGHLIGHT_MODE, inExcludeHighlightMode);
    }

    public boolean getTranslateWordExcludeColors() {
        return this.getBoolean(TRANSLATE_WORD_EXCLUDE_COLORS);
    }

    public void setTranslateWordExcludeColors(boolean translateWordExcludeColors) {
        this.setBoolean(TRANSLATE_WORD_EXCLUDE_COLORS, translateWordExcludeColors);
    }

    public boolean getIgnoreWordFontColors() {
        return this.getBoolean(IGNORE_WORD_FONT_COLORS);
    }

    public void setIgnoreWordFontColors(boolean value) {
        this.setBoolean(IGNORE_WORD_FONT_COLORS, value);
    }

    public String getWordFontColorsMinIgnoranceThreshold() {
        return this.getString(WORD_FONT_COLORS_MIN_IGNORANCE_THRESHOLD);
    }

    public void setWordFontColorsMinIgnoranceThreshold(String value) {
        if (this.getIgnoreWordFontColors()) {
            this.setString(WORD_FONT_COLORS_MIN_IGNORANCE_THRESHOLD, value);
        }
    }

    public String getWordFontColorsMaxIgnoranceThreshold() {
        return this.getString(WORD_FONT_COLORS_MAX_IGNORANCE_THRESHOLD);
    }

    public void setWordFontColorsMaxIgnoranceThreshold(String value) {
        if (this.getIgnoreWordFontColors()) {
            this.setString(WORD_FONT_COLORS_MAX_IGNORANCE_THRESHOLD, value);
        }
    }

    public boolean getAllowWordStyleOptimisation() {
        return this.getBoolean(ALLOW_WORD_STYLE_OPTIMISATION);
    }

    public void setAllowWordStyleOptimisation(boolean value) {
        this.setBoolean(ALLOW_WORD_STYLE_OPTIMISATION, value);
    }

    public boolean getPreserveExcelStylesInTargetColumns() {
        return this.getBoolean(PRESERVE_EXCEL_STYLES_IN_TARGET_COLUMNS);
    }

    public void setPreserveExcelStylesInTargetColumns(boolean value) {
        this.setBoolean(PRESERVE_EXCEL_STYLES_IN_TARGET_COLUMNS, value);
    }

    public boolean getTreatExcelSourceColumnStylesForExclusion() {
        return this.getBoolean(TREAT_EXCEL_SOURCE_COLUMN_STYLES_FOR_EXCLUSION);
    }

    public void setTreatExcelSourceColumnStylesForExclusion(boolean value) {
        this.setBoolean(TREAT_EXCEL_SOURCE_COLUMN_STYLES_FOR_EXCLUSION, value);
    }

    public boolean getExtractExcelSourceAndTargetColumnsJoined() {
        return this.getBoolean(EXTRACT_EXCEL_SOURCE_AND_TARGET_COLUMNS_JOINED);
    }

    public void setExtractExcelSourceAndTargetColumnsJoined(boolean value) {
        this.setBoolean(EXTRACT_EXCEL_SOURCE_AND_TARGET_COLUMNS_JOINED, value);
    }

    public boolean getExtractExcelWorksheetsExplicitlySpecified() {
        return this.getBoolean(EXTRACT_EXCEL_WORKSHEETS_EXPLICITLY_SPECIFIED);
    }

    public void setExtractExcelWorksheetsExplicitlySpecified(boolean value) {
        this.setBoolean(EXTRACT_EXCEL_WORKSHEETS_EXPLICITLY_SPECIFIED, value);
    }

    public boolean getExtractExcelCellsExplicitlySpecified() {
        return this.getBoolean(EXTRACT_EXCEL_CELLS_EXPLICITLY_SPECIFIED);
    }

    public void setExtractExcelCellsExplicitlySpecified(boolean value) {
        this.setBoolean(EXTRACT_EXCEL_CELLS_EXPLICITLY_SPECIFIED, value);
    }

    public boolean getAllowEmptyTargets() {
        return this.getBoolean(ALLOW_EMPTY_TARGETS);
    }

    public void setAllowEmptyTargets(boolean useSourceForEmptyTarget) {
        this.setBoolean(ALLOW_EMPTY_TARGETS, useSourceForEmptyTarget);
    }

    public String getSubfilter() {
        return this.getString(SUBFILTER);
    }

    public void setSubfilter(String subfilter) {
        this.setString(SUBFILTER, subfilter);
    }

    public WorksheetConfigurations worksheetConfigurations() {
        return this.worksheetConfigurations;
    }

    void worksheetConfigurations(WorksheetConfigurations worksheetConfigurations) {
        this.worksheetConfigurations = worksheetConfigurations;
    }

    public FontMappings fontMappings() {
        return this.fontMappings;
    }

    void fontMappings(FontMappings fontMappings) {
        this.fontMappings = fontMappings;
    }

    public boolean getUseCodeFinder() {
        return this.getBoolean(USE_CODE_FINDER);
    }

    public void setUseCodeFinder(boolean value) {
        this.setBoolean(USE_CODE_FINDER, value);
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    @Override
    public void reset() {
        this.worksheetConfigurations = new WorksheetConfigurations.Default(new LinkedList<WorksheetConfiguration>());
        this.fontMappings = new DefaultFontMappings(new LinkedList<FontMapping>());
        super.reset();
        this.setMaxAttributeSize(0x400000);
        this.setTranslateDocProperties(true);
        this.setTranslatePowerpointDocProperties(true);
        this.setReorderPowerpointDocProperties(false);
        this.setReorderPowerpointRelationships(false);
        this.setTranslatePowerpointDiagramData(true);
        this.setReorderPowerpointDiagramData(false);
        this.setTranslatePowerpointCharts(true);
        this.setReorderPowerpointCharts(false);
        this.setTranslatePowerpointNotes(true);
        this.setReorderPowerpointNotes(false);
        this.setTranslateComments(true);
        this.setTranslatePowerpointComments(true);
        this.setReorderPowerpointComments(false);
        this.setTranslatePowerpointMasters(true);
        this.setIgnorePlaceholdersInPowerpointMasters(false);
        this.setTranslateWordHeadersFooters(true);
        this.setTranslateWordNumberingLevelText(false);
        this.setTranslateWordHidden(false);
        this.setTranslateWordGraphicName(true);
        this.setTranslateWordGraphicDescription(false);
        this.setTranslatePowerpointGraphicName(true);
        this.setTranslatePowerpointGraphicDescription(false);
        this.setTranslatePowerpointCachedChartStrings(false);
        this.setTranslatePowerpointCachedChartNumbers(false);
        this.setTranslatePowerpointHidden(false);
        this.setTranslateExcelHidden(false);
        this.setTranslateExcelExcludeColors(false);
        this.setTranslateExcelSheetNames(false);
        this.setTranslateExcelCellsCopied(true);
        this.setAddLineSeparatorCharacter(false);
        this.setLineSeparatorReplacement('\n');
        this.setReplaceNoBreakHyphenTag(false);
        this.setIgnoreSoftHyphenTag(false);
        this.setAddTabAsCharacter(false);
        this.setCleanupAggressively(false);
        this.setIgnoreWhitespaceStyles(false);
        this.setPreserveAsciiAndHighAnsiFontCategoriesOnDetection(false);
        this.setRemoveEmbeddedExcel(false);
        this.setAutomaticallyAcceptRevisions(true);
        this.setExtractExternalHyperlinks(false);
        this.setPowerpointIncludedSlideNumbersOnly(false);
        this.setTranslateExcelDiagramData(false);
        this.setTranslateExcelDrawings(false);
        this.setSubfilter(EMPTY_SUBFILTER_CONFIGURATION);
        this.setTranslateWordInExcludeStyleMode(true);
        this.setTranslateWordInExcludeHighlightMode(true);
        this.setTranslateWordExcludeColors(false);
        this.setIgnoreWordFontColors(false);
        this.setAllowWordStyleOptimisation(true);
        this.setPreserveExcelStylesInTargetColumns(false);
        this.setTreatExcelSourceColumnStylesForExclusion(false);
        this.setExtractExcelSourceAndTargetColumnsJoined(false);
        this.setExtractExcelWorksheetsExplicitlySpecified(false);
        this.setExtractExcelCellsExplicitlySpecified(false);
        this.setAllowEmptyTargets(false);
        this.tsComplexFieldDefinitionsToExtract = new TreeSet();
        this.tsComplexFieldDefinitionsToExtract.add("HYPERLINK");
        this.tsExcelExcludedColors = new TreeSet();
        this.tsExcludeWordStyles = new TreeSet();
        this.tsPowerpointIncludedSlideNumbers = new TreeSet();
        this.tsWordHighlightColors = new TreeSet();
        this.tsWordExcludedColors = new TreeSet();
        this.codeFinder = new InlineCodeFinder();
        this.codeFinder.setUseAllRulesWhenTesting(true);
    }

    @Override
    public void fromString(String data) {
        String rgb;
        int i;
        super.fromString(data);
        this.worksheetConfigurations.addFrom(new ParametersStringWorksheetConfigurationsInput(this.buffer));
        this.fontMappings.addFrom(new ParametersStringFontMappingsInput(this.buffer));
        this.performMigrationFor(data);
        int siz = this.buffer.getInteger("tsComplexFieldDefinitionsToExtract");
        for (i = 0; i < siz; ++i) {
            String cf = this.buffer.getString("cfd" + i, EMPTY_SUBFILTER_CONFIGURATION);
            if (cf.isEmpty()) continue;
            this.tsComplexFieldDefinitionsToExtract.add(cf);
        }
        siz = this.buffer.getInteger("tsExcelExcludedColors");
        for (i = 0; i < siz; ++i) {
            rgb = this.buffer.getString("ccc" + i, EMPTY_SUBFILTER_CONFIGURATION);
            if (rgb.isEmpty()) continue;
            this.tsExcelExcludedColors.add(rgb);
        }
        siz = this.buffer.getInteger("tsExcludeWordStyles");
        for (i = 0; i < siz; ++i) {
            String style = this.buffer.getString("sss" + i, EMPTY_SUBFILTER_CONFIGURATION);
            if (style.isEmpty()) continue;
            this.tsExcludeWordStyles.add(style);
        }
        siz = this.buffer.getInteger("tsWordHighlightColors");
        for (i = 0; i < siz; ++i) {
            rgb = this.buffer.getString("hlt" + i, EMPTY_SUBFILTER_CONFIGURATION);
            if (rgb.isEmpty()) continue;
            this.tsWordHighlightColors.add(rgb);
        }
        siz = this.buffer.getInteger("tsWordExcludedColors");
        for (i = 0; i < siz; ++i) {
            rgb = this.buffer.getString("yyy" + i, EMPTY_SUBFILTER_CONFIGURATION);
            if (rgb.isEmpty()) continue;
            this.tsWordExcludedColors.add(rgb);
        }
        siz = this.buffer.getInteger("tsPowerpointIncludedSlideNumbers");
        for (i = 0; i < siz; ++i) {
            this.tsPowerpointIncludedSlideNumbers.add(this.buffer.getInteger("sln" + i, 1));
        }
        this.codeFinder.fromString(this.buffer.getGroup(CODE_FINDER_RULES, EMPTY_SUBFILTER_CONFIGURATION));
    }

    private void performMigrationFor(String string) {
        if (this.available(TRANSLATEDOCPROPERTIES) && !string.contains(TRANSLATE_POWERPOINT_DOC_PROPERTIES)) {
            this.setTranslatePowerpointDocProperties(this.getBoolean(TRANSLATEDOCPROPERTIES));
        }
        if (this.available(TRANSLATECOMMENTS) && !string.contains(TRANSLATE_POWERPOINT_COMMENTS)) {
            this.setTranslatePowerpointComments(this.getBoolean(TRANSLATECOMMENTS));
        }
        if (this.available(REORDER_POWERPOINT_NOTES_AND_COMMENTS)) {
            if (!string.contains(REORDER_POWERPOINT_NOTES)) {
                this.setReorderPowerpointNotes(this.getBoolean(REORDER_POWERPOINT_NOTES_AND_COMMENTS));
            }
            if (!string.contains(REORDER_POWERPOINT_COMMENTS)) {
                this.setReorderPowerpointComments(this.getBoolean(REORDER_POWERPOINT_NOTES_AND_COMMENTS));
            }
            this.remove(REORDER_POWERPOINT_NOTES_AND_COMMENTS);
        }
        if (this.available(TRANSLATEWORDEXCLUDEGRAPHICMETADATA)) {
            if (!string.contains(TRANSLATE_WORD_GRAPHIC_NAME)) {
                this.setTranslateWordGraphicName(!this.getBoolean(TRANSLATEWORDEXCLUDEGRAPHICMETADATA));
            }
            this.remove(TRANSLATEWORDEXCLUDEGRAPHICMETADATA);
        }
    }

    @Override
    public String toString() {
        int i;
        int siz = this.tsComplexFieldDefinitionsToExtract.size();
        this.buffer.setInteger("tsComplexFieldDefinitionsToExtract", siz);
        Iterator<String> it = this.tsComplexFieldDefinitionsToExtract.iterator();
        for (i = 0; i < siz && it.hasNext(); ++i) {
            this.buffer.setString("cfd" + i, it.next());
        }
        siz = this.tsExcelExcludedColors.size();
        this.buffer.setInteger("tsExcelExcludedColors", siz);
        it = this.tsExcelExcludedColors.iterator();
        for (i = 0; i < siz && it.hasNext(); ++i) {
            this.buffer.setString("ccc" + i, it.next());
        }
        siz = this.tsExcludeWordStyles.size();
        this.buffer.setInteger("tsExcludeWordStyles", siz);
        it = this.tsExcludeWordStyles.iterator();
        for (i = 0; i < siz && it.hasNext(); ++i) {
            this.buffer.setString("sss" + i, it.next());
        }
        siz = this.tsWordHighlightColors.size();
        this.buffer.setInteger("tsWordHighlightColors", siz);
        it = this.tsWordHighlightColors.iterator();
        for (i = 0; i < siz && it.hasNext(); ++i) {
            this.buffer.setString("hlt" + i, it.next());
        }
        siz = this.tsWordExcludedColors.size();
        this.buffer.setInteger("tsWordExcludedColors", siz);
        it = this.tsWordExcludedColors.iterator();
        for (i = 0; i < siz && it.hasNext(); ++i) {
            this.buffer.setString("yyy" + i, it.next());
        }
        siz = this.tsPowerpointIncludedSlideNumbers.size();
        this.buffer.setInteger("tsPowerpointIncludedSlideNumbers", siz);
        Iterator<Integer> slideIterator = this.tsPowerpointIncludedSlideNumbers.iterator();
        for (i = 0; i < siz && slideIterator.hasNext(); ++i) {
            this.buffer.setInteger("sln" + i, slideIterator.next());
        }
        this.buffer.fromParametersString(this.worksheetConfigurations.writtenTo(new ParametersStringWorksheetConfigurationsOutput()), false);
        this.buffer.fromParametersString(this.fontMappings.writtenTo(new ParametersStringFontMappingsOutput()), false);
        this.buffer.setGroup(CODE_FINDER_RULES, this.codeFinder.toString());
        return this.buffer.toString();
    }

    @Override
    public void save(String newPath) {
        Writer SW = null;
        try {
            SW = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(newPath)), StandardCharsets.UTF_8);
            SW.write(this.toString());
            this.path = newPath;
        }
        catch (IOException e) {
            throw new OkapiException(e);
        }
        finally {
            if (SW != null) {
                try {
                    SW.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(URI inputURI, boolean p_bIgnoreErrors) {
        try {
            int nCount;
            this.reset();
            URL url = inputURI.toURL();
            InputStreamReader SR = new InputStreamReader((InputStream)new BufferedInputStream(url.openStream()), StandardCharsets.UTF_8);
            StringBuilder sbTmp = new StringBuilder(1024);
            char[] aBuf = new char[1024];
            while ((nCount = SR.read(aBuf)) > -1) {
                sbTmp.append(aBuf, 0, nCount);
            }
            ((Reader)SR).close();
            SR = null;
            String tmp = sbTmp.toString().replace("\r\n", "\n");
            this.fromString(tmp.replace("\r", "\n"));
            this.path = inputURI.getPath();
        }
        catch (IOException e) {
            if (!p_bIgnoreErrors) {
                throw new OkapiException(e);
            }
        }
        finally {
            Object aBuf = null;
        }
    }

    public ConditionalParameters clone() {
        ConditionalParameters cpnew = new ConditionalParameters();
        cpnew.fromString(this.toString());
        cpnew.nFileType = this.nFileType;
        return cpnew;
    }

    boolean isWordExcludedStyle(String style) {
        if (null == style || null == this.tsExcludeWordStyles || this.tsExcludeWordStyles.isEmpty()) {
            return false;
        }
        return this.tsExcludeWordStyles.contains(style);
    }

    boolean isWordHighlight(List<Color.Value> colorValues) {
        return this.tsWordHighlightColors.stream().anyMatch(c -> colorValues.stream().anyMatch(v -> v.matches((String)c)));
    }

    boolean isWordExcludedColor(Color.Value colorValue) {
        return this.tsWordExcludedColors.stream().anyMatch(c -> colorValue.matches((String)c));
    }

    boolean isExcelExcludedColor(Color.Value colorValue) {
        return this.tsExcelExcludedColors.stream().anyMatch(c -> colorValue.matches((String)c));
    }

    @Override
    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }
}

