/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.filters.openxml.RunFonts;

interface ContentCategoriesDetection {
    public void performFor(RunFonts var1, String var2);

    public static final class Default
    implements ContentCategoriesDetection {
        private static final Pattern ASCII_CHARACTERS = Pattern.compile(".*[\u0000-\u007f].*");
        private static final Pattern LATIN_CHARACTERS = Pattern.compile(".*[\u0080-\u00a6\u00a9-\u00af\u00b2-\u00b3\u00b5-\u00d6\u00d8-\u00f6\u00f8-\u058f\u10a0-\u10ff\u1200-\u137f\u13a0-\u177f\u1d00-\u1d7f\u1e00-\u1fff\u2000-\u200b\u2010-\u2017\u201f-\u2029\u2030-\u2046\u204a-\u245f\u27c0-\u2bff\ud835\ufb00-\ufb17\ufe50-\ufe6f].*");
        private static final Pattern SYMBOLS = Pattern.compile(".*[\uf000-\uf0ff].*");
        private static final Pattern SHARED_CHARACTERS = Pattern.compile(".*[\u2018-\u201e].*");
        private static final Pattern COMPLEX_SCRIPT_CHARACTERS = Pattern.compile(".*[\u0590-\u074f\u0780-\u07bf\u0900-\u109f\u1780-\u18af\u200c-\u200f\u202a-\u202f\u2670-\u2671\ufb1d-\ufb4f].*");
        private static final Pattern EAST_ASIAN_CHARACTERS = Pattern.compile(".*[\u3099-\u309a].*");
        private static final Set<LocaleId> EAST_ASIAN_LOCALES = new HashSet<LocaleId>(Arrays.asList(LocaleId.fromBCP47("ii-CN"), LocaleId.fromBCP47("ja-JP"), LocaleId.fromBCP47("ko-KR"), LocaleId.fromBCP47("zh-CN"), LocaleId.fromBCP47("zh-HK"), LocaleId.fromBCP47("zh-MO"), LocaleId.fromBCP47("zh-SG"), LocaleId.fromBCP47("zh-TW")));
        private final LocaleId locale;

        Default(LocaleId locale) {
            this.locale = locale;
        }

        @Override
        public void performFor(RunFonts runFonts, String runText) {
            if (!runText.isEmpty()) {
                if (ASCII_CHARACTERS.matcher(runText).matches()) {
                    runFonts.addDetected(runFonts.getContentCategory(RunFonts.ContentCategory.ASCII_THEME, RunFonts.ContentCategory.ASCII));
                }
                if (SHARED_CHARACTERS.matcher(runText).matches()) {
                    if (EAST_ASIAN_LOCALES.contains(this.locale)) {
                        runFonts.addDetected(runFonts.getContentCategory(RunFonts.ContentCategory.EAST_ASIAN_THEME, RunFonts.ContentCategory.EAST_ASIAN));
                    } else {
                        runFonts.addDetected(runFonts.getContentCategory(RunFonts.ContentCategory.HIGH_ANSI_THEME, RunFonts.ContentCategory.HIGH_ANSI));
                    }
                }
                if (LATIN_CHARACTERS.matcher(runText).matches() || SYMBOLS.matcher(runText).matches()) {
                    runFonts.addDetected(runFonts.getContentCategory(RunFonts.ContentCategory.HIGH_ANSI_THEME, RunFonts.ContentCategory.HIGH_ANSI));
                }
                if (COMPLEX_SCRIPT_CHARACTERS.matcher(runText).matches()) {
                    runFonts.addDetected(runFonts.getContentCategory(RunFonts.ContentCategory.COMPLEX_SCRIPT_THEME, RunFonts.ContentCategory.COMPLEX_SCRIPT));
                }
                if (EAST_ASIAN_CHARACTERS.matcher(runText).matches() || this.matchesOtherCharacters(runText)) {
                    runFonts.addDetected(runFonts.getContentCategory(RunFonts.ContentCategory.EAST_ASIAN_THEME, RunFonts.ContentCategory.EAST_ASIAN));
                }
            }
        }

        private boolean matchesOtherCharacters(String text) {
            return !ASCII_CHARACTERS.matcher(text).matches() && !LATIN_CHARACTERS.matcher(text).matches() && !SYMBOLS.matcher(text).matches() && !SHARED_CHARACTERS.matcher(text).matches() && !COMPLEX_SCRIPT_CHARACTERS.matcher(text).matches() && !EAST_ASIAN_CHARACTERS.matcher(text).matches();
        }
    }

    public static final class NonApplicable
    implements ContentCategoriesDetection {
        @Override
        public void performFor(RunFonts runFonts, String runText) {
        }
    }
}

