/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Objects;
import net.sf.okapi.filters.openxml.CellReference;

final class CrossSheetCellReference {
    static final String DELIMITER = "!";
    private static final CellReference EMPTY = new CellReference("");
    private final String string;
    private String worksheetName;
    private CellReference cellReference;
    private boolean split;

    CrossSheetCellReference(String worksheetName, CellReference cellReference) {
        this(worksheetName + DELIMITER + cellReference.toString());
        this.worksheetName = worksheetName;
        this.cellReference = cellReference;
        this.split = true;
    }

    CrossSheetCellReference(String string) {
        this.string = string;
    }

    String worksheetName() {
        if (!this.split) {
            this.split();
        }
        return this.worksheetName;
    }

    CellReference cellReference() {
        if (!this.split) {
            this.split();
        }
        return this.cellReference;
    }

    private void split() {
        int idx = this.string.indexOf(DELIMITER);
        if (idx == -1) {
            this.worksheetName = this.string;
            this.cellReference = EMPTY;
        } else {
            this.worksheetName = this.string.substring(0, idx);
            this.cellReference = new CellReference(this.string.substring(idx + 1));
        }
        this.split = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrossSheetCellReference that = (CrossSheetCellReference)o;
        return this.string.equals(that.string);
    }

    public int hashCode() {
        return Objects.hash(this.string);
    }

    public String toString() {
        return this.string;
    }
}

