/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.sf.okapi.common.LocaleId;

interface DispersedTranslation {
    public String namespace();

    public String rawSource();

    public void prepareFor(LocaleId var1, String var2);

    public String targetOrSourceFor(LocaleId var1);

    public static final class Default
    implements DispersedTranslation {
        private final String namespace;
        private final String source;
        private final Map<LocaleId, String> targets;

        Default(String namespace, String source) {
            this(namespace, source, new HashMap<LocaleId, String>());
        }

        Default(String namespace, String source, Map<LocaleId, String> targets) {
            this.namespace = namespace;
            this.source = source;
            this.targets = targets;
        }

        @Override
        public String namespace() {
            return this.namespace;
        }

        @Override
        public String rawSource() {
            return this.source;
        }

        @Override
        public void prepareFor(LocaleId locale, String encodedTarget) {
            this.targets.put(locale, encodedTarget);
        }

        @Override
        public String targetOrSourceFor(LocaleId locale) {
            return this.targets.getOrDefault(locale, this.source);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Default another = (Default)o;
            return this.namespace.equals(another.namespace) && this.source.equals(another.source);
        }

        public int hashCode() {
            return Objects.hash(this.namespace, this.source);
        }
    }
}

