/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.IndexedColors;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesParser;
import net.sf.okapi.filters.openxml.RunSkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.SystemColorValues;
import net.sf.okapi.filters.openxml.Theme;

interface Font
extends Chunk {
    public static final String NAME = "font";

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public RunProperties asRunProperties();

    public Markup asMarkup();

    public static final class Default
    implements Font {
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final PresetColorValues presetColorValues;
        private final PresetColorValues highlightColorValues;
        private final SystemColorValues systemColorValues;
        private final IndexedColors indexedColors;
        private final Theme theme;
        private final StartElement startElement;
        private RunProperties fontAsRunProperties;

        Default(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, PresetColorValues presetColorValues, PresetColorValues highlightColorValues, SystemColorValues systemColorValues, IndexedColors indexedColors, Theme theme, StartElement startElement) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.presetColorValues = presetColorValues;
            this.highlightColorValues = highlightColorValues;
            this.systemColorValues = systemColorValues;
            this.indexedColors = indexedColors;
            this.theme = theme;
            this.startElement = startElement;
        }

        @Override
        public void apply(FontMappings fontMappings) {
            this.fontAsRunProperties.apply(fontMappings);
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.fontAsRunProperties.getEvents();
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            StartElementContext startElementContext = new StartElementContext(this.startElement, reader, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, this.eventFactory, this.conditionalParameters);
            this.fontAsRunProperties = new RunPropertiesParser(startElementContext, new RunSkippableElements(startElementContext)).parse();
        }

        @Override
        public RunProperties asRunProperties() {
            return this.fontAsRunProperties;
        }

        @Override
        public Markup asMarkup() {
            return new Markup.General(Collections.singletonList(this.fontAsRunProperties));
        }
    }

    public static final class Empty
    implements Font {
        @Override
        public void apply(FontMappings fontMappings) {
        }

        @Override
        public List<XMLEvent> getEvents() {
            return Collections.emptyList();
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
        }

        @Override
        public RunProperties asRunProperties() {
            return new RunProperties.Empty();
        }

        @Override
        public Markup asMarkup() {
            return new Markup.Empty();
        }
    }
}

