/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Color;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.SystemColorValues;
import net.sf.okapi.filters.openxml.Theme;

interface IndexedColors {
    public static final String NAME = "indexedColors";

    public String rgbValueFor(int var1);

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static class Override
    implements IndexedColors {
        private final XMLEventFactory eventFactory;
        private final PresetColorValues presetColorValues;
        private final SystemColorValues systemColorValues;
        private final Default defaultIndexColors;
        private final Theme theme;
        private final StartElement startElement;
        private final Map<Integer, Color> colors;
        private EndElement endElement;

        Override(XMLEventFactory eventFactory, PresetColorValues presetColorValues, SystemColorValues systemColorValues, Default defaultIndexColors, Theme theme, StartElement startElement) {
            this(eventFactory, presetColorValues, systemColorValues, defaultIndexColors, theme, startElement, new LinkedHashMap<Integer, Color>());
        }

        Override(XMLEventFactory eventFactory, PresetColorValues presetColorValues, SystemColorValues systemColorValues, Default defaultIndexColors, Theme theme, StartElement startElement, Map<Integer, Color> colors) {
            this.eventFactory = eventFactory;
            this.presetColorValues = presetColorValues;
            this.systemColorValues = systemColorValues;
            this.defaultIndexColors = defaultIndexColors;
            this.theme = theme;
            this.startElement = startElement;
            this.colors = colors;
        }

        @java.lang.Override
        public String rgbValueFor(int index) {
            String value = this.colors.containsKey(index) ? this.colors.get(index).value().asRgb() : this.defaultIndexColors.rgbValueFor(index);
            return value;
        }

        @java.lang.Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            int index = 0;
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                if (!e.isStartElement() || !"rgbColor".equals(e.asStartElement().getName().getLocalPart())) continue;
                Color.Argb color = new Color.Argb(this.presetColorValues, this.systemColorValues, this, this.theme, new Color.Default(this.presetColorValues, e.asStartElement()));
                color.readWith(reader);
                this.colors.put(index, color);
                ++index;
            }
        }

        @java.lang.Override
        public Markup asMarkup() {
            MarkupBuilder mb = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>(2 + this.colors.size())), new ArrayList<XMLEvent>(1));
            mb.add(this.startElement);
            this.colors.values().forEach(c -> mb.add(c.asMarkup()));
            mb.add(this.endElement());
            return mb.build();
        }

        private EndElement endElement() {
            if (null == this.endElement) {
                this.endElement = this.eventFactory.createEndElement(this.startElement.getName(), this.startElement.getNamespaces());
            }
            return this.endElement;
        }
    }

    public static class Default
    implements IndexedColors {
        private final SystemColorValues systemColorValues;
        private final List<String> rgbValues;

        Default(SystemColorValues systemColorValues) {
            this(systemColorValues, Arrays.asList("000000", "FFFFFF", "FF0000", "00FF00", "0000FF", "FFFF00", "FF00FF", "00FFFF", "000000", "FFFFFF", "FF0000", "00FF00", "0000FF", "FFFF00", "FF00FF", "00FFFF", "800000", "008000", "000080", "808000", "800080", "008080", "C0C0C0", "808080", "9999FF", "993366", "FFFFCC", "CCFFFF", "660066", "FF8080", "0066CC", "CCCCFF", "000080", "FF00FF", "FFFF00", "00FFFF", "800080", "800000", "008080", "0000FF", "00CCFF", "CCFFFF", "CCFFCC", "FFFF99", "99CCFF", "FF99CC", "CC99FF", "FFCC99", "3366FF", "33CCCC", "99CC00", "FFCC00", "FF9900", "FF6600", "666699", "969696", "003366", "339966", "003300", "333300", "993300", "993366", "333399", "333333"));
        }

        Default(SystemColorValues systemColorValues, List<String> rgbValues) {
            this.systemColorValues = systemColorValues;
            this.rgbValues = rgbValues;
        }

        @java.lang.Override
        public String rgbValueFor(int index) {
            String value = 64 == index ? this.systemColorValues.valueFor("windowText").asRgb() : (65 == index ? this.systemColorValues.valueFor("window").asRgb() : (81 == index ? this.systemColorValues.valueFor("infoText").asRgb() : this.rgbValues.get(index)));
            return value;
        }

        @java.lang.Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
        }

        @java.lang.Override
        public Markup asMarkup() {
            return new Markup.Empty();
        }
    }
}

