/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Color;
import net.sf.okapi.filters.openxml.ColorScheme;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.PresetColorValues;

interface NamedColor {
    public static final Set<String> NAMES = Set.of("dk1", "lt1", "dk2", "lt2", "accent1", "accent2", "accent3", "accent4", "accent5", "accent6", "hlink", "folHlink");

    public String name();

    public Color color();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static final class Default
    implements NamedColor {
        private final PresetColorValues presetColorValues;
        private final ColorScheme colorScheme;
        private final StartElement startElement;
        private Color color;
        private EndElement endElement;

        Default(PresetColorValues presetColorValues, ColorScheme colorScheme, StartElement startElement) {
            this.presetColorValues = presetColorValues;
            this.colorScheme = colorScheme;
            this.startElement = startElement;
        }

        @Override
        public String name() {
            return this.startElement.getName().getLocalPart();
        }

        @Override
        public Color color() {
            return this.color;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            block16: while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                if (!e.isStartElement()) continue;
                StartElement se = e.asStartElement();
                switch (se.getName().getLocalPart()) {
                    case "srgbClr": {
                        this.color = new Color.Default(this.presetColorValues, se);
                        this.color.readWith(reader);
                        continue block16;
                    }
                    case "scrgbClr": {
                        this.color = new Color.PercentageRgb(this.presetColorValues, new Color.Default(this.presetColorValues, se));
                        this.color.readWith(reader);
                        continue block16;
                    }
                    case "hslClr": {
                        this.color = new Color.Hsl(this.presetColorValues, new Color.Default(this.presetColorValues, se));
                        this.color.readWith(reader);
                        continue block16;
                    }
                    case "sysClr": {
                        this.color = new Color.System(new Color.Default(this.presetColorValues, se));
                        this.color.readWith(reader);
                        continue block16;
                    }
                    case "schemeClr": {
                        this.color = new Color.Scheme(this.presetColorValues, this.colorScheme, new Color.Default(this.presetColorValues, se));
                        this.color.readWith(reader);
                        continue block16;
                    }
                    case "prstClr": {
                        this.color = new Color.Preset(this.presetColorValues, new Color.Default(this.presetColorValues, se));
                        this.color.readWith(reader);
                    }
                }
                throw new IllegalStateException("Unsupported color: ".concat(se.getName().getLocalPart()));
            }
        }

        @Override
        public Markup asMarkup() {
            if (null == this.endElement) {
                throw new IllegalStateException("The end element is not available");
            }
            MarkupBuilder mb = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>(3)), new ArrayList<XMLEvent>(1));
            mb.add(this.startElement);
            mb.add(this.color.asMarkup());
            mb.add(this.endElement);
            return mb.build();
        }
    }
}

