/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.Note;
import net.sf.okapi.common.annotation.NoteAnnotation;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupSkeleton;

final class NumCacheMapping {
    private static final String V = "v";
    private static final String FORMAT_CODE = "formatCode";
    private String formatCode;
    private final IdGenerator documentPartIds;
    private final IdGenerator textUnitIds;
    private final XMLEventReader eventReader;
    private final String source;
    private final StartElement startElement;

    NumCacheMapping(IdGenerator documentPartIds, IdGenerator textUnitIds, XMLEventReader eventReader, String source, StartElement startElement) {
        this.documentPartIds = documentPartIds;
        this.textUnitIds = textUnitIds;
        this.eventReader = eventReader;
        this.source = source;
        this.startElement = startElement;
        this.formatCode = null;
    }

    List<Event> events() throws XMLStreamException {
        ArrayList<Event> events = new ArrayList<Event>();
        ArrayList<XMLEvent> markupEvents = new ArrayList<XMLEvent>();
        markupEvents.add(this.startElement);
        while (this.eventReader.hasNext()) {
            XMLEvent event;
            XMLEvent e = this.eventReader.nextEvent();
            if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                markupEvents.add(e);
                break;
            }
            if (e.isStartElement() && V.equals(e.asStartElement().getName().getLocalPart())) {
                markupEvents.add(e);
                event = this.eventReader.nextEvent();
                if (event.isCharacters() && !event.asCharacters().getData().isBlank()) {
                    events.add(this.documentPartEventFor(markupEvents));
                    markupEvents = new ArrayList();
                    events.add(this.textUnitEventFor(event.asCharacters().getData(), false));
                    continue;
                }
                markupEvents.add(event);
                continue;
            }
            if (e.isStartElement() && FORMAT_CODE.equals(e.asStartElement().getName().getLocalPart())) {
                markupEvents.add(e);
                event = this.eventReader.nextEvent();
                if (event.isCharacters() && !event.asCharacters().getData().isBlank()) {
                    events.add(this.documentPartEventFor(markupEvents));
                    markupEvents = new ArrayList();
                    this.formatCode = event.asCharacters().getData();
                    events.add(this.textUnitEventFor(event.asCharacters().getData(), true));
                    continue;
                }
                markupEvents.add(event);
                continue;
            }
            markupEvents.add(e);
        }
        events.add(this.documentPartEventFor(markupEvents));
        return events;
    }

    private Event documentPartEventFor(List<XMLEvent> events) {
        return new Event(EventType.DOCUMENT_PART, new DocumentPart(this.documentPartIds.createId(), false, new MarkupSkeleton(new Markup.General(Collections.singletonList(new MarkupComponent.General(events))))));
    }

    private Event textUnitEventFor(String value, boolean isFormatCode) {
        TextUnit tu = new TextUnit(this.textUnitIds.createId());
        tu.setMimeType("text/xml");
        tu.setPreserveWhitespaces(true);
        tu.setSource(new TextContainer(new TextFragment(value)));
        GenericSkeleton gs = new GenericSkeleton();
        if (isFormatCode) {
            gs.addContentPlaceholder(tu);
            tu.setPreserveWhitespaces(true);
            tu.setType(FORMAT_CODE);
            Note n = new Note("This text unit was created from a <c:numCache> element with a <c:formatCode> child element.");
            NoteAnnotation na = new NoteAnnotation();
            na.add(n);
            tu.setAnnotation(na);
        } else {
            NoteAnnotation na = new NoteAnnotation();
            na.add(new Note(String.format("Source: %s", this.source)));
            if (!Util.isEmpty(this.formatCode)) {
                na.add(new Note(String.format("Number formatted with formatCode: %s.", this.formatCode)));
            }
            tu.setAnnotation(na);
            tu.setType(V);
            gs.addContentPlaceholder(tu);
        }
        tu.setSkeleton(gs);
        return new Event(EventType.TEXT_UNIT, tu);
    }
}

