/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipException;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.encoder.QuoteMode;
import net.sf.okapi.common.encoder.XMLEncoder;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.DispersedTranslations;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.OpenXMLFilterWriter;
import net.sf.okapi.filters.openxml.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=ConditionalParameters.class)
public class OpenXMLFilter
implements IFilter {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String SUBFILTER_CONFIGURATION_HAS_NOT_BEEN_PROVIDED = "Subfilter configuration has not been provided.";
    static final String MIME_TYPE = "text/xml";
    static final String FILTER_ID = "okf_openxml";
    static final Charset ENCODING = StandardCharsets.UTF_8;
    static final String LINE_BREAK = "\n";
    private static final String START_DOCUMENT_ID = "sd";
    private static final String END_DOCUMENT_ID = "ed";
    private ConditionalParameters cparams = new ConditionalParameters();
    private final XMLInputFactory inputFactory = XMLInputFactory.newFactory("javax.xml.stream.XMLInputFactory", this.getClass().getClassLoader());
    private final XMLOutputFactory outputFactory = XMLOutputFactory.newFactory("javax.xml.stream.XMLOutputFactory", this.getClass().getClassLoader());
    private final XMLEventFactory eventFactory = XMLEventFactory.newFactory("javax.xml.stream.XMLEventFactory", this.getClass().getClassLoader());
    private final DispersedTranslations dispersedTranslations = new DispersedTranslations.Default();
    private Document.General document;
    private Part subDocument;
    private File tempFile;
    private NextAction nextAction;
    private URI documentUri;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private EncoderManager encoderManager;
    private IFilterConfigurationMapper filterConfigurationMapper;
    private IFilter subfilter;
    private RawDocument rawDocument;

    public OpenXMLFilter() {
        OpenXMLFilter.configure(this.inputFactory, this.cparams);
    }

    static void configure(XMLInputFactory inputFactory, ConditionalParameters conditionalParameters) {
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        OpenXMLFilter.setPropertyIfSupported(inputFactory, "org.codehaus.stax2.preserveLocation", false);
        OpenXMLFilter.setPropertyIfSupported(inputFactory, "org.codehaus.stax2.reportPrologWhitespace", false);
        OpenXMLFilter.setPropertyIfSupported(inputFactory, "org.codehaus.stax2.internNames", true);
        OpenXMLFilter.setPropertyIfSupported(inputFactory, "org.codehaus.stax2.internNsUris", true);
        OpenXMLFilter.setPropertyIfSupported(inputFactory, "com.ctc.wstx.maxAttributeSize", conditionalParameters.getMaxAttributeSize());
    }

    static void setPropertyIfSupported(XMLInputFactory inputFactory, String propertyName, Object propertyValue) {
        if (inputFactory.isPropertySupported(propertyName)) {
            inputFactory.setProperty(propertyName, propertyValue);
        }
    }

    @Override
    public void close() {
        if (this.rawDocument != null) {
            this.rawDocument.close();
        }
        try {
            this.nextAction = NextAction.DONE;
            if (this.document != null) {
                this.document.close();
                this.document = null;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error closing zipped output file.");
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return null;
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new OpenXMLFilterWriter(this.cparams, this.inputFactory, this.outputFactory, this.eventFactory, this.dispersedTranslations);
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping(MIME_TYPE, "net.sf.okapi.common.encoder.XMLEncoder");
            this.encoderManager.setDefaultOptions(new XMLEncoder.Parameters(true, true, false, QuoteMode.UNESCAPED), ENCODING.name(), LINE_BREAK);
            this.encoderManager.updateEncoder(MIME_TYPE);
        }
        return this.encoderManager;
    }

    @Override
    public String getName() {
        return FILTER_ID;
    }

    @Override
    public String getDisplayName() {
        return "OpenXML Filter";
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), MIME_TYPE, this.getClass().getName(), "Microsoft Office Document", "Microsoft Office documents (DOCX, DOCM, DOTX, DOTM, PPTX, PPTM, PPSX, PPSM, POTX, POTM, XLSX, XLSM, XLTX, XLTM, VSDX, VSDM).", null, ".docx;.docm;.dotx;.dotm;.pptx;.pptm;.ppsx;.ppsm;.potx;.potm;.xlsx;.xlsm;.xltx;.xltm;.vsdx;.vsdm;"));
        return list;
    }

    @Override
    public ConditionalParameters getParameters() {
        return this.cparams;
    }

    @Override
    public boolean hasNext() {
        return this.nextAction != NextAction.DONE;
    }

    @Override
    public Event next() {
        try {
            switch (this.nextAction) {
                case OPEN_DOCUMENT: {
                    return this.openDocument();
                }
                case NEXT_IN_DOCUMENT: {
                    return this.nextInDocument();
                }
                case NEXT_IN_SUB_DOCUMENT: {
                    Event e = this.nextInSubDocument();
                    if (e != null) {
                        return e;
                    }
                    this.nextAction = NextAction.NEXT_IN_DOCUMENT;
                    return this.next();
                }
            }
            throw new OkapiException("Invalid next() call.");
        }
        catch (IOException | XMLStreamException e) {
            throw new OkapiException("An error occurred during extraction", e);
        }
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument rawDocument, boolean generateSkeleton) {
        if (rawDocument == null) {
            throw new OkapiException("RawDocument is null");
        }
        this.createSubfilter();
        this.rawDocument = rawDocument;
        this.setOptions(rawDocument.getSourceLocale(), rawDocument.getTargetLocale(), rawDocument.getEncoding(), generateSkeleton);
        if (rawDocument.getInputCharSequence() != null) {
            this.open(rawDocument.getInputCharSequence());
        } else if (rawDocument.getInputURI() != null) {
            this.open(rawDocument.getInputURI());
            this.LOGGER.debug("\nOpening {}", (Object)rawDocument.getInputURI().toString());
        } else if (rawDocument.getStream() != null) {
            this.open(rawDocument.getStream());
        } else {
            throw new OkapiException("InputResource has no input defined.");
        }
        if (this.cparams.getUseCodeFinder()) {
            this.cparams.getCodeFinder().compile();
        }
    }

    private void createSubfilter() {
        String subfilterConfiguration = this.cparams.getSubfilter();
        if ("".equals(subfilterConfiguration)) {
            return;
        }
        if (null == this.filterConfigurationMapper || null == this.filterConfigurationMapper.getConfiguration(subfilterConfiguration)) {
            throw new IllegalStateException(SUBFILTER_CONFIGURATION_HAS_NOT_BEEN_PROVIDED);
        }
        this.subfilter = this.filterConfigurationMapper.createFilter(subfilterConfiguration);
    }

    public void open(InputStream input) {
        this.tempFile = FileUtil.createTempFile("~okapi-23_OpenXMLFilter_");
        StreamUtil.copy(input, this.tempFile);
        this.open(Util.toURI(this.tempFile.getAbsolutePath()));
    }

    private void open(CharSequence inputText) {
        throw new UnsupportedOperationException("Method is not supported for this filter.");
    }

    public void open(URI inputURI) {
        this.documentUri = inputURI;
        this.nextAction = NextAction.OPEN_DOCUMENT;
        OpenXMLFilter.configure(this.inputFactory, this.cparams);
        this.LOGGER.debug("\nOpening {}", (Object)inputURI.toString());
    }

    public void setOptions(LocaleId sourceLanguage, String defaultEncoding, boolean generateSkeleton) {
        this.setOptions(sourceLanguage, null, defaultEncoding, generateSkeleton);
    }

    public void setOptions(LocaleId sourceLanguage, LocaleId targetLanguage, String defaultEncoding, boolean generateSkeleton) {
        this.sourceLocale = sourceLanguage;
        this.targetLocale = targetLanguage;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper filterConfigurationMapper) {
        this.filterConfigurationMapper = filterConfigurationMapper;
    }

    @Override
    public void setParameters(IParameters params) {
        this.cparams = (ConditionalParameters)params;
        OpenXMLFilter.configure(this.inputFactory, this.cparams);
    }

    private Event openDocument() {
        try {
            this.dispersedTranslations.clear();
            this.document = new Document.General(this.cparams, this.inputFactory, this.outputFactory, this.eventFactory, this.dispersedTranslations, START_DOCUMENT_ID, this.documentUri, this.sourceLocale, this.targetLocale, ENCODING.name(), this.getEncoderManager(), this.subfilter, this.createFilterWriter());
            this.nextAction = NextAction.NEXT_IN_DOCUMENT;
            return this.document.open();
        }
        catch (ZipException e) {
            throw new OkapiIOException("Error opening zipped input file.", e);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error reading zipped input file.", e);
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException("Error parsing XML content", e);
        }
    }

    private Event nextInDocument() throws IOException, XMLStreamException {
        if (this.document.hasNextPart()) {
            this.subDocument = this.document.nextPart();
            this.nextAction = NextAction.NEXT_IN_SUB_DOCUMENT;
            return this.subDocument.open();
        }
        this.close();
        Ending ending = new Ending(END_DOCUMENT_ID);
        return new Event(EventType.END_DOCUMENT, ending);
    }

    private Event nextInSubDocument() {
        if (this.subDocument.hasNextEvent()) {
            Event event = this.subDocument.nextEvent();
            if (Objects.requireNonNull(event.getEventType()) == EventType.END_SUBDOCUMENT) {
                this.nextAction = NextAction.NEXT_IN_DOCUMENT;
                this.subDocument.close();
                return event;
            }
            this.subDocument.logEvent(event);
            return event;
        }
        return null;
    }

    @Override
    public void cancel() {
    }

    private static enum NextAction {
        OPEN_DOCUMENT,
        NEXT_IN_DOCUMENT,
        NEXT_IN_SUB_DOCUMENT,
        DONE;

    }
}

