/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Stack;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.DefaultLocalePair;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.common.skeleton.Referent;
import net.sf.okapi.common.skeleton.StorageList;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.openxml.CellReference;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.CrossSheetCellReference;
import net.sf.okapi.filters.openxml.DispersedTranslations;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.ExcelWorksheetTransUnitProperty;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupClarification;
import net.sf.okapi.filters.openxml.MarkupClarificationConfiguration;
import net.sf.okapi.filters.openxml.MarkupZipSkeleton;
import net.sf.okapi.filters.openxml.Nameable;
import net.sf.okapi.filters.openxml.OpenXMLFilter;
import net.sf.okapi.filters.openxml.StyledTextSkeletonWriter;

public class OpenXMLFilterWriter
implements IFilterWriter {
    private ConditionalParameters cparams;
    private final XMLInputFactory inputFactory;
    private final XMLOutputFactory outputFactory;
    private final XMLEventFactory eventFactory;
    private final DispersedTranslations dispersedTranslations;
    private String outputPath;
    private Document.General document;
    private ZipOutputStream zipOut;
    private byte[] buffer;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private FontMappings fontMappings;
    private File tempFile;
    private File tempZip;
    private EncoderManager encoderManager;
    private ZipEntry subDocEntry;
    private IFilterWriter subDocWriter;
    private ISkeletonWriter subSkelWriter;
    private final TreeMap<Integer, SubDocumentValues> tmSubDoc = new TreeMap();
    private int ndxSubDoc = 0;
    private OutputStream outputStream;

    public OpenXMLFilterWriter() {
        this(new ConditionalParameters(), XMLInputFactory.newInstance(), XMLOutputFactory.newInstance(), XMLEventFactory.newInstance(), new DispersedTranslations.Default());
        OpenXMLFilter.configure(this.inputFactory, this.cparams);
    }

    OpenXMLFilterWriter(ConditionalParameters cparams, XMLInputFactory inputFactory, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, DispersedTranslations dispersedTranslations) {
        this.cparams = cparams;
        this.inputFactory = inputFactory;
        this.outputFactory = outputFactory;
        this.eventFactory = eventFactory;
        this.dispersedTranslations = dispersedTranslations;
    }

    @Override
    public void cancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.zipOut == null) {
            return;
        }
        IOException err = null;
        InputStream orig = null;
        OutputStream dest = null;
        try {
            if (this.document != null) {
                this.document.close();
                this.document = null;
            }
            this.zipOut.close();
            this.zipOut = null;
            if (this.tempZip != null) {
                int len;
                dest = new FileOutputStream(this.outputPath);
                orig = new FileInputStream(this.tempZip);
                while ((len = orig.read(this.buffer)) > 0) {
                    dest.write(this.buffer, 0, len);
                }
            }
            this.buffer = null;
        }
        catch (IOException e) {
            err = e;
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException e) {
                    err = e;
                }
                dest = null;
            }
            if (orig != null) {
                try {
                    orig.close();
                }
                catch (IOException e) {
                    err = e;
                }
                orig = null;
                if (err != null) {
                    throw new OkapiIOException("Error closing MS Office 2007 file.");
                }
                if (this.tempZip != null) {
                    this.tempZip.delete();
                    this.tempZip = null;
                }
            }
        }
    }

    @Override
    public String getName() {
        return "OpenXMLZipFilterWriter";
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("text/xml", "net.sf.okapi.common.encoder.XMLEncoder");
            this.encoderManager.setDefaultOptions(null, OpenXMLFilter.ENCODING.name(), "\n");
        }
        return this.encoderManager;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return this.subSkelWriter;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument((StartDocument)event.getResource());
                break;
            }
            case DOCUMENT_PART: {
                this.processDocumentPart(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
            case START_SUBDOCUMENT: {
                this.processStartSubDocument((StartSubDocument)event.getResource());
                break;
            }
            case END_SUBDOCUMENT: {
                this.processEndSubDocument((Ending)event.getResource());
                break;
            }
            case TEXT_UNIT: {
                ITextUnit tu;
                CrossSheetCellReference crossSheetCellReference;
                ITextUnit textUnit = event.getTextUnit();
                Property sheetNameProperty = textUnit.getProperty(ExcelWorksheetTransUnitProperty.SHEET_NAME.getKeyName());
                Property cellReferenceProperty = textUnit.getProperty(ExcelWorksheetTransUnitProperty.CELL_REFERENCE.getKeyName());
                if (null != sheetNameProperty && null != cellReferenceProperty && this.dispersedTranslations.presentFor(crossSheetCellReference = new CrossSheetCellReference(sheetNameProperty.getValue(), new CellReference(cellReferenceProperty.getValue()))) && (tu = event.getTextUnit().clone()).hasTarget(this.targetLocale)) {
                    this.dispersedTranslations.update(crossSheetCellReference, tu.getTarget(this.targetLocale).getUnSegmentedContentCopy().getText());
                }
            }
            case START_GROUP: 
            case END_GROUP: 
            case START_SUBFILTER: 
            case END_SUBFILTER: {
                try {
                    this.subDocWriter.handleEvent(event);
                    break;
                }
                catch (Throwable e) {
                    String mess = e.getMessage();
                    throw new OkapiNotImplementedException(mess, e);
                }
            }
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId language, String defaultEncoding) {
        this.targetLocale = language;
        this.dispersedTranslations.prepareFor(this.targetLocale);
    }

    @Override
    public void setOutput(String path) {
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.outputStream = output;
    }

    private void processStartDocument(StartDocument res) {
        try {
            OutputStream os;
            this.buffer = new byte[2048];
            this.sourceLocale = res.getLocale();
            this.fontMappings = this.cparams.fontMappings().applicableTo(new DefaultLocalePair(this.sourceLocale, this.targetLocale));
            ZipSkeleton skel = (ZipSkeleton)res.getSkeleton();
            ZipFile zipTemp = skel.getOriginal();
            File fZip = new File(zipTemp.getName());
            this.document = new Document.General(this.cparams, this.inputFactory, this.outputFactory, this.eventFactory, this.dispersedTranslations, res.getFilterId(), fZip.toURI(), this.sourceLocale, this.targetLocale, res.getEncoding(), null, null, null);
            this.document.open();
            this.tempZip = null;
            boolean useTemp = false;
            if (this.outputStream == null) {
                File f = new File(this.outputPath);
                if (f.exists()) {
                    boolean bl = useTemp = !f.delete();
                }
                if (useTemp) {
                    this.tempZip = File.createTempFile("~okapi-24_zfwTmpZip_", null);
                    os = new FileOutputStream(this.tempZip.getAbsolutePath());
                } else {
                    Util.createDirectories(this.outputPath);
                    os = new FileOutputStream(this.outputPath);
                }
            } else {
                os = this.outputStream;
            }
            this.zipOut = new ZipOutputStream(os);
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException("Existing file could not be overwritten.", e);
        }
        catch (IOException | XMLStreamException e) {
            throw new OkapiIOException("File could not be written.", e);
        }
    }

    private void processEndDocument() {
        this.close();
    }

    private void processDocumentPart(Event event) {
        DocumentPart documentPart = (DocumentPart)event.getResource();
        if (documentPart.getSkeleton() instanceof ZipSkeleton) {
            ZipSkeleton skeleton = (ZipSkeleton)documentPart.getSkeleton();
            try {
                this.zipOut.putNextEntry(new ZipEntry(skeleton.getEntry().getName()));
                if (skeleton instanceof MarkupZipSkeleton) {
                    this.clarify(((MarkupZipSkeleton)skeleton).markup());
                    ((MarkupZipSkeleton)skeleton).to(this.zipOut);
                } else {
                    String modifiedContents = skeleton.getModifiedContents();
                    if (modifiedContents != null) {
                        this.zipOut.write(modifiedContents.getBytes(StandardCharsets.UTF_8));
                    } else {
                        this.copyFrom(this.document.inputStreamFor(skeleton.getEntry()));
                    }
                }
                this.zipOut.closeEntry();
            }
            catch (IOException | XMLStreamException e) {
                throw new OkapiIOException("Error writing zip file entry.");
            }
        } else {
            this.subDocWriter.handleEvent(event);
        }
    }

    private void clarify(Markup markup) throws XMLStreamException, IOException {
        markup.apply(this.fontMappings);
        Nameable nameableMarkupComponent = markup.nameableComponent();
        if (null != nameableMarkupComponent) {
            MarkupClarificationConfiguration mcc = new MarkupClarificationConfiguration(this.cparams, this.eventFactory, this.document.presetColorValues(), this.document.highlightColorValues(), this.document.systemColorValues(), this.document.indexedColors(), this.document.mainPartTheme(), this.sourceLocale, this.targetLocale, this.dispersedTranslations);
            mcc.prepareFor(nameableMarkupComponent);
            new MarkupClarification(mcc).performFor(markup);
        }
    }

    private void processStartSubDocument(StartSubDocument res) {
        ++this.ndxSubDoc;
        try {
            this.tempFile = File.createTempFile("~okapi-25_zfwTmp" + this.ndxSubDoc + "_", null);
            ISkeleton skel = res.getSkeleton();
            ConditionalParameters conditionalParameters = (ConditionalParameters)res.getFilterParameters();
            if (skel instanceof ZipSkeleton) {
                this.subDocEntry = ((ZipSkeleton)res.getSkeleton()).getEntry();
                this.subSkelWriter = this.document.isStyledTextPart(this.subDocEntry) ? new StyledTextSkeletonWriter(conditionalParameters, this.eventFactory, this.document.presetColorValues(), this.document.highlightColorValues(), this.document.systemColorValues(), this.document.indexedColors(), this.document.mainPartTheme(), this.sourceLocale, this.targetLocale, this.dispersedTranslations, this.fontMappings, this.document.styleDefinitionsFor(this.subDocEntry), this.innerGenericSkeletonWriter()) : new GenericSkeletonWriter();
            } else {
                this.subDocEntry = new ZipEntry(res.getName());
                this.subSkelWriter = new GenericSkeletonWriter();
            }
        }
        catch (IOException | XMLStreamException e) {
            throw new OkapiIOException("Error opening temporary zip output file.");
        }
        this.subDocWriter = new GenericFilterWriter(this.subSkelWriter, this.getEncoderManager());
        this.subDocWriter.setOptions(this.targetLocale, OpenXMLFilter.ENCODING.name());
        this.subDocWriter.setOutput(this.tempFile.getAbsolutePath());
        StartDocument sd = new StartDocument("sd");
        sd.setLineBreak("\n");
        sd.setSkeleton(res.getSkeleton());
        sd.setLocale(this.sourceLocale);
        this.subDocWriter.handleEvent(new Event(EventType.START_DOCUMENT, sd));
        SubDocumentValues subDocumentValues = new SubDocumentValues(this.subDocEntry, this.subDocWriter, this.subSkelWriter, this.tempFile);
        this.tmSubDoc.put(this.ndxSubDoc, subDocumentValues);
    }

    private GenericSkeletonWriter innerGenericSkeletonWriter() {
        return new GenericSkeletonWriter(this.sourceLocale, this.targetLocale, this.getEncoderManager(), false, false, new LinkedHashMap<String, Referent>(), new Stack<StorageList>(), OpenXMLFilter.ENCODING.name(), 0, null);
    }

    private void processEndSubDocument(Ending res) {
        try {
            SubDocumentValues subDocumentValues = this.tmSubDoc.get(this.ndxSubDoc--);
            this.subDocEntry = subDocumentValues.zipEntry;
            this.subDocWriter = subDocumentValues.filterWriter;
            this.subSkelWriter = subDocumentValues.skeletonWriter;
            this.tempFile = subDocumentValues.tempFile;
            this.subDocWriter.handleEvent(new Event(EventType.END_DOCUMENT, res));
            this.subDocWriter.close();
            this.zipOut.putNextEntry(new ZipEntry(this.subDocEntry.getName()));
            this.copyFrom(new FileInputStream(this.tempFile));
            this.zipOut.closeEntry();
            this.tempFile.delete();
        }
        catch (IOException e) {
            throw new OkapiIOException("Error closing zip output file.");
        }
    }

    private void copyFrom(InputStream inputStream) throws IOException {
        int len;
        while ((len = inputStream.read(this.buffer)) > 0) {
            this.zipOut.write(this.buffer, 0, len);
        }
        inputStream.close();
    }

    @Override
    public void setParameters(IParameters params) {
        this.cparams = (ConditionalParameters)params;
    }

    @Override
    public ConditionalParameters getParameters() {
        return this.cparams;
    }

    private static class SubDocumentValues {
        private final ZipEntry zipEntry;
        private final IFilterWriter filterWriter;
        private final ISkeletonWriter skeletonWriter;
        private final File tempFile;

        SubDocumentValues(ZipEntry zipEntry, IFilterWriter filterWriter, ISkeletonWriter skeletonWriter, File tempFile) {
            this.zipEntry = zipEntry;
            this.filterWriter = filterWriter;
            this.skeletonWriter = skeletonWriter;
            this.tempFile = tempFile;
        }
    }
}

