/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.filters.openxml.WorksheetConfiguration;

final class ParametersStringWorksheetConfiguration
implements WorksheetConfiguration {
    static final String DELIMITER = ",";
    private static final String DELIMITING_EXPRESSION = "\\s*,\\s*";
    static final String NAME_PATTERN = "namePattern";
    static final String SOURCE_COLUMNS = "sourceColumns";
    static final String TARGET_COLUMNS = "targetColumns";
    static final String TARGET_COLUMNS_MAX_CHARACTERS = "targetColumnsMaxCharacters";
    static final String EXCLUDED_ROWS = "excludedRows";
    static final String EXCLUDED_COLUMNS = "excludedColumns";
    static final String METADATA_ROWS = "metadataRows";
    static final String METADATA_COLUMNS = "metadataColumns";
    private static final String EMPTY = "";
    private static final String DEFAULT_NAME_PATTERN = "";
    private static final String DEFAULT_SOURCE_COLUMNS = "";
    private static final String DEFAULT_TARGET_COLUMNS = "";
    private static final String DEFAULT_TARGET_COLUMNS_MAX_CHARACTERS = "";
    private static final String DEFAULT_EXCLUDED_ROWS = "";
    private static final String DEFAULT_EXCLUDED_COLUMNS = "";
    private static final String DEFAULT_METADATA_ROWS = "";
    private static final String DEFAULT_METADATA_COLUMNS = "";
    private final ParametersString parametersString;
    private WorksheetConfiguration worksheetConfiguration;
    private boolean read;

    ParametersStringWorksheetConfiguration(ParametersString parametersString) {
        this.parametersString = parametersString;
    }

    @Override
    public boolean matches(String worksheetName) {
        this.fromParametersString();
        return this.worksheetConfiguration.matches(worksheetName);
    }

    @Override
    public Set<String> sourceColumns() {
        this.fromParametersString();
        return this.worksheetConfiguration.sourceColumns();
    }

    @Override
    public Set<String> targetColumns() {
        this.fromParametersString();
        return this.worksheetConfiguration.targetColumns();
    }

    @Override
    public List<String> targetColumnsMaxCharacters() {
        return this.worksheetConfiguration.targetColumnsMaxCharacters();
    }

    @Override
    public Set<Integer> excludedRows() {
        this.fromParametersString();
        return this.worksheetConfiguration.excludedRows();
    }

    @Override
    public Set<String> excludedColumns() {
        this.fromParametersString();
        return this.worksheetConfiguration.excludedColumns();
    }

    @Override
    public Set<Integer> metadataRows() {
        this.fromParametersString();
        return this.worksheetConfiguration.metadataRows();
    }

    @Override
    public Set<String> metadataColumns() {
        this.fromParametersString();
        return this.worksheetConfiguration.metadataColumns();
    }

    private void fromParametersString() {
        if (!this.read) {
            this.worksheetConfiguration = new WorksheetConfiguration.Default(this.parametersString.getString(NAME_PATTERN, ""), this.stringsFor(SOURCE_COLUMNS, ""), this.stringsFor(TARGET_COLUMNS, ""), this.stringsFor(TARGET_COLUMNS_MAX_CHARACTERS, ""), this.integersFor(EXCLUDED_ROWS, ""), this.stringsFor(EXCLUDED_COLUMNS, ""), this.integersFor(METADATA_ROWS, ""), this.stringsFor(METADATA_COLUMNS, ""));
            this.read = true;
        }
    }

    private List<Integer> integersFor(String parameterName, String defaultValue) {
        return Arrays.stream(this.valuesFor(parameterName, defaultValue)).filter(s -> !s.isEmpty()).map(Integer::parseUnsignedInt).collect(Collectors.toList());
    }

    private List<String> stringsFor(String parameterName, String defaultValue) {
        return Arrays.stream(this.valuesFor(parameterName, defaultValue)).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private String[] valuesFor(String parameterName, String defaultValue) {
        return this.parametersString.getString(parameterName, defaultValue).split(DELIMITING_EXPRESSION);
    }

    @Override
    public <T> T writtenTo(WorksheetConfiguration.Output<T> output) {
        this.fromParametersString();
        return this.worksheetConfiguration.writtenTo(output);
    }
}

