/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.nio.file.Path;

interface PartPath {
    public int numberOfParts();

    public PartPath partFor(int var1);

    public PartPath subpath(int var1, int var2);

    public PartPath normalized();

    public PartPath resolve(PartPath var1);

    public PartPath resolve(String var1);

    public PartPath relativize(PartPath var1);

    public Path asPath();

    public String asString();

    public static class Default
    implements PartPath {
        private static final String SLASH = "/";
        private static final String BACKSLASH = "\\";
        private final Path path;

        Default(String first, String ... more) {
            this(Path.of(first, more));
        }

        Default(Path path) {
            this.path = path;
        }

        @Override
        public int numberOfParts() {
            return this.path.getNameCount();
        }

        @Override
        public PartPath partFor(int index) {
            return new Default(this.path.getName(index));
        }

        @Override
        public PartPath subpath(int beginIndex, int endIndex) {
            return new Default(this.path.subpath(beginIndex, endIndex));
        }

        @Override
        public PartPath normalized() {
            return new Default(this.path.normalize());
        }

        @Override
        public PartPath resolve(PartPath other) {
            return new Default(this.path.resolve(other.asPath()));
        }

        @Override
        public PartPath resolve(String other) {
            return new Default(this.path.resolve(other));
        }

        @Override
        public PartPath relativize(PartPath other) {
            return new Default(this.path.relativize(other.asPath()));
        }

        @Override
        public Path asPath() {
            return this.path;
        }

        @Override
        public String asString() {
            String s = BACKSLASH.equals(this.path.getFileSystem().getSeparator()) ? this.path.toString().replace(BACKSLASH, SLASH) : this.path.toString();
            return s;
        }

        public String toString() {
            return this.asString();
        }
    }
}

