/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Color;
import net.sf.okapi.filters.openxml.IndexedColors;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.SystemColorValues;
import net.sf.okapi.filters.openxml.Theme;

interface PatternFill {
    public static final String NAME = "patternFill";

    public Color backgroundColor();

    public Color foregroundColor();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static final class Default
    implements PatternFill {
        private final PresetColorValues presetColorValues;
        private final SystemColorValues systemColorValues;
        private final IndexedColors indexedColors;
        private final Theme theme;
        private final StartElement startElement;
        private Color backgroundColor;
        private Color foregroundColor;
        private EndElement endElement;

        Default(PresetColorValues presetColorValues, SystemColorValues systemColorValues, IndexedColors indexedColors, Theme theme, StartElement startElement) {
            this.presetColorValues = presetColorValues;
            this.systemColorValues = systemColorValues;
            this.indexedColors = indexedColors;
            this.theme = theme;
            this.startElement = startElement;
        }

        @Override
        public Color backgroundColor() {
            if (null == this.backgroundColor) {
                this.backgroundColor = new Color.Empty();
            }
            return this.backgroundColor;
        }

        @Override
        public Color foregroundColor() {
            if (null == this.foregroundColor) {
                this.foregroundColor = new Color.Empty();
            }
            return this.foregroundColor;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                if (!e.isStartElement()) continue;
                StartElement se = e.asStartElement();
                if ("bgColor".equals(se.getName().getLocalPart())) {
                    this.backgroundColor = new Color.Argb(this.presetColorValues, this.systemColorValues, this.indexedColors, this.theme, new Color.Default(this.presetColorValues, se));
                    this.backgroundColor.readWith(reader);
                    continue;
                }
                if (!"fgColor".equals(se.getName().getLocalPart())) continue;
                this.foregroundColor = new Color.Argb(this.presetColorValues, this.systemColorValues, this.indexedColors, this.theme, new Color.Default(this.presetColorValues, se));
                this.foregroundColor.readWith(reader);
            }
        }

        @Override
        public Markup asMarkup() {
            if (null == this.endElement) {
                throw new IllegalStateException("The end element is not available");
            }
            MarkupBuilder mb = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>(4)), new ArrayList<XMLEvent>(1));
            mb.add(this.startElement);
            mb.add(this.foregroundColor().asMarkup());
            mb.add(this.backgroundColor().asMarkup());
            mb.add(this.endElement);
            return mb.build();
        }
    }

    public static final class Empty
    implements PatternFill {
        @Override
        public Color backgroundColor() {
            return new Color.Empty();
        }

        @Override
        public Color foregroundColor() {
            return new Color.Empty();
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
        }

        @Override
        public Markup asMarkup() {
            return new Markup.Empty();
        }
    }
}

