/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.PartPath;

interface Relationship {
    public static final String NAME = "Relationship";
    public static final QName ID = new QName("Id");
    public static final QName TYPE = new QName("Type");
    public static final QName TARGET = new QName("Target");
    public static final String INTERNAL_TARGET_MODE = "Internal";
    public static final String EXTERNAL_TARGET_MODE = "External";

    public String id();

    public String type();

    public String target();

    public String targetMode();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static final class Default
    implements Relationship {
        private static final QName TARGET_MODE = new QName("TargetMode");
        private final XMLEventFactory eventFactory;
        private final PartPath basePath;
        private final StartElement startElement;
        private EndElement endElement;

        Default(XMLEventFactory eventFactory, PartPath basePath, StartElement startElement) {
            this.eventFactory = eventFactory;
            this.basePath = basePath;
            this.startElement = startElement;
        }

        @Override
        public String id() {
            return this.startElement.getAttributeByName(ID).getValue();
        }

        @Override
        public String type() {
            return this.startElement.getAttributeByName(TYPE).getValue();
        }

        @Override
        public String target() {
            String target = this.startElement.getAttributeByName(TARGET).getValue();
            String resolvedTarget = Relationship.INTERNAL_TARGET_MODE.equals(this.targetMode()) ? (target.startsWith("/") ? this.basePath.resolve(this.basePath.relativize(new PartPath.Default(target.substring(1), new String[0]))).normalized().asString() : this.basePath.resolve(target).normalized().asString()) : target;
            return resolvedTarget;
        }

        @Override
        public String targetMode() {
            Attribute a = this.startElement.getAttributeByName(TARGET_MODE);
            return null == a ? Relationship.INTERNAL_TARGET_MODE : a.getValue();
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (!e.isEndElement() || !e.asEndElement().getName().equals(this.startElement.getName())) continue;
                this.endElement = e.asEndElement();
                break;
            }
        }

        @Override
        public Markup asMarkup() {
            MarkupBuilder mb = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>(1)), new ArrayList<XMLEvent>(2));
            mb.add(this.startElement);
            mb.add(this.endElement());
            return mb.build();
        }

        private EndElement endElement() {
            if (null == this.endElement) {
                this.endElement = this.eventFactory.createEndElement(this.startElement.getName(), this.startElement.getNamespaces());
            }
            return this.endElement;
        }
    }
}

