/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.PartPath;
import net.sf.okapi.filters.openxml.Relationship;
import net.sf.okapi.filters.openxml.RelationshipIdGeneration;

interface Relationships {
    public static final String NAME = "Relationships";
    public static final String UNEXPECTED_NUMBER_OF_RELATIONSHIPS = "Unexpected number of relationships";

    public StartDocument startDocument();

    public StartElement startElement();

    public EndElement endElement();

    public EndDocument endDocument();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public void addFrom(String var1, String var2) throws XMLStreamException;

    public Iterator<Relationship> iterator();

    public Relationships with(String var1);

    public Relationships without(String var1);

    public Relationships of(String var1);

    public boolean availableWith(String var1);

    public Markup asMarkup();

    public static final class Default
    implements Relationships {
        private final XMLEventFactory eventFactory;
        private final RelationshipIdGeneration relationshipIdGeneration;
        private final PartPath basePath;
        private final List<Relationship> relationships;
        private StartDocument startDocument;
        private StartElement startElement;
        private EndElement endElement;
        private EndDocument endDocument;

        Default(XMLEventFactory eventFactory, RelationshipIdGeneration relationshipIdGeneration, PartPath basePath) {
            this(eventFactory, relationshipIdGeneration, basePath, new LinkedList<Relationship>());
        }

        Default(XMLEventFactory eventFactory, RelationshipIdGeneration relationshipIdGeneration, PartPath basePath, List<Relationship> relationships) {
            this.eventFactory = eventFactory;
            this.relationshipIdGeneration = relationshipIdGeneration;
            this.basePath = basePath;
            this.relationships = relationships;
        }

        @Override
        public StartDocument startDocument() {
            return this.startDocument;
        }

        @Override
        public StartElement startElement() {
            return this.startElement;
        }

        @Override
        public EndElement endElement() {
            return this.endElement;
        }

        @Override
        public EndDocument endDocument() {
            return this.endDocument;
        }

        @Override
        public void readWith(XMLEventReader eventReader) throws XMLStreamException {
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (e.isEndDocument()) {
                    this.endDocument = (EndDocument)e;
                    break;
                }
                if (e.isStartDocument()) {
                    this.startDocument = (StartDocument)e;
                    continue;
                }
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    continue;
                }
                if (e.isStartElement() && Relationships.NAME.equals(e.asStartElement().getName().getLocalPart())) {
                    this.startElement = e.asStartElement();
                    continue;
                }
                if (!e.isStartElement() || !"Relationship".equals(e.asStartElement().getName().getLocalPart())) continue;
                Relationship.Default r = new Relationship.Default(this.eventFactory, this.basePath, e.asStartElement());
                r.readWith(eventReader);
                this.relationshipIdGeneration.refineLastIndexWith(r.id());
                this.relationships.add(r);
            }
        }

        @Override
        public void addFrom(String type, String target) throws XMLStreamException {
            List<Attribute> attributes = Arrays.asList(this.eventFactory.createAttribute(Relationship.ID, this.relationshipIdGeneration.nextId()), this.eventFactory.createAttribute(Relationship.TYPE, type), this.eventFactory.createAttribute(Relationship.TARGET, target));
            this.relationships.add(new Relationship.Default(this.eventFactory, this.basePath, this.eventFactory.createStartElement(this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), "Relationship", attributes.iterator(), null)));
        }

        @Override
        public Iterator<Relationship> iterator() {
            return this.relationships.iterator();
        }

        @Override
        public Relationships with(String id) {
            return this.filteredBy(r -> id.equals(r.id()));
        }

        @Override
        public Relationships without(String id) {
            return this.filteredBy(r -> !id.equals(r.id()));
        }

        private Relationships filteredBy(Predicate<Relationship> predicate) {
            List<Relationship> relationshipList = this.relationships.stream().filter(predicate).collect(Collectors.toList());
            Default relationships = new Default(this.eventFactory, this.relationshipIdGeneration, this.basePath, relationshipList);
            relationships.startDocument = this.startDocument;
            relationships.startElement = this.startElement;
            relationships.endElement = this.endElement;
            relationships.endDocument = this.endDocument;
            return relationships;
        }

        @Override
        public Relationships of(String type) {
            return this.filteredBy(r -> type.equals(r.type()));
        }

        @Override
        public boolean availableWith(String targetMode) {
            return this.filteredBy(r -> targetMode.equals(r.targetMode())).iterator().hasNext();
        }

        @Override
        public Markup asMarkup() {
            MarkupBuilder mb = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>(2 + this.relationships.size())), new ArrayList<XMLEvent>(2));
            mb.add(this.startDocument);
            mb.add(this.startElement);
            this.relationships.forEach(r -> mb.add(r.asMarkup()));
            mb.add(this.endElement);
            mb.add(this.endDocument);
            return mb.build();
        }
    }
}

