/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.Relationship;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.TranslatablePart;
import net.sf.okapi.filters.openxml.XMLEventSerializer;

class RelationshipsPart
extends TranslatablePart {
    static final String SUB_PATH = "_rels/";
    static final String EXTENSION = ".rels";
    static final String ROOT_RELS = "_rels/".concat(".rels");
    private static final String HYPERLINK = "/hyperlink";
    private final Relationships relationships;
    private final IdGenerator textUnitIdGeneration;
    private final String hyperlinkType;
    private String subDocumentId;
    private Iterator<Event> filterEventIterator;

    RelationshipsPart(Document.General generalDocument, ZipEntry entry, Relationships relationships) {
        super(generalDocument, entry);
        this.relationships = relationships;
        this.textUnitIdGeneration = new IdGenerator(entry.getName(), "tu");
        this.hyperlinkType = generalDocument.mainPartRelationshipsNamespace().uri().concat(HYPERLINK);
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.subDocumentId = this.generalDocument.nextSubDocumentId();
        this.formEvents();
        return this.createStartSubDocumentEvent(this.generalDocument.documentId(), this.subDocumentId);
    }

    private void formEvents() {
        this.addEventToDocumentPart(this.relationships.startDocument());
        this.addEventToDocumentPart(this.relationships.startElement());
        this.flushDocumentPart();
        Iterator<Relationship> iterator = this.relationships.iterator();
        while (iterator.hasNext()) {
            Relationship r = iterator.next();
            String type = r.type();
            if (this.hyperlinkType.equals(r.type()) && "External".equals(r.targetMode()) && !r.target().isEmpty()) {
                this.filterEvents.add(new Event(EventType.TEXT_UNIT, this.textUnitFor(r)));
                continue;
            }
            this.filterEvents.add(new Event(EventType.DOCUMENT_PART, this.documentPartFor(r)));
        }
        this.addEventToDocumentPart(this.relationships.endElement());
        this.addEventToDocumentPart(this.relationships.endDocument());
        this.flushDocumentPart();
        this.filterEvents.add(new Event(EventType.END_SUBDOCUMENT, new Ending(this.subDocumentId)));
        this.filterEventIterator = this.filterEvents.iterator();
    }

    private DocumentPart documentPartFor(Relationship relationship) {
        return new DocumentPart(this.documentPartIds.createId(), false, new GenericSkeleton(XMLEventSerializer.serialize(relationship.asMarkup())));
    }

    private TextUnit textUnitFor(Relationship relationship) {
        String[] parts = RelationshipsPart.skeletonParts(XMLEventSerializer.serialize(relationship.asMarkup()));
        GenericSkeleton skel = new GenericSkeleton();
        skel.append(parts[0]);
        TextUnit textUnit = new TextUnit(this.textUnitIdGeneration.createId());
        textUnit.setSourceContent(new TextFragment(parts[1]));
        skel.addContentPlaceholder(textUnit);
        skel.append(parts[2]);
        textUnit.setSkeleton(skel);
        return textUnit;
    }

    private static String[] skeletonParts(String string) {
        String startValueMarker = Relationship.TARGET.getPrefix().isEmpty() ? Relationship.TARGET.getLocalPart() + "=\"" : Relationship.TARGET.getPrefix() + ":" + Relationship.TARGET.getLocalPart() + "=\"";
        int valueIndex = string.indexOf(startValueMarker) + startValueMarker.length();
        int lastPartIndex = string.indexOf("\"", valueIndex);
        return new String[]{string.substring(0, valueIndex), string.substring(valueIndex, lastPartIndex), string.substring(lastPartIndex)};
    }

    @Override
    public boolean hasNextEvent() {
        return this.filterEventIterator.hasNext();
    }

    @Override
    public Event nextEvent() {
        return this.filterEventIterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
    }
}

