/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.Nameable;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.Property;
import net.sf.okapi.filters.openxml.RunPropertiesPairWithDetectedRunFonts;
import net.sf.okapi.filters.openxml.Text;
import net.sf.okapi.filters.openxml.Textual;
import net.sf.okapi.filters.openxml.XMLEventSerializer;
import net.sf.okapi.filters.openxml.XMLEvents;

class Run
implements Chunk {
    private static final String START_MARKUP_COMPONENT_IS_NOT_FOUND = "Unexpected structure: the start markup component is not found";
    private final StartElement startEvent;
    private final EndElement endEvent;
    private final RunPropertiesPairWithDetectedRunFonts runPropertiesPairWithDetectedRunFonts;
    private final List<Chunk> bodyChunks;
    private final List<Textual> nestedTextualItems;
    private final boolean isHidden;

    Run(StartElement startEvent, EndElement endEvent, RunPropertiesPairWithDetectedRunFonts runPropertiesPairWithDetectedRunFonts, List<Chunk> bodyChunks, List<Textual> nestedTextualItems, boolean isHidden) {
        this.startEvent = startEvent;
        this.endEvent = endEvent;
        this.runPropertiesPairWithDetectedRunFonts = runPropertiesPairWithDetectedRunFonts;
        this.bodyChunks = bodyChunks;
        this.nestedTextualItems = nestedTextualItems;
        this.isHidden = isHidden;
    }

    RunPropertiesPairWithDetectedRunFonts propertiesPair() {
        return this.runPropertiesPairWithDetectedRunFonts;
    }

    void refineRunProperties(List<Property> runProperties) {
        for (Property runProperty : runProperties) {
            this.runPropertiesPairWithDetectedRunFonts.direct().removeBy(runProperty.getName());
        }
    }

    List<Chunk> getBodyChunks() {
        return this.bodyChunks;
    }

    List<Textual> getNestedTextualItems() {
        return this.nestedTextualItems;
    }

    boolean containsVisibleText() {
        if (this.isHidden) {
            return false;
        }
        for (Chunk c : this.bodyChunks) {
            if (!(c instanceof RunText)) continue;
            return true;
        }
        return false;
    }

    String text() {
        StringBuilder sb = new StringBuilder();
        for (Chunk c : this.bodyChunks) {
            if (!(c instanceof Text)) continue;
            sb.append(((Text)c).characters().getData());
        }
        return sb.toString();
    }

    boolean containsParagraphBlockProperties() {
        if (this.bodyChunks.get(0) instanceof Markup) {
            return ((Markup)this.bodyChunks.get(0)).components().stream().anyMatch(mc -> mc instanceof ParagraphBlockProperties);
        }
        return false;
    }

    List<ParagraphBlockProperties> paragraphBlockProperties() {
        List<ParagraphBlockProperties> properties = this.bodyChunks.get(0) instanceof Markup ? ((Markup)this.bodyChunks.get(0)).components().stream().filter(mc -> mc instanceof ParagraphBlockProperties).map(mc -> (ParagraphBlockProperties)mc).collect(Collectors.toList()) : Collections.emptyList();
        return properties;
    }

    void refineParagraphBlockProperties(ParagraphBlockProperties paragraphBlockProperties) {
        ListIterator<MarkupComponent> componentsIterator = ((Markup)this.bodyChunks.get(0)).components().listIterator();
        while (componentsIterator.hasNext()) {
            MarkupComponent markupComponent = componentsIterator.next();
            if (!(markupComponent instanceof ParagraphBlockProperties)) continue;
            if (null == paragraphBlockProperties) {
                componentsIterator.remove();
            } else {
                componentsIterator.set(paragraphBlockProperties);
            }
            return;
        }
        Run.rewindAfterParagraphStartMarkupComponent(componentsIterator);
        componentsIterator.add(paragraphBlockProperties);
    }

    private static void rewindAfterParagraphStartMarkupComponent(ListIterator<MarkupComponent> iterator) {
        while (iterator.hasPrevious()) {
            if (!(iterator.previous() instanceof MarkupComponent.StyledStart)) continue;
            iterator.next();
            return;
        }
        throw new IllegalStateException(START_MARKUP_COMPONENT_IS_NOT_FOUND);
    }

    @Override
    public void apply(FontMappings fontMappings) {
        this.runPropertiesPairWithDetectedRunFonts.direct().apply(fontMappings);
        this.bodyChunks.forEach(c -> c.apply(fontMappings));
    }

    @Override
    public List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.add(this.startEvent);
        events.addAll(this.runPropertiesPairWithDetectedRunFonts.getEvents());
        for (XMLEvents xMLEvents : this.bodyChunks) {
            events.addAll(xMLEvents.getEvents());
        }
        events.add(this.endEvent);
        return events;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + XMLEventSerializer.serialize(this.getEvents()) + "]";
    }

    static class RunText
    extends Text
    implements RunChunk {
        RunText(StartElement startElement, Characters text, EndElement endElement) {
            super(startElement, text, endElement);
        }
    }

    static class Markup
    implements net.sf.okapi.filters.openxml.Markup,
    RunChunk {
        private final Markup.General generalMarkup;

        Markup(Markup.General generalMarkup) {
            this.generalMarkup = generalMarkup;
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.generalMarkup.getEvents();
        }

        @Override
        public void apply(FontMappings fontMappings) {
            this.generalMarkup.apply(fontMappings);
        }

        @Override
        public void addComponent(MarkupComponent component) {
            this.generalMarkup.addComponent(component);
        }

        @Override
        public void addComponents(List<MarkupComponent> components) {
            this.generalMarkup.addComponents(components);
        }

        @Override
        public void add(net.sf.okapi.filters.openxml.Markup markup) {
            this.generalMarkup.add(markup);
        }

        @Override
        public List<MarkupComponent> components() {
            return this.generalMarkup.components();
        }

        @Override
        public Nameable nameableComponent() {
            return this.generalMarkup.nameableComponent();
        }
    }

    static interface RunChunk
    extends Chunk {
    }
}

