/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.XMLEventsReader;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockParser;
import net.sf.okapi.filters.openxml.BlockSkippableElements;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ConsumableXMLEventsReader;
import net.sf.okapi.filters.openxml.ContentCategoriesDetection;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.MarkupComponentParser;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.NumberingDefinitions;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.Parser;
import net.sf.okapi.filters.openxml.PrioritisedXMLEventReader;
import net.sf.okapi.filters.openxml.Property;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunBuilder;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunFonts;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesParser;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.RunSkippableElements;
import net.sf.okapi.filters.openxml.SkippableElement;
import net.sf.okapi.filters.openxml.SkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.TranslatableAttributeText;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RunParser
implements Parser<RunBuilder> {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String UNEXPECTED_STRUCTURE = "Unexpected structure: ";
    private static final int COMPLEX_FIELD_INITIAL_NESTING_LEVEL = 1;
    private static final QName COMPLEX_FIELD_CHARACTER_TYPE = Namespaces.WordProcessingML.getQName("fldCharType");
    private static final String COMPLEX_FIELD_CHARACTER = "fldChar";
    private static final String COMPLEX_FIELD_INSTRUCTION = "instrText";
    private static final String BEGIN = "begin";
    private static final String SEPARATE = "separate";
    private static final String END = "end";
    private static final String EMPTY = "";
    private StartElementContext startElementContext;
    private final IdGenerator nestedIds;
    private final StyleDefinitions styleDefinitions;
    private final StyleOptimisation styleOptimisation;
    private final NumberingDefinitions numberingDefinitions;
    private final ContentCategoriesDetection contentCategoriesDetection;
    private final String paragraphStyle;
    private final RunBuilder runBuilder;
    private final StrippableAttributes drawingRunPropertiesStrippableAttributes;
    private final StrippableAttributes wordRunRevisions;
    private final StrippableAttributes wordParagraphRevisions;
    private final SkippableElements defaultSkippableElements;
    private final SkippableElements blockPropertiesSkippableElements;
    private final RunSkippableElements runSkippableElements;
    private final BlockSkippableElements blockSkippableElements;
    private int complexFieldNestingLevel;

    RunParser(StartElementContext startElementContext, IdGenerator nestedIds, StyleDefinitions styleDefinitions, StyleOptimisation styleOptimisation, NumberingDefinitions numberingDefinitions, ContentCategoriesDetection contentCategoriesDetection, String paragraphStyle, boolean hidden) {
        this.drawingRunPropertiesStrippableAttributes = new StrippableAttributes.DrawingRunProperties(startElementContext.getConditionalParameters(), startElementContext.getEventFactory());
        this.wordRunRevisions = new StrippableAttributes.WordRunRevisions(startElementContext.getEventFactory());
        this.wordParagraphRevisions = new StrippableAttributes.WordParagraphRevisions(startElementContext.getEventFactory());
        this.startElementContext = new StartElementContext(this.wordRunRevisions.strip(startElementContext.getStartElement()), startElementContext);
        this.nestedIds = nestedIds;
        this.styleDefinitions = styleDefinitions;
        this.styleOptimisation = styleOptimisation;
        this.numberingDefinitions = numberingDefinitions;
        this.contentCategoriesDetection = contentCategoriesDetection;
        this.paragraphStyle = paragraphStyle;
        this.runBuilder = new RunBuilder(this.startElementContext, styleDefinitions);
        this.runBuilder.setHidden(hidden);
        this.defaultSkippableElements = new SkippableElements.Default(new SkippableElement[0]);
        this.blockPropertiesSkippableElements = new SkippableElements.RevisionProperty(new SkippableElements.Property(new SkippableElements.Default(SkippableElement.RunProperty.RUN_PROPERTY_RTL_DML, SkippableElement.RunProperty.RUN_PROPERTY_LANGUAGE, SkippableElement.RevisionProperty.RUN_PROPERTY_INSERTED_PARAGRAPH_MARK, SkippableElement.RevisionProperty.RUN_PROPERTY_MOVED_PARAGRAPH_TO, SkippableElement.RevisionProperty.RUN_PROPERTY_MOVED_PARAGRAPH_FROM, SkippableElement.RevisionProperty.PARAGRAPH_PROPERTIES_CHANGE, SkippableElement.RevisionProperty.RUN_PROPERTIES_CHANGE), startElementContext.getConditionalParameters()), startElementContext.getConditionalParameters());
        this.runSkippableElements = new RunSkippableElements(startElementContext);
        this.blockSkippableElements = new BlockSkippableElements(startElementContext);
    }

    @Override
    public RunBuilder parse() throws XMLStreamException {
        boolean visibilityClarified = false;
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent e = this.startElementContext.getEventReader().nextEvent();
            if (XMLEventHelpers.isEndElement(e, this.startElementContext.getStartElement())) {
                this.endRunParsing(e.asEndElement());
                return this.runBuilder;
            }
            if (XMLEventHelpers.isRunPropsStartEvent(e)) {
                this.parseRunPropertiesAndRunStyle(e.asStartElement());
                this.clarifyVisibility();
                visibilityClarified = true;
                continue;
            }
            if (!visibilityClarified) {
                this.clarifyVisibility();
                visibilityClarified = true;
            }
            this.startRunParsing(e);
        }
        throw new IllegalStateException("Invalid content? Unterminated run");
    }

    private void endRunParsing(EndElement e) {
        this.runBuilder.flushText();
        this.runBuilder.flushMarkup();
        this.runBuilder.setEndEvent(e);
        this.clarifyRunProperties();
    }

    private void clarifyRunProperties() {
        HashSet<QName> skippableProperties = new HashSet<QName>();
        if (this.startElementContext.getConditionalParameters().getCleanupAggressively() && this.startElementContext.getConditionalParameters().getIgnoreWhitespaceStyles() && !this.runBuilder.nonWhitespaceTextPresent() && !this.runBuilder.noteReferencePresent()) {
            skippableProperties.add(SkippableElement.RunProperty.RUN_PROPERTY_VERTICAL_ALIGNMENT_WPML.toName());
            skippableProperties.add(SkippableElement.RunProperty.RUN_PROPERTY_VERTICAL_ALIGNMENT_SML.toName());
        }
        String runText = this.runBuilder.firstRunText();
        RunProperties preCombinedRunProperties = this.runBuilder.preCombinedRunProperties(this.paragraphStyle);
        RunProperties runProperties = this.runBuilder.getRunProperties();
        RunFonts runFonts = runProperties.contains("rFonts") ? runProperties.fontsRunProperty().getRunFonts() : new RunFonts(preCombinedRunProperties.fontsRunProperty().getRunFonts());
        if (!runText.isEmpty()) {
            this.contentCategoriesDetection.performFor(runFonts, runText);
        }
        this.runBuilder.detectedRunFonts(runFonts);
        if (!runFonts.containsDetectedNonComplexScriptContentCategories()) {
            if (RunParser.canBeSkipped(SkippableElement.RunProperty.RUN_PROPERTY_BOLD.toName(), preCombinedRunProperties, runProperties)) {
                skippableProperties.add(SkippableElement.RunProperty.RUN_PROPERTY_BOLD.toName());
            }
            if (RunParser.canBeSkipped(SkippableElement.RunProperty.RUN_PROPERTY_ITALICS.toName(), preCombinedRunProperties, runProperties)) {
                skippableProperties.add(SkippableElement.RunProperty.RUN_PROPERTY_ITALICS.toName());
            }
            if (RunParser.canBeSkipped(SkippableElement.RunProperty.RUN_PROPERTY_FONT_SIZE.toName(), preCombinedRunProperties, runProperties)) {
                skippableProperties.add(SkippableElement.RunProperty.RUN_PROPERTY_FONT_SIZE.toName());
            }
        }
        if (!runFonts.containsDetectedComplexScriptContentCategories()) {
            if (RunParser.canBeSkipped(SkippableElement.RunProperty.RUN_PROPERTY_COMPLEX_SCRIPT_BOLD.toName(), preCombinedRunProperties, runProperties)) {
                skippableProperties.add(SkippableElement.RunProperty.RUN_PROPERTY_COMPLEX_SCRIPT_BOLD.toName());
            }
            if (RunParser.canBeSkipped(SkippableElement.RunProperty.RUN_PROPERTY_COMPLEX_SCRIPT_ITALICS.toName(), preCombinedRunProperties, runProperties)) {
                skippableProperties.add(SkippableElement.RunProperty.RUN_PROPERTY_COMPLEX_SCRIPT_ITALICS.toName());
            }
            if (RunParser.canBeSkipped(SkippableElement.RunProperty.RUN_PROPERTY_COMPLEX_SCRIPT_FONT_SIZE.toName(), preCombinedRunProperties, runProperties)) {
                skippableProperties.add(SkippableElement.RunProperty.RUN_PROPERTY_COMPLEX_SCRIPT_FONT_SIZE.toName());
            }
        }
        if (!skippableProperties.isEmpty()) {
            this.runBuilder.setRunProperties(runProperties.filteredBy(p -> !skippableProperties.contains(p.getName())));
        }
        this.runBuilder.refineCombinedRunProperties(this.paragraphStyle, this.runBuilder.getRunStyle(), runFonts);
    }

    private static boolean canBeSkipped(QName name, RunProperties preCombinedRunProperties, RunProperties runProperties) {
        boolean v;
        if (preCombinedRunProperties.contains(name) && runProperties.contains(name)) {
            RunProperty pcrp = (RunProperty)preCombinedRunProperties.filteredBy(p -> p.getName().equals(name)).properties().get(0);
            RunProperty rp = (RunProperty)runProperties.filteredBy(p -> p.getName().equals(name)).properties().get(0);
            v = pcrp.equals(rp);
        } else {
            v = true;
        }
        return v;
    }

    private void startRunParsing(XMLEvent e) throws XMLStreamException {
        if (XMLEventHelpers.isParagraphStartEvent(e) || XMLEventHelpers.isPhoneticGuideTextStartEvent(e) || XMLEventHelpers.isPhoneticGuideBaseTextStartEvent(e)) {
            this.parseNestedBlock(e.asStartElement());
        } else if (RunParser.isComplexFieldBegin(e)) {
            this.parseComplexField(e.asStartElement());
            this.runBuilder.setContainsComplexFields(true);
        } else if (!this.parseSkippableElements(e)) {
            this.parseContent(this.processTranslatableAttributes(e), this.startElementContext.getEventReader());
        }
    }

    private void parseRunPropertiesAndRunStyle(StartElement startElement) throws XMLStreamException {
        StartElementContext runPropertiesElementContext = new StartElementContext(startElement, this.runBuilder.getStartElementContext());
        RunProperties direct = new RunPropertiesParser(runPropertiesElementContext, this.runSkippableElements).parse();
        String runStyle = null == direct.getRunStyleProperty() ? null : direct.getRunStyleProperty().value();
        this.runBuilder.setRunStyle(runStyle);
        if ("w".equals(startElement.getName().getPrefix()) && !this.startElementContext.getConditionalParameters().getAllowWordStyleOptimisation()) {
            this.runBuilder.setRunProperties(direct);
        } else {
            this.runBuilder.setRunProperties(direct.minified(this.styleDefinitions.combinedRunProperties(this.paragraphStyle, runStyle, new RunProperties.Default(runPropertiesElementContext.getConditionalParameters(), runPropertiesElementContext.getEventFactory(), startElement.getName().getPrefix(), startElement.getName().getNamespaceURI(), startElement.getName().getLocalPart()))));
        }
    }

    private void clarifyVisibility() {
        if (this.startElementContext.getConditionalParameters().getTranslateWordHidden() || this.startElementContext.getConditionalParameters().getTranslatePowerpointHidden() || this.startElementContext.getConditionalParameters().getTranslateExcelHidden()) {
            this.runBuilder.setHidden(false);
        } else {
            RunProperty.ColorRunProperty colorRunProperty;
            RunProperties combinedRunProperties = this.styleDefinitions.combinedRunProperties(this.paragraphStyle, this.runBuilder.getRunStyle(), this.runBuilder.getRunProperties());
            for (Property property : combinedRunProperties.properties()) {
                if (!XMLEventHelpers.WPML_PROPERTY_VANISH.getLocalPart().equals(property.getName().getLocalPart()) || !(property instanceof RunProperty.WpmlToggleRunProperty)) continue;
                this.runBuilder.setHidden(((RunProperty.WpmlToggleRunProperty)property).getToggleValue());
                break;
            }
            if (!this.runBuilder.isHidden()) {
                RunProperty.StyleRunProperty styleRunProperty = this.runBuilder.getRunProperties().getRunStyleProperty();
                if (this.startElementContext.getConditionalParameters().getTranslateWordInExcludeStyleMode()) {
                    if (null != this.paragraphStyle) {
                        this.runBuilder.setHidden(this.startElementContext.getConditionalParameters().isWordExcludedStyle(this.paragraphStyle));
                    } else if (null != styleRunProperty) {
                        this.runBuilder.setHidden(this.startElementContext.getConditionalParameters().isWordExcludedStyle(styleRunProperty.value()));
                    }
                } else if (null != this.paragraphStyle) {
                    this.runBuilder.setHidden(!this.startElementContext.getConditionalParameters().isWordExcludedStyle(this.paragraphStyle));
                } else if (null != styleRunProperty) {
                    this.runBuilder.setHidden(!this.startElementContext.getConditionalParameters().isWordExcludedStyle(styleRunProperty.value()));
                } else if (this.startElementContext.getConditionalParameters().getTranslateWordInExcludeHighlightMode()) {
                    this.runBuilder.setHidden(true);
                }
            }
            if (!this.runBuilder.isHidden()) {
                RunProperty.HighlightRunProperty highlightRunProperty = combinedRunProperties.getHighlightProperty();
                if (this.startElementContext.getConditionalParameters().getTranslateWordInExcludeHighlightMode()) {
                    if (null != highlightRunProperty) {
                        this.runBuilder.setHidden(this.startElementContext.getConditionalParameters().isWordHighlight(highlightRunProperty.asColorValues()));
                    }
                } else if (null != highlightRunProperty) {
                    this.runBuilder.setHidden(!this.startElementContext.getConditionalParameters().isWordHighlight(highlightRunProperty.asColorValues()));
                } else {
                    this.runBuilder.setHidden(true);
                }
            }
            if (!this.runBuilder.isHidden() && null != (colorRunProperty = combinedRunProperties.getColorRunProperty())) {
                if (this.startElementContext.getConditionalParameters().getTranslateWordExcludeColors()) {
                    this.runBuilder.setHidden(this.startElementContext.getConditionalParameters().isWordExcludedColor(colorRunProperty.asColorValue()));
                }
                if (this.startElementContext.getConditionalParameters().getTranslateExcelExcludeColors()) {
                    this.runBuilder.setHidden(this.startElementContext.getConditionalParameters().isExcelExcludedColor(colorRunProperty.asColorValue()));
                }
            }
        }
    }

    private void parseNestedBlock(StartElement startElement) throws XMLStreamException {
        ContentCategoriesDetection contentCategoriesDetection;
        StyleOptimisation styleOptimisation;
        StyleDefinitions styleDefinitions;
        this.log("Nested block start event: " + String.valueOf(startElement));
        this.runBuilder.flushText();
        StartElementContext blockElementContext = new StartElementContext(startElement, this.startElementContext);
        if ("a".equals(startElement.getName().getPrefix())) {
            styleDefinitions = new StyleDefinitions.Empty();
            styleOptimisation = new StyleOptimisation.Default(new StyleOptimisation.Bypass(), this.startElementContext.getConditionalParameters(), this.startElementContext.getEventFactory(), this.startElementContext.presetColorValues(), this.startElementContext.highlightColorValues(), this.startElementContext.systemColorValues(), this.startElementContext.indexedColors(), this.startElementContext.theme(), new QName(startElement.getName().getNamespaceURI(), "pPr", startElement.getName().getPrefix()), new QName(startElement.getName().getNamespaceURI(), "defRPr", startElement.getName().getPrefix()), Collections.emptyList(), styleDefinitions);
            contentCategoriesDetection = new ContentCategoriesDetection.NonApplicable();
        } else {
            styleDefinitions = this.styleDefinitions;
            styleOptimisation = XMLEventHelpers.isPhoneticGuideTextStartEvent(startElement) || XMLEventHelpers.isPhoneticGuideBaseTextStartEvent(startElement) ? new StyleOptimisation.Bypass() : this.styleOptimisation;
            contentCategoriesDetection = this.contentCategoriesDetection;
        }
        BlockParser nestedBlockParser = new BlockParser(blockElementContext, styleDefinitions, styleOptimisation, this.numberingDefinitions, contentCategoriesDetection);
        Block nested = nestedBlockParser.parse();
        this.clarifyStartElementContextWith(nested.deferredEvents());
        nested.optimiseStyles();
        this.runBuilder.setContainsNestedItems(true);
        if (nested.hasVisibleRunContent()) {
            String referenceId = this.nestedIds.createId();
            nested.assign(referenceId);
            this.runBuilder.addToMarkup(this.startElementContext.getEventFactory().createCharacters(TextFragment.makeRefMarker(referenceId)));
            this.runBuilder.getNestedTextualItems().add(nested);
        } else {
            for (XMLEvent nestedEvent : nested.getEvents()) {
                this.runBuilder.addToMarkup(nestedEvent);
            }
            for (Chunk chunk : nested.getChunks()) {
                if (chunk instanceof Run) {
                    this.runBuilder.getNestedTextualItems().addAll(((Run)chunk).getNestedTextualItems());
                    continue;
                }
                if (!(chunk instanceof RunContainer)) continue;
                for (Chunk nestedChunk : ((RunContainer)chunk).getChunks()) {
                    if (!(nestedChunk instanceof Run)) continue;
                    this.runBuilder.getNestedTextualItems().addAll(((Run)nestedChunk).getNestedTextualItems());
                }
            }
        }
    }

    private void clarifyStartElementContextWith(Collection<XMLEvent> deferredEvents) {
        if (!deferredEvents.isEmpty()) {
            this.startElementContext = new StartElementContext(this.startElementContext.getStartElement(), this.startElementContext.getParentStartElement(), new PrioritisedXMLEventReader(new ConsumableXMLEventsReader(new XMLEventsReader(deferredEvents)), this.startElementContext.getEventReader()), this.startElementContext.presetColorValues(), this.startElementContext.highlightColorValues(), this.startElementContext.systemColorValues(), this.startElementContext.indexedColors(), this.startElementContext.theme(), this.startElementContext.getEventFactory(), this.startElementContext.getConditionalParameters());
        }
    }

    private void parseComplexField(StartElement startElement) throws XMLStreamException {
        String code = EMPTY;
        boolean extractable = false;
        boolean atComplexFieldResult = false;
        LinkedList<XMLEvent> deferredEvents = new LinkedList<XMLEvent>();
        ++this.complexFieldNestingLevel;
        this.parseComplexFieldBegin(startElement);
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent e = this.startElementContext.getEventReader().nextEvent();
            if (RunParser.isComplexFieldEnd(e)) {
                if (!extractable) {
                    this.parseSimpleElement(e.asStartElement());
                } else {
                    this.endComplexFieldParsing(e.asStartElement(), deferredEvents);
                }
                --this.complexFieldNestingLevel;
                return;
            }
            if (RunParser.isComplexFieldInstruction(e)) {
                String prevCode = code;
                code = this.parseComplexFieldCode(e.asStartElement());
                if (!prevCode.isEmpty()) continue;
                extractable = this.startElementContext.getConditionalParameters().tsComplexFieldDefinitionsToExtract.contains(code);
                continue;
            }
            if (RunParser.isComplexFieldSeparate(e)) {
                this.parseSimpleElement(e.asStartElement());
                atComplexFieldResult = true;
                continue;
            }
            if (RunParser.isComplexFieldBegin(e)) {
                if (extractable && !deferredEvents.isEmpty()) {
                    this.parseContentFrom(deferredEvents);
                }
                this.parseComplexField(e.asStartElement());
                continue;
            }
            if (!extractable || !atComplexFieldResult) {
                if (this.parseSkippableElements(e)) continue;
                this.runBuilder.addToMarkup(this.stripRevisionAttributes(e));
                continue;
            }
            if (XMLEventHelpers.isParagraphEndEvent(e)) {
                if (!deferredEvents.isEmpty()) {
                    this.parseContentFrom(deferredEvents);
                }
                deferredEvents.add(e);
                continue;
            }
            if (!deferredEvents.isEmpty()) {
                if (XMLEventHelpers.isParagraphPropertiesStartEvent(e)) {
                    StartElementContext blockPropertiesElementContext = new StartElementContext(e.asStartElement(), this.startElementContext);
                    ParagraphBlockProperties blockProperties = new MarkupComponentParser().parseParagraphBlockProperties(blockPropertiesElementContext, this.drawingRunPropertiesStrippableAttributes, this.blockPropertiesSkippableElements);
                    deferredEvents.addAll(blockProperties.getEvents());
                    continue;
                }
                if (this.parseSkippableElements(e)) continue;
                deferredEvents.add(e);
                continue;
            }
            this.parseContent(this.processTranslatableAttributes(this.stripRevisionAttributes(e)), this.startElementContext.getEventReader());
        }
    }

    private static boolean isComplexFieldBegin(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, COMPLEX_FIELD_CHARACTER) && BEGIN.equals(XMLEventHelpers.getAttributeValue(e.asStartElement(), COMPLEX_FIELD_CHARACTER_TYPE));
    }

    private static boolean isComplexFieldInstruction(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, COMPLEX_FIELD_INSTRUCTION);
    }

    private static boolean isComplexFieldSeparate(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, COMPLEX_FIELD_CHARACTER) && SEPARATE.equals(XMLEventHelpers.getAttributeValue(e.asStartElement(), COMPLEX_FIELD_CHARACTER_TYPE));
    }

    private static boolean isComplexFieldEnd(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, COMPLEX_FIELD_CHARACTER) && END.equals(XMLEventHelpers.getAttributeValue(e.asStartElement(), COMPLEX_FIELD_CHARACTER_TYPE));
    }

    private void parseComplexFieldBegin(StartElement startElement) throws XMLStreamException {
        this.runBuilder.addToMarkup(startElement);
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent event = this.startElementContext.getEventReader().nextEvent();
            this.runBuilder.addToMarkup(event);
            if (!event.isEndElement() || !event.asEndElement().getName().equals(startElement.getName())) continue;
            return;
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE + String.valueOf(startElement));
    }

    private void parseSimpleElement(StartElement startElement) throws XMLStreamException {
        this.runBuilder.addToMarkup(startElement);
        XMLEvent event = this.startElementContext.getEventReader().nextEvent();
        if (!event.isEndElement() || !event.asEndElement().getName().equals(startElement.getName())) {
            throw new IllegalStateException(UNEXPECTED_STRUCTURE + String.valueOf(event));
        }
        this.runBuilder.addToMarkup(event);
    }

    private boolean parseSkippableElements(XMLEvent e) throws XMLStreamException {
        if (this.runSkippableElements.skip(e)) {
            return true;
        }
        return this.blockSkippableElements.skip(e);
    }

    private void endComplexFieldParsing(StartElement startElement, Deque<XMLEvent> deferredEvents) throws XMLStreamException {
        if (this.goesAfterAnotherRun(deferredEvents)) {
            this.parseContentFrom(deferredEvents);
            this.parseSimpleElement(startElement);
        } else {
            Deque<XMLEvent> subtractedEvents = this.subtractAllFromLastOpeningRun(deferredEvents);
            this.parseContentFrom(subtractedEvents);
            this.parseSimpleElement(startElement);
            if (1 == this.complexFieldNestingLevel) {
                this.runBuilder.addDeferredEvents(deferredEvents);
            } else {
                this.parseToFirstClosingRun();
                this.parseContentFrom(deferredEvents);
            }
        }
    }

    private boolean goesAfterAnotherRun(Deque<XMLEvent> deferredEvents) {
        Iterator<XMLEvent> deferredEventsIterator = deferredEvents.descendingIterator();
        while (deferredEventsIterator.hasNext()) {
            XMLEvent event = deferredEventsIterator.next();
            if (!event.isEndElement() || !"r".equals(event.asEndElement().getName().getLocalPart())) continue;
            return true;
        }
        return false;
    }

    private void parseContentFrom(Collection<XMLEvent> deferredEvents) throws XMLStreamException {
        ConsumableXMLEventsReader eventReader = new ConsumableXMLEventsReader(new XMLEventsReader(deferredEvents));
        while (eventReader.hasNext()) {
            this.parseContent(this.processTranslatableAttributes(this.stripRevisionAttributes(eventReader.nextEvent())), eventReader);
        }
    }

    private Deque<XMLEvent> subtractAllFromLastOpeningRun(Deque<XMLEvent> deferredEvents) {
        LinkedList<XMLEvent> subtraction = new LinkedList<XMLEvent>();
        Iterator<XMLEvent> deferredEventsIterator = deferredEvents.descendingIterator();
        while (deferredEventsIterator.hasNext()) {
            XMLEvent event = deferredEventsIterator.next();
            subtraction.addFirst(event);
            deferredEventsIterator.remove();
            if (!XMLEventHelpers.isRunStartEvent(event)) continue;
            break;
        }
        return subtraction;
    }

    private void parseToFirstClosingRun() throws XMLStreamException {
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent event = this.startElementContext.getEventReader().nextEvent();
            this.parseContent(this.processTranslatableAttributes(this.stripRevisionAttributes(event)), this.startElementContext.getEventReader());
            if (!event.isEndElement() || !"r".equals(event.asEndElement().getName().getLocalPart())) continue;
            return;
        }
    }

    private String parseComplexFieldCode(StartElement startElement) throws XMLStreamException {
        this.runBuilder.addToMarkup(startElement);
        String codeName = EMPTY;
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent event = this.startElementContext.getEventReader().nextEvent();
            this.runBuilder.addToMarkup(event);
            if (event.isEndElement() && event.asEndElement().getName().equals(startElement.getName())) {
                return codeName;
            }
            if (!codeName.isEmpty() || !event.isCharacters()) continue;
            codeName = this.complexFieldCodeName(event.asCharacters());
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE + String.valueOf(startElement));
    }

    private String complexFieldCodeName(Characters characters) {
        String data = characters.getData().trim();
        int fieldCodeNameLength = data.indexOf(" ");
        String fieldCodeName = fieldCodeNameLength > 0 ? data.substring(0, fieldCodeNameLength) : data;
        return fieldCodeName;
    }

    private XMLEvent stripRevisionAttributes(XMLEvent e) {
        if (XMLEventHelpers.isParagraphStartEvent(e)) {
            return this.wordParagraphRevisions.strip(e.asStartElement());
        }
        if (XMLEventHelpers.isRunStartEvent(e)) {
            return this.wordRunRevisions.strip(e.asStartElement());
        }
        return e;
    }

    private void parseContent(XMLEvent e, XMLEventReader eventReader) throws XMLStreamException {
        if (XMLEventHelpers.isTextStartEvent(e)) {
            this.runBuilder.flushMarkup();
            this.parseText(e.asStartElement(), eventReader);
        } else if (this.startElementContext.getConditionalParameters().getAddTabAsCharacter() && XMLEventHelpers.isTabStartEvent(e) && !this.runBuilder.isHidden()) {
            this.runBuilder.flushMarkup();
            this.runBuilder.addText("\t");
            this.defaultSkippableElements.skip(new StartElementContext(e.asStartElement(), eventReader, this.startElementContext.presetColorValues(), this.startElementContext.highlightColorValues(), this.startElementContext.systemColorValues(), this.startElementContext.indexedColors(), this.startElementContext.theme(), null, this.startElementContext.getConditionalParameters()));
        } else if (XMLEventHelpers.isLineBreakStartEvent(e) && !XMLEventHelpers.isPageBreak(e.asStartElement()) && !this.runBuilder.isHidden()) {
            if (this.startElementContext.getConditionalParameters().getAddLineSeparatorCharacter()) {
                this.runBuilder.flushMarkup();
                char replacement = this.startElementContext.getConditionalParameters().getLineSeparatorReplacement();
                this.runBuilder.addText(String.valueOf(replacement));
                this.defaultSkippableElements.skip(new StartElementContext(e.asStartElement(), eventReader, this.startElementContext.presetColorValues(), this.startElementContext.highlightColorValues(), this.startElementContext.systemColorValues(), this.startElementContext.indexedColors(), this.startElementContext.theme(), null, this.startElementContext.getConditionalParameters()));
            } else {
                this.runBuilder.addToMarkup(new MarkupComponent.Start(this.startElementContext.getEventFactory(), e.asStartElement()));
            }
        } else if (this.startElementContext.getConditionalParameters().getReplaceNoBreakHyphenTag() && XMLEventHelpers.isNoBreakHyphenStartEvent(e)) {
            this.runBuilder.flushMarkup();
            this.runBuilder.addText("-");
            this.defaultSkippableElements.skip(new StartElementContext(e.asStartElement(), eventReader, this.startElementContext.presetColorValues(), this.startElementContext.highlightColorValues(), this.startElementContext.systemColorValues(), this.startElementContext.indexedColors(), this.startElementContext.theme(), null, this.startElementContext.getConditionalParameters()));
        } else if (!XMLEventHelpers.isWhitespace(e) || this.runBuilder.preservingWhitespace()) {
            this.runBuilder.flushText();
            this.runBuilder.setTextPreservingWhitespace(false);
            if (XMLEventHelpers.isParagraphStartEvent(e)) {
                this.runBuilder.addToMarkup(new MarkupComponent.StyledStart(this.startElementContext.getEventFactory(), this.styleDefinitions, e.asStartElement()));
            } else if (XMLEventHelpers.isParagraphPropertiesStartEvent(e)) {
                this.runBuilder.addToMarkup(new MarkupComponentParser().parseParagraphBlockProperties(new StartElementContext(e.asStartElement(), eventReader, this.startElementContext.presetColorValues(), this.startElementContext.highlightColorValues(), this.startElementContext.systemColorValues(), this.startElementContext.indexedColors(), this.startElementContext.theme(), this.startElementContext.getEventFactory(), this.startElementContext.getConditionalParameters()), this.drawingRunPropertiesStrippableAttributes, this.blockPropertiesSkippableElements));
            } else if (XMLEventHelpers.isParagraphEndEvent(e)) {
                this.runBuilder.addToMarkup(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
            } else if (!this.parseSkippableElements(e)) {
                if (XMLEventHelpers.isFootnoteReferenceStartEvent(e) || XMLEventHelpers.isFootnoteReferenceMarkStartEvent(e) || XMLEventHelpers.isEndnoteReferenceStartEvent(e) || XMLEventHelpers.isEndnoteReferenceMarkStartEvent(e)) {
                    this.runBuilder.noteReferencePresent(true);
                }
                this.runBuilder.addToMarkup(e);
            }
        }
    }

    private void parseText(StartElement startEvent, XMLEventReader events) throws XMLStreamException {
        this.runBuilder.setTextPreservingWhitespace(this.runBuilder.isTextPreservingWhitespace() || XMLEventHelpers.hasPreserveWhitespace(startEvent));
        while (events.hasNext()) {
            XMLEvent e = events.nextEvent();
            if (XMLEventHelpers.isEndElement(e, startEvent)) {
                return;
            }
            if (!e.isCharacters()) continue;
            String text = e.asCharacters().getData();
            if (text.trim().length() > 0) {
                this.runBuilder.nonWhitespaceTextPresent(true);
            }
            this.runBuilder.addText(text);
        }
    }

    private XMLEvent processTranslatableAttributes(XMLEvent e) {
        if (!e.isStartElement()) {
            return e;
        }
        StartElement startEl = e.asStartElement();
        if (XMLEventHelpers.isDrawingProperty(startEl)) {
            if (this.startElementContext.getConditionalParameters().getTranslateWordGraphicName()) {
                startEl = this.processTranslatableAttribute(startEl, "name");
            }
            if (this.startElementContext.getConditionalParameters().getTranslateWordGraphicDescription()) {
                startEl = this.processTranslatableAttribute(startEl, "descr");
            }
        } else if (XMLEventHelpers.isTextPath(startEl)) {
            startEl = this.processTranslatableAttribute(startEl, "string");
        }
        return startEl;
    }

    private StartElement processTranslatableAttribute(StartElement startEl, String attrName) {
        ArrayList<Attribute> newAttrs = new ArrayList<Attribute>();
        Iterator<Attribute> it = startEl.getAttributes();
        boolean dirty = false;
        while (it.hasNext()) {
            Attribute a = it.next();
            if (a.getName().getLocalPart().equals(attrName)) {
                this.runBuilder.setContainsNestedItems(true);
                String referenceId = this.nestedIds.createId();
                this.runBuilder.getNestedTextualItems().add(new TranslatableAttributeText(referenceId, a.getValue()));
                newAttrs.add(this.startElementContext.getEventFactory().createAttribute(a.getName(), TextFragment.makeRefMarker(referenceId)));
                dirty = true;
                continue;
            }
            newAttrs.add(a);
        }
        return dirty ? this.startElementContext.getEventFactory().createStartElement(startEl.getName(), newAttrs.iterator(), startEl.getNamespaces()) : startEl;
    }

    private void log(String s) {
        this.LOGGER.debug(s);
    }
}

