/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MergeableRunProperty;
import net.sf.okapi.filters.openxml.Nameable;
import net.sf.okapi.filters.openxml.Property;
import net.sf.okapi.filters.openxml.RunFonts;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.SchemaDefinition;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

abstract class RunProperties
implements MarkupComponent {
    static final String RPR = "rPr";
    static final String DEF_RPR = "defRPr";
    static final String END_PARA_RPR = "endParaRPr";

    RunProperties() {
    }

    abstract List<Property> properties();

    abstract RunProperties copied();

    abstract RunProperties filteredBy(Predicate<Property> var1);

    abstract RunProperties combineDistinct(RunProperties var1);

    abstract RunProperties minified(RunProperties var1);

    abstract RunProperties mergedWith(RunProperties var1);

    abstract RunProperty.FontsRunProperty fontsRunProperty();

    public int count() {
        return this.properties().size();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof RunProperties)) {
            return false;
        }
        return this.equalsProperties((RunProperties)o);
    }

    protected abstract boolean equalsProperties(RunProperties var1);

    public abstract int hashCode();

    @Override
    public abstract List<XMLEvent> getEvents();

    boolean contains(String name) {
        return this.properties().stream().anyMatch(p -> p.getName().getLocalPart().equals(name));
    }

    boolean contains(QName name) {
        return this.properties().stream().anyMatch(p -> p.getName().equals(name));
    }

    boolean contains(Property runProperty) {
        return this.properties().stream().anyMatch(p -> p.equals(runProperty));
    }

    RunProperty.StyleRunProperty getRunStyleProperty() {
        for (Property property : this.properties()) {
            if (!(property instanceof RunProperty.StyleRunProperty)) continue;
            return (RunProperty.StyleRunProperty)property;
        }
        return null;
    }

    RunProperty.HighlightRunProperty getHighlightProperty() {
        for (Property property : this.properties()) {
            if (!(property instanceof RunProperty.HighlightRunProperty)) continue;
            return (RunProperty.HighlightRunProperty)property;
        }
        return null;
    }

    RunProperty.ColorRunProperty getColorRunProperty() {
        for (Property property : this.properties()) {
            if (!(property instanceof RunProperty.ColorRunProperty)) continue;
            return (RunProperty.ColorRunProperty)property;
        }
        return null;
    }

    List<Property> getMergeableRunProperties() {
        ArrayList<Property> properties = new ArrayList<Property>(this.properties().size());
        for (Property property : this.properties()) {
            if (!(property instanceof MergeableRunProperty)) continue;
            properties.add(property);
        }
        return properties;
    }

    List<Property> attributeRunProperties() {
        return this.properties().stream().filter(runProperty -> runProperty instanceof RunProperty.AttributeRunProperty).collect(Collectors.toList());
    }

    void add(Property property) {
        this.properties().add(property);
    }

    void refine(List<Property> commonRunProperties) {
        for (Property commonRunProperty : commonRunProperties) {
            this.updateOrAdd(commonRunProperty);
        }
    }

    private void updateOrAdd(Property commonRunProperty) {
        ListIterator<Property> iterator = this.properties().listIterator();
        while (iterator.hasNext()) {
            Property currentRunProperty = iterator.next();
            if (!currentRunProperty.getName().equals(commonRunProperty.getName())) continue;
            iterator.set(commonRunProperty);
            return;
        }
        iterator.add(commonRunProperty);
    }

    void alignWith(SchemaDefinition.Component schemaDefinition) {
        if (this.properties().isEmpty()) {
            return;
        }
        ArrayList<Property> copiedProperties = new ArrayList<Property>(this.properties());
        List<Property> attributeRunProperties = this.attributeRunProperties();
        this.properties().retainAll(attributeRunProperties);
        copiedProperties.removeAll(attributeRunProperties);
        ListIterator<SchemaDefinition.Component> iterator = schemaDefinition.listIterator();
        while (iterator.hasNext() || !copiedProperties.isEmpty()) {
            SchemaDefinition.Component component = iterator.next();
            switch (component.composition()) {
                case CHOICE: 
                case SEQUENCE: 
                case ALL: {
                    this.findAndAppendMany(copiedProperties, component);
                    break;
                }
                case NONE: {
                    this.findAndAppendOne(copiedProperties, component);
                }
            }
        }
    }

    private void findAndAppendMany(List<Property> copiedProperties, SchemaDefinition.Component component) {
        ListIterator<SchemaDefinition.Component> componentsIterator = component.listIterator();
        while (componentsIterator.hasNext()) {
            SchemaDefinition.Component innerComponent = (SchemaDefinition.Component)componentsIterator.next();
            switch (innerComponent.composition()) {
                case CHOICE: 
                case SEQUENCE: 
                case ALL: {
                    this.findAndAppendMany(copiedProperties, innerComponent);
                    break;
                }
                case NONE: {
                    this.findAndAppendOne(copiedProperties, innerComponent);
                }
            }
        }
    }

    private void findAndAppendOne(List<Property> copiedProperties, SchemaDefinition.Component component) {
        Iterator<Property> copiedPropertiesIterator = copiedProperties.iterator();
        while (copiedPropertiesIterator.hasNext()) {
            Property runProperty = copiedPropertiesIterator.next();
            if (!runProperty.getName().equals(component.name())) continue;
            this.properties().add(runProperty);
            copiedPropertiesIterator.remove();
            return;
        }
    }

    void removeBy(QName name) {
        Iterator<Property> propertiesIterator = this.properties().iterator();
        while (propertiesIterator.hasNext()) {
            Property currentRunProperty = propertiesIterator.next();
            if (!currentRunProperty.getName().equals(name)) continue;
            propertiesIterator.remove();
            return;
        }
    }

    boolean isSubsetOf(RunProperties other) {
        if (this.properties().isEmpty() && !other.properties().isEmpty()) {
            return false;
        }
        block0: for (Property myProperty : this.properties()) {
            for (Property otherProperty : other.properties()) {
                if (!otherProperty.equals(myProperty)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    static class Default
    extends RunProperties
    implements Nameable {
        private static final Set<String> OMITTED_WITH_NONE_OR_NIL = new HashSet<String>(Arrays.asList("brd", "effect", "em", "highlight", "u", "cap", "scheme"));
        private static final Set<String> NONE_AND_NIL = new HashSet<String>(Arrays.asList("none", "nil"));
        private static final Set<String> OMITTED_WITH_ZERO = new HashSet<String>(Arrays.asList("kern", "position", "baseline", "spc"));
        private static final String ZERO = "0";
        private static final Set<String> OMITTED_WITH_HUNDRED = Collections.singleton("w");
        private static final String HUNDRED = "100";
        private static final Set<String> OMITTED_WITH_BASELINE = Collections.singleton("vertAlign");
        private static final String BASELINE = "baseline";
        private static final Set<String> OMITTED_WITH_NO_STRIKE = Collections.singleton("strike");
        private static final String NO_STRIKE = "noStrike";
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private final EndElement endElement;
        private final List<Property> properties;

        Default(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, String prefix, String namespaceUri, String name) {
            this(conditionalParameters, eventFactory, eventFactory.createStartElement(prefix, namespaceUri, name), eventFactory.createEndElement(prefix, namespaceUri, name));
        }

        Default(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, StartElement startElement, EndElement endElement) {
            this(conditionalParameters, eventFactory, startElement, endElement, new ArrayList<Property>());
        }

        Default(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, StartElement startElement, EndElement endElement, List<Property> properties) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.startElement = startElement;
            this.endElement = endElement;
            this.properties = properties;
        }

        @Override
        public List<Property> properties() {
            return this.properties;
        }

        @Override
        public RunProperties copied() {
            return new Default(this.conditionalParameters, this.eventFactory, this.startElement, this.endElement, new ArrayList<Property>(this.properties));
        }

        @Override
        public RunProperties filteredBy(Predicate<Property> predicate) {
            return new Default(this.conditionalParameters, this.eventFactory, this.startElement, this.endElement, this.properties.stream().filter(predicate).collect(Collectors.toList()));
        }

        @Override
        RunProperties minified(RunProperties preCombined) {
            List<Property> minified = this.properties().stream().filter(p -> !(!(p instanceof RunProperty.SmlRunProperty) && (preCombined.contains((Property)p) || (p instanceof RunProperty.WpmlToggleRunProperty && !((RunProperty.WpmlToggleRunProperty)p).getToggleValue() || p instanceof RunProperty.BooleanAttributeRunProperty && !((RunProperty.BooleanAttributeRunProperty)p).booleanValue() || OMITTED_WITH_NONE_OR_NIL.contains(p.getName().getLocalPart()) && NONE_AND_NIL.contains(p.value()) || OMITTED_WITH_ZERO.contains(p.getName().getLocalPart()) && ZERO.equals(p.value()) || OMITTED_WITH_HUNDRED.contains(p.getName().getLocalPart()) && HUNDRED.equals(p.value()) || OMITTED_WITH_BASELINE.contains(p.getName().getLocalPart()) && BASELINE.equals(p.value()) || OMITTED_WITH_NO_STRIKE.contains(p.getName().getLocalPart()) && NO_STRIKE.equals(p.value())) && !preCombined.contains(p.getName())))).collect(Collectors.toList());
            return new Default(this.conditionalParameters, this.eventFactory, this.eventFactory.createStartElement(this.startElement.getName(), null, null), this.endElement, minified);
        }

        @Override
        RunProperties mergedWith(RunProperties runProperties) {
            return this.copied().combineDistinct(runProperties);
        }

        @Override
        RunProperty.FontsRunProperty fontsRunProperty() {
            return (RunProperty.FontsRunProperty)this.properties().stream().filter(p -> p instanceof RunProperty.FontsRunProperty).findFirst().orElse(new RunProperty.FontsRunProperty(new RunFonts(this.conditionalParameters, this.eventFactory, this.eventFactory.createStartElement(this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), "rFonts"), new EnumMap<RunFonts.ContentCategory, String>(RunFonts.ContentCategory.class), EnumSet.noneOf(RunFonts.ContentCategory.class))));
        }

        @Override
        public void apply(FontMappings fontMappings) {
            this.properties.forEach(p -> {
                if (p instanceof RunProperty.FontsRunProperty) {
                    p.apply(fontMappings);
                } else if (p instanceof RunProperty.FontRunProperty) {
                    p.apply(fontMappings);
                }
            });
        }

        @Override
        public List<XMLEvent> getEvents() {
            if (this.properties().isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            List<Property> attributeRunProperties = this.attributeRunProperties();
            List otherRunProperties = this.properties.stream().filter(runProperty -> !attributeRunProperties.contains(runProperty)).collect(Collectors.toList());
            events.add(this.eventFactory.createStartElement(this.startElement.getName(), this.toAttributes(this.attributeRunProperties()).iterator(), this.startElement.getNamespaces()));
            for (Property property : otherRunProperties) {
                events.addAll(property.getEvents());
            }
            events.add(this.endElement);
            return events;
        }

        private List<Attribute> toAttributes(List<Property> properties) {
            return properties.stream().map(property -> this.eventFactory.createAttribute(property.getName(), property.value())).collect(Collectors.toCollection(() -> new ArrayList(properties.size())));
        }

        @Override
        public QName getName() {
            return this.startElement.getName();
        }

        @Override
        public RunProperties combineDistinct(RunProperties otherProperties) {
            ListIterator<Property> runPropertyIterator = this.properties.listIterator();
            while (runPropertyIterator.hasNext()) {
                Property runProperty = runPropertyIterator.next();
                QName runPropertyStartElementName = runProperty.getName();
                Iterator<Property> otherRunPropertyIterator = otherProperties.properties().iterator();
                while (otherRunPropertyIterator.hasNext()) {
                    Property otherRunProperty = otherRunPropertyIterator.next();
                    if (!runPropertyStartElementName.equals(otherRunProperty.getName())) continue;
                    runPropertyIterator.set(otherRunProperty);
                    otherRunPropertyIterator.remove();
                    break;
                }
                if (!otherProperties.properties().isEmpty()) continue;
                break;
            }
            if (!otherProperties.properties().isEmpty()) {
                this.properties.addAll(otherProperties.properties());
            }
            return this;
        }

        @Override
        protected boolean equalsProperties(RunProperties o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default rp = (Default)o;
            if (!XMLEventHelpers.startElementEquals(this.startElement, rp.startElement)) {
                return false;
            }
            return this.properties.equals(rp.properties);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.startElement, this.endElement, this.properties);
        }

        public String toString() {
            return this.startElement.getName().getLocalPart().concat("(").concat(String.valueOf(this.properties.size())).concat(")[").concat(this.properties.toString()).concat("]");
        }
    }

    static class Empty
    extends RunProperties {
        Empty() {
        }

        @Override
        public void apply(FontMappings fontMappings) {
        }

        @Override
        List<Property> properties() {
            return Collections.emptyList();
        }

        @Override
        RunProperties copied() {
            return this;
        }

        @Override
        RunProperties filteredBy(Predicate<Property> predicate) {
            return this;
        }

        @Override
        RunProperties combineDistinct(RunProperties otherProperties) {
            return otherProperties;
        }

        @Override
        RunProperties minified(RunProperties preCombined) {
            return preCombined;
        }

        @Override
        RunProperties mergedWith(RunProperties runProperties) {
            return runProperties;
        }

        @Override
        RunProperty.FontsRunProperty fontsRunProperty() {
            throw new UnsupportedOperationException("The operation is unsupported");
        }

        @Override
        protected boolean equalsProperties(RunProperties rp) {
            return rp instanceof Empty;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public List<XMLEvent> getEvents() {
            return Collections.emptyList();
        }
    }
}

