/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.openxml.Color;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.MergeableRunProperty;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.Property;
import net.sf.okapi.filters.openxml.ReplaceableRunProperty;
import net.sf.okapi.filters.openxml.RunFonts;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertyFactory;
import net.sf.okapi.filters.openxml.SystemColorValues;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEventSerializer;

abstract class RunProperty
implements Property,
ReplaceableRunProperty {
    RunProperty() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof RunProperty)) {
            return false;
        }
        return this.equalsProperty((RunProperty)o);
    }

    protected abstract boolean equalsProperty(RunProperty var1);

    public abstract int hashCode();

    @Override
    public abstract List<XMLEvent> getEvents();

    @Override
    public boolean canBeReplaced(ReplaceableRunProperty runProperty) {
        return this.equalsProperty((RunProperty)runProperty);
    }

    @Override
    public ReplaceableRunProperty replace(ReplaceableRunProperty runProperty) {
        return runProperty;
    }

    @Override
    public RunProperties asRunProperties() throws XMLStreamException {
        throw new IllegalStateException("The operation is not supported");
    }

    @Override
    public void apply(FontMappings fontMappings) {
    }

    static final class FontRunProperty
    extends GenericRunProperty {
        static final Set<String> DML_NAMES = new HashSet<String>(Arrays.asList("latin", "ea", "cs", "sym"));
        static final Set<String> SML_NAMES = new HashSet<String>(Arrays.asList("rFont", "name"));
        static final QName TYPEFACE = new QName("", "typeface", "");
        private final QName VAL = new QName("", "val", "");
        private final XMLEventFactory eventFactory;

        FontRunProperty(List<XMLEvent> events, XMLEventFactory eventFactory) {
            super(events);
            this.eventFactory = eventFactory;
        }

        @Override
        public void apply(FontMappings fontMappings) {
            String newValue;
            StartElement startElement = this.getEvents().get(0).asStartElement();
            String value = this.value();
            if (value.equals(newValue = fontMappings.targetFontFor(value))) {
                return;
            }
            LinkedList<Attribute> attributes = new LinkedList<Attribute>();
            Iterator<Attribute> iterator = startElement.getAttributes();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                if (TYPEFACE.equals(attribute.getName()) || this.VAL.equals(attribute.getName())) {
                    attributes.add(this.eventFactory.createAttribute(attribute.getName(), newValue));
                    continue;
                }
                attributes.add(attribute);
            }
            this.getEvents().set(0, this.eventFactory.createStartElement(startElement.getName(), attributes.iterator(), null));
        }

        @Override
        public String value() {
            StartElement startElement = this.getEvents().get(0).asStartElement();
            if (DML_NAMES.contains(startElement.getName().getLocalPart())) {
                return XMLEventHelpers.getAttributeValue(startElement, TYPEFACE);
            }
            if (SML_NAMES.contains(startElement.getName().getLocalPart())) {
                return XMLEventHelpers.getAttributeValue(startElement, this.VAL);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        protected boolean equalsProperty(RunProperty rp) {
            if (!(rp instanceof FontRunProperty)) {
                return false;
            }
            return super.equalsProperty(rp);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public String toString() {
            return FontRunProperty.class.getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }

    static class FontsRunProperty
    extends RunProperty
    implements MergeableRunProperty {
        private RunFonts runFonts;

        FontsRunProperty(RunFonts runFonts) {
            this.runFonts = runFonts;
        }

        RunFonts getRunFonts() {
            return this.runFonts;
        }

        @Override
        public void apply(FontMappings fontMappings) {
            this.runFonts.apply(fontMappings);
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.runFonts.getEvents();
        }

        @Override
        public QName getName() {
            return this.getEvents().get(0).asStartElement().getName();
        }

        @Override
        public String value() {
            return null;
        }

        @Override
        public boolean canBeMerged(MergeableRunProperty runProperty) {
            if (!(runProperty instanceof FontsRunProperty)) {
                return false;
            }
            return this.runFonts.canBeMerged(((FontsRunProperty)runProperty).runFonts);
        }

        @Override
        public MergeableRunProperty merge(MergeableRunProperty runProperty) {
            return new FontsRunProperty(this.runFonts.merge(((FontsRunProperty)runProperty).runFonts));
        }

        @Override
        protected boolean equalsProperty(RunProperty runProperty) {
            if (!(runProperty instanceof FontsRunProperty)) {
                return false;
            }
            return this.runFonts.equals(((FontsRunProperty)runProperty).runFonts);
        }

        @Override
        public int hashCode() {
            return this.runFonts.hashCode();
        }

        public String toString() {
            return FontsRunProperty.class.getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }

    static class HyperlinkRunProperty
    extends GenericRunProperty {
        private static final QName ID = Namespaces.DocumentRelationships.getQName("id");

        HyperlinkRunProperty(List<XMLEvent> events) {
            super(events);
        }

        @Override
        public String value() {
            StartElement startElement = this.getEvents().get(0).asStartElement();
            if (startElement.getAttributeByName(XMLEventHelpers.DML_HYPERLINK_ACTION) != null) {
                return startElement.getAttributeByName(XMLEventHelpers.DML_HYPERLINK_ACTION).getValue();
            }
            if (startElement.getAttributeByName(ID) != null) {
                return startElement.getAttributeByName(ID).getValue();
            }
            return null;
        }
    }

    static class BooleanAttributeRunProperty
    extends AttributeRunProperty {
        private boolean value;

        BooleanAttributeRunProperty(QName name, String value) {
            super(name, value);
            this.value = XMLEventHelpers.booleanAttributeTrueValues().contains(value);
        }

        public boolean booleanValue() {
            return this.value;
        }

        @Override
        protected boolean equalsProperty(RunProperty runProperty) {
            if (!(runProperty instanceof BooleanAttributeRunProperty)) {
                return false;
            }
            BooleanAttributeRunProperty other = (BooleanAttributeRunProperty)runProperty;
            return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.value, other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getName(), this.value);
        }

        @Override
        public String toString() {
            return BooleanAttributeRunProperty.class.getSimpleName() + "(" + this.getName().toString() + "=" + this.value + ")";
        }
    }

    static class AttributeRunProperty
    extends RunProperty {
        private QName name;
        private String value;

        AttributeRunProperty(QName name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        protected boolean equalsProperty(RunProperty rp) {
            if (!(rp instanceof AttributeRunProperty)) {
                return false;
            }
            AttributeRunProperty other = (AttributeRunProperty)rp;
            return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.value(), other.value());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }

        @Override
        public List<XMLEvent> getEvents() {
            return Collections.emptyList();
        }

        @Override
        public QName getName() {
            return this.name;
        }

        @Override
        public String value() {
            return this.value;
        }

        public String toString() {
            return "AttributeRunProperty(" + String.valueOf(this.name) + "=" + this.value + ")";
        }
    }

    static class SmlRunProperty
    extends GenericRunProperty {
        private String value = super.value();

        SmlRunProperty(List<XMLEvent> events) {
            super(events);
        }

        @Override
        protected boolean equalsProperty(RunProperty runProperty) {
            if (!(runProperty instanceof SmlRunProperty)) {
                return false;
            }
            return XMLEventHelpers.eventEquals(this.getEvents().get(0), runProperty.getEvents().get(0)) && Objects.equals(this.value, ((SmlRunProperty)runProperty).value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @Override
        public String toString() {
            return SmlRunProperty.class.getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }

        public String getDefaultValue() {
            return RunPropertyFactory.SmlPropertyName.fromString(this.getEvents().get(0).asStartElement().getName().getLocalPart()).getDefaultValue();
        }
    }

    static class WpmlToggleRunProperty
    extends GenericRunProperty {
        private boolean value;

        WpmlToggleRunProperty(List<XMLEvent> events) {
            super(events);
            this.value = XMLEventHelpers.getBooleanAttributeValue(events.get(0).asStartElement(), XMLEventHelpers.WPML_VAL, XMLEventHelpers.DEFAULT_BOOLEAN_ATTRIBUTE_TRUE_VALUE);
        }

        public boolean getToggleValue() {
            return this.value;
        }

        @Override
        protected boolean equalsProperty(RunProperty runProperty) {
            if (!(runProperty instanceof WpmlToggleRunProperty)) {
                return false;
            }
            return XMLEventHelpers.eventEquals(this.getEvents().get(0), runProperty.getEvents().get(0)) && Objects.equals(this.value, ((WpmlToggleRunProperty)runProperty).value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @Override
        public String toString() {
            return WpmlToggleRunProperty.class.getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }

    static class ColorRunProperty
    extends GenericRunProperty {
        static final String NAME = "color";
        private static final String EMPTY = "";
        private final ConditionalParameters conditionalParameters;
        private final PresetColorValues presetColorValues;
        private final Color color;
        private String value;

        ColorRunProperty(ConditionalParameters conditionalParameters, PresetColorValues presetColorValues, Color color) {
            super(color.asMarkup().getEvents());
            this.conditionalParameters = conditionalParameters;
            this.presetColorValues = presetColorValues;
            this.color = color;
        }

        @Override
        public String value() {
            if (null == this.value) {
                this.value = this.color.value().asRgb();
            }
            return this.value;
        }

        Color.Value asColorValue() {
            return this.color.value();
        }

        private Color.Value asColorValueFor(String value) {
            Color.Value pcv = this.presetColorValues.valueFor(value);
            Color.Value cv = pcv.asInternalName().isEmpty() && pcv.asExternalName().isEmpty() && pcv.asRgb().isEmpty() ? new Color.Default.Value(EMPTY, EMPTY, value) : pcv;
            return cv;
        }

        @Override
        protected boolean equalsProperty(RunProperty runProperty) {
            if (!(runProperty instanceof ColorRunProperty)) {
                return false;
            }
            if (this.conditionalParameters.getIgnoreWordFontColors()) {
                ColorRunProperty op = (ColorRunProperty)runProperty;
                if (!this.conditionalParameters.getWordFontColorsMinIgnoranceThreshold().isEmpty() && this.conditionalParameters.getWordFontColorsMaxIgnoranceThreshold().isEmpty()) {
                    Color.Value minIgnoranceThreshold = this.asColorValueFor(this.conditionalParameters.getWordFontColorsMinIgnoranceThreshold());
                    return minIgnoranceThreshold.lessThanOrEqualTo(this.asColorValue()) && minIgnoranceThreshold.lessThanOrEqualTo(op.asColorValue());
                }
                if (this.conditionalParameters.getWordFontColorsMinIgnoranceThreshold().isEmpty() && !this.conditionalParameters.getWordFontColorsMaxIgnoranceThreshold().isEmpty()) {
                    Color.Value maxIgnoranceThreshold = this.asColorValueFor(this.conditionalParameters.getWordFontColorsMaxIgnoranceThreshold());
                    return this.asColorValue().lessThanOrEqualTo(maxIgnoranceThreshold) && op.asColorValue().lessThanOrEqualTo(maxIgnoranceThreshold);
                }
                if (!this.conditionalParameters.getWordFontColorsMinIgnoranceThreshold().isEmpty() && !this.conditionalParameters.getWordFontColorsMaxIgnoranceThreshold().isEmpty()) {
                    Color.Value minIgnoranceThreshold = this.asColorValueFor(this.conditionalParameters.getWordFontColorsMinIgnoranceThreshold());
                    Color.Value maxIgnoranceThreshold = this.asColorValueFor(this.conditionalParameters.getWordFontColorsMaxIgnoranceThreshold());
                    return minIgnoranceThreshold.lessThanOrEqualTo(this.asColorValue()) && minIgnoranceThreshold.lessThanOrEqualTo(op.asColorValue()) && this.asColorValue().lessThanOrEqualTo(maxIgnoranceThreshold) && op.asColorValue().lessThanOrEqualTo(maxIgnoranceThreshold);
                }
                return true;
            }
            return Objects.equals(this.value(), runProperty.value());
        }

        @Override
        public int hashCode() {
            return this.value().hashCode();
        }

        @Override
        public String toString() {
            return ColorRunProperty.class.getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }

    static class HighlightRunProperty
    extends GenericRunProperty {
        static final String NAME = "highlight";
        private final PresetColorValues highlightColorValues;
        private String value;
        private List<Color.Value> colorValues;

        HighlightRunProperty(PresetColorValues highlightColorValues, List<XMLEvent> events) {
            super(events);
            this.highlightColorValues = highlightColorValues;
        }

        @Override
        public String value() {
            if (null == this.value) {
                this.value = this.valueIn(this.getEvents().get(0).asStartElement().getAttributes());
            }
            return this.value;
        }

        private String valueIn(Iterator<Attribute> attributes) {
            String v = "none";
            while (attributes.hasNext()) {
                Attribute a = attributes.next();
                if (!"val".equals(a.getName().getLocalPart())) continue;
                v = a.getValue();
                break;
            }
            return v;
        }

        List<Color.Value> asColorValues() {
            if (null == this.colorValues) {
                this.colorValues = this.highlightColorValues.valuesFor(this.value());
            }
            return this.colorValues;
        }

        @Override
        protected boolean equalsProperty(RunProperty runProperty) {
            if (!(runProperty instanceof HighlightRunProperty)) {
                return false;
            }
            return this.asColorValues().stream().anyMatch(v -> ((HighlightRunProperty)runProperty).asColorValues().stream().anyMatch(ov -> ov.matches(v.asRgb())));
        }

        @Override
        public int hashCode() {
            return this.value().hashCode();
        }

        @Override
        public String toString() {
            return HighlightRunProperty.class.getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }

    static class StyleRunProperty
    extends GenericRunProperty {
        static final String NAME = "rStyle";
        private String value;

        StyleRunProperty(List<XMLEvent> events) {
            super(events);
            this.value = XMLEventHelpers.getAttributeValue(events.get(0).asStartElement(), XMLEventHelpers.WPML_VAL);
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        protected boolean equalsProperty(RunProperty runProperty) {
            if (!(runProperty instanceof StyleRunProperty)) {
                return false;
            }
            return Objects.equals(this.value, ((StyleRunProperty)runProperty).value);
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return StyleRunProperty.class.getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }

    static class ShadeRunProperty
    extends GenericRunProperty {
        static final String NAME = "shd";
        private static final String FILL = "fill";
        static final String DEFAULT_FILL_VALUE = "auto";
        private static final String EMPTY = "";
        private final Color.Value defaultFillColorValue;
        private Color.Value fillColorValue;

        ShadeRunProperty(SystemColorValues systemColorValues, List<XMLEvent> events) {
            super(events);
            this.defaultFillColorValue = new Color.Default.Value(DEFAULT_FILL_VALUE, "Auto", systemColorValues.valueFor("window").asRgb());
        }

        Color.Value asFillColorValue() {
            if (Objects.isNull(this.fillColorValue)) {
                this.fillColorValue = this.defaultFillColorValue;
                Iterator<Attribute> attributes = this.getEvents().get(0).asStartElement().getAttributes();
                while (attributes.hasNext()) {
                    Attribute a = attributes.next();
                    if (!FILL.equals(a.getName().getLocalPart())) continue;
                    this.fillColorValue = new Color.Default.Value(EMPTY, EMPTY, a.getValue());
                    break;
                }
            }
            return this.fillColorValue;
        }

        @Override
        protected boolean equalsProperty(RunProperty rp) {
            if (!(rp instanceof ShadeRunProperty)) {
                return false;
            }
            return super.equalsProperty(rp);
        }

        @Override
        public String toString() {
            return ShadeRunProperty.class.getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }

    static class GenericRunProperty
    extends RunProperty {
        private final List<XMLEvent> events;

        GenericRunProperty(List<XMLEvent> events) {
            this.events = events;
        }

        @Override
        protected boolean equalsProperty(RunProperty rp) {
            if (!(rp instanceof GenericRunProperty)) {
                return false;
            }
            return XMLEventHelpers.eventEquals(this.events, ((GenericRunProperty)rp).events);
        }

        @Override
        public int hashCode() {
            return this.events.hashCode();
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.events;
        }

        @Override
        public QName getName() {
            return this.events.get(0).asStartElement().getName();
        }

        @Override
        public String value() {
            StartElement startElement = this.events.get(0).asStartElement();
            QName name = new QName("".equals(startElement.getName().getPrefix()) ? "" : startElement.getName().getNamespaceURI(), "val", startElement.getName().getPrefix());
            return XMLEventHelpers.getAttributeValue(startElement, name);
        }

        public String toString() {
            return "GenericRunProperty(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
        }
    }
}

