/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.XMLEventsReader;
import net.sf.okapi.common.annotation.XLIFFContextGroup;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.ISubFilter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.filters.openxml.Cell;
import net.sf.okapi.filters.openxml.CellReferencesRange;
import net.sf.okapi.filters.openxml.CellType;
import net.sf.okapi.filters.openxml.Cells;
import net.sf.okapi.filters.openxml.CellsPair;
import net.sf.okapi.filters.openxml.ChartFragments;
import net.sf.okapi.filters.openxml.ContentCategoriesDetection;
import net.sf.okapi.filters.openxml.CrossSheetCellReference;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.Metadata;
import net.sf.okapi.filters.openxml.MetadataContext;
import net.sf.okapi.filters.openxml.Namespace;
import net.sf.okapi.filters.openxml.NumberingDefinitions;
import net.sf.okapi.filters.openxml.SharedStrings;
import net.sf.okapi.filters.openxml.SourceAndTargetColumns;
import net.sf.okapi.filters.openxml.StringItem;
import net.sf.okapi.filters.openxml.StringItemsMapping;
import net.sf.okapi.filters.openxml.StringItemsPair;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.StyledTextPart;
import net.sf.okapi.filters.openxml.StyledTextSkeletonWriter;

class SharedStringsPart
extends StyledTextPart {
    static final String NAME = "sharedStrings.xml";
    private static final String EMPTY = "";
    private static final String ROW_METADATA = "row-metadata";
    private static final String WORKSHEETS = "worksheets";
    private static final String ROWS = "rows";
    private final EncoderManager encoderManager;
    private final IFilter subfilter;
    private final Map<Metadata, Set<String>> dispersedTranslationRawSourcesByMetadata;
    private final Cells cells;
    private IdGenerator worksheetGroupIds;
    private IdGenerator rowGroupIds;
    private StartGroup worksheetStartGroup;
    private StartGroup rowStartGroup;
    private ContextTypes contextTypes;
    private List<XLIFFContextGroup.Context> groupContexts;

    SharedStringsPart(Document.General generalDocument, ZipEntry entry, StyleDefinitions styleDefinitions, StyleOptimisation styleOptimisation, NumberingDefinitions numberingDefinitions, ContentCategoriesDetection contentCategoriesDetection, ChartFragments chartFragments, EncoderManager encoderManager, IFilter subfilter, Map<Metadata, Set<String>> dispersedTranslationRawSourcesByMetadata, Cells cells) {
        super(generalDocument, entry, styleDefinitions, styleOptimisation, numberingDefinitions, contentCategoriesDetection, chartFragments);
        this.encoderManager = encoderManager;
        this.subfilter = subfilter;
        this.dispersedTranslationRawSourcesByMetadata = dispersedTranslationRawSourcesByMetadata;
        this.cells = cells;
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.documentId = this.generalDocument.documentId();
        this.subDocumentId = this.generalDocument.nextSubDocumentId();
        this.worksheetGroupIds = new IdGenerator(WORKSHEETS, "sg");
        SharedStrings.Default sharedStrings = new SharedStrings.Default(this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.generalDocument.presetColorValues(), this.generalDocument.highlightColorValues(), this.generalDocument.systemColorValues(), this.generalDocument.indexedColors(), this.generalDocument.mainPartTheme(), this.styleDefinitions, this.styleOptimisation, this.numberingDefinitions, this.contentCategoriesDetection);
        if (null == this.generalDocument.zipFile().getEntry(this.entry.getName())) {
            sharedStrings.readWith(new XMLEventsReader(this.emptyPartEvents()));
        } else {
            try (Reader reader = this.generalDocument.getPartReader(this.entry.getName());){
                sharedStrings.readWith(this.generalDocument.inputFactory().createXMLEventReader(reader));
            }
        }
        sharedStrings.addFrom(this.cells.of(CellType.INLINE_STRING));
        if (this.generalDocument.conditionalParameters().getTranslateExcelCellsCopied()) {
            this.formContextualisedEventsFor(sharedStrings);
        } else {
            this.formNonContextualisedEventsFor(sharedStrings);
        }
        return this.createStartSubDocumentEvent(this.documentId, this.subDocumentId);
    }

    private List<XMLEvent> emptyPartEvents() throws XMLStreamException, IOException {
        Iterator<Namespace> iterator = this.generalDocument.mainPartNamespaces().with(EMPTY).iterator();
        if (!iterator.hasNext()) {
            throw new OkapiBadFilterInputException("The main part namespace with empty prefix is not found");
        }
        Namespace n = iterator.next();
        String prefix = n.prefix();
        String namespaceUri = n.uri();
        Iterator<javax.xml.stream.events.Namespace> namespacesIterator = Collections.singletonList(this.generalDocument.eventFactory().createNamespace(prefix, namespaceUri)).iterator();
        return Arrays.asList(this.generalDocument.eventFactory().createStartDocument("1.0", StyledTextSkeletonWriter.XML_ENCODING), this.generalDocument.eventFactory().createStartElement(prefix, namespaceUri, "sst", null, namespacesIterator), this.generalDocument.eventFactory().createEndElement(prefix, namespaceUri, "sst"), this.generalDocument.eventFactory().createEndDocument());
    }

    private void formNonContextualisedEventsFor(SharedStrings sharedStrings) {
        this.addEventToDocumentPart(sharedStrings.startDocument());
        this.addEventToDocumentPart(sharedStrings.startElement());
        this.flushDocumentPart();
        ListIterator<Cell> iterator = this.cells.iterator();
        while (iterator.hasNext()) {
            Cell cell = iterator.next();
            if (cell.value().empty() || CellType.INLINE_STRING != cell.type() && CellType.SHARED_STRING != cell.type()) continue;
            this.formEventsFor(new StringItemsPair(sharedStrings.stringItemFor(cell.value().asFormerInteger())), new CellsPair(cell));
        }
        this.addEventToDocumentPart(sharedStrings.endElement());
        this.addEventToDocumentPart(sharedStrings.endDocument());
        this.flushDocumentPart();
        this.filterEvents.add(new Event(EventType.END_SUBDOCUMENT, new Ending(this.subDocumentId)));
        this.filterEventIterator = this.filterEvents.iterator();
    }

    private void formEventsFor(StringItemsPair stringItemsPair, CellsPair cellsPair) {
        if (cellsPair.excluded()) {
            this.addBlockChunksToDocumentPart(stringItemsPair.chunks());
            this.flushDocumentPart();
            return;
        }
        CrossSheetCellReference crossSheetCellReference = new CrossSheetCellReference(cellsPair.worksheetName(), cellsPair.cellReferencesRange().first());
        List<ITextUnit> textUnits = new StringItemsMapping(this.generalDocument.targetLocale(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.textUnitIds, stringItemsPair, crossSheetCellReference).textUnits();
        if (textUnits.isEmpty()) {
            this.addBlockChunksToDocumentPart(stringItemsPair.chunks());
            this.flushDocumentPart();
        } else {
            if (this.subfilter != null && !stringItemsPair.styled()) {
                this.addSubfilteredEvents(textUnits);
            } else {
                this.addTextUnitEvents(textUnits);
            }
            String rawSource = stringItemsPair.text();
            this.dispersedTranslationRawSourcesByMetadata.entrySet().stream().filter(e -> ((Metadata)e.getKey()).worksheetLocalisedName().equals(cellsPair.worksheetName()) && ((Metadata)e.getKey()).cellReferencesRange().anyMatch(cellsPair.cellReferencesRange()) && ((Set)e.getValue()).contains(rawSource)).forEach(e -> this.generalDocument.dispersedTranslations().add(crossSheetCellReference, ((Metadata)e.getKey()).name(), rawSource));
        }
    }

    private void formContextualisedEventsFor(SharedStrings sharedStrings) {
        SourceAndTargetColumns sourceAndTargetColumns = new SourceAndTargetColumns.Default(Collections.emptyList(), Collections.emptyList());
        HashMap<String, StringItem> sourceStringItems = new HashMap<String, StringItem>();
        HashMap<String, Cell> sourceCells = new HashMap<String, Cell>();
        this.addEventToDocumentPart(sharedStrings.startDocument());
        this.addEventToDocumentPart(sharedStrings.startElement());
        this.flushDocumentPart();
        ListIterator<Cell> iterator = this.cells.iterator();
        while (iterator.hasNext()) {
            CellsPair cellsPair;
            StringItemsPair stringItemsPair;
            Cell cell = iterator.next();
            if (this.cells.worksheetStartsAt(iterator)) {
                this.endRowGroup();
                this.endWorksheetGroup();
                this.initRowGroupIdsFrom(cell.worksheetName());
                this.startWorksheetGroupWith(cell.worksheetName());
                this.startRowGroupWith(String.valueOf(cell.cellReferencesRange().first().row()));
                sourceAndTargetColumns = this.generalDocument.conditionalParameters().worksheetConfigurations().sourceAndTargetColumnsFor(cell.worksheetName());
            } else if (this.cells.rowStartsAt(iterator)) {
                sourceStringItems.clear();
                this.endRowGroup();
                if (!this.rowGroupIdsInitialised()) {
                    this.initRowGroupIdsFrom(cell.worksheetName());
                }
                this.startRowGroupWith(String.valueOf(cell.cellReferencesRange().first().row()));
            }
            if (CellType.INLINE_STRING != cell.type() && CellType.SHARED_STRING != cell.type() && !cell.value().empty()) {
                if (MetadataContext.ROW_AND_COLUMN == cell.metadataContext()) {
                    this.addContextType(cell.cellReferencesRange(), cell.value().asFormattedString());
                    continue;
                }
                if (MetadataContext.COLUMN != cell.metadataContext()) continue;
                this.addGroupContext(cell.cellReferencesRange(), cell.value().asFormattedString());
                continue;
            }
            StringItem stringItem = sharedStrings.stringItemFor(cell.value().asFormerInteger());
            String text = stringItem.text();
            if (!text.isBlank()) {
                if (MetadataContext.ROW_AND_COLUMN == cell.metadataContext()) {
                    this.addContextType(cell.cellReferencesRange(), text);
                } else if (MetadataContext.COLUMN == cell.metadataContext()) {
                    this.addGroupContext(cell.cellReferencesRange(), text);
                }
            }
            if (this.generalDocument.conditionalParameters().getExtractExcelSourceAndTargetColumnsJoined()) {
                String column = cell.cellReferencesRange().first().column();
                if (sourceAndTargetColumns.source().contains(column)) {
                    sourceStringItems.put(column, stringItem);
                    sourceCells.put(column, cell);
                    stringItemsPair = new StringItemsPair(stringItem);
                    cellsPair = new CellsPair(cell);
                } else if (sourceStringItems.containsKey(sourceAndTargetColumns.sourceFor(column))) {
                    stringItemsPair = new StringItemsPair((StringItem)sourceStringItems.remove(sourceAndTargetColumns.sourceFor(column)), stringItem);
                    cellsPair = new CellsPair((Cell)sourceCells.remove(sourceAndTargetColumns.sourceFor(column)), cell, this.generalDocument.conditionalParameters().getTreatExcelSourceColumnStylesForExclusion());
                } else {
                    stringItemsPair = new StringItemsPair(stringItem);
                    cellsPair = new CellsPair(cell);
                }
            } else {
                if (cell.value().empty()) continue;
                stringItemsPair = new StringItemsPair(stringItem);
                cellsPair = new CellsPair(cell);
            }
            this.formEventsFor(stringItemsPair, cellsPair);
        }
        this.endRowGroup();
        this.endWorksheetGroup();
        this.addEventToDocumentPart(sharedStrings.endElement());
        this.addEventToDocumentPart(sharedStrings.endDocument());
        this.flushDocumentPart();
        this.filterEvents.add(new Event(EventType.END_SUBDOCUMENT, new Ending(this.subDocumentId)));
        this.filterEventIterator = this.filterEvents.iterator();
    }

    private boolean rowGroupIdsInitialised() {
        return null != this.rowGroupIds;
    }

    private void initRowGroupIdsFrom(String worksheetName) {
        this.rowGroupIds = new IdGenerator(worksheetName.concat(ROWS), "sg");
    }

    private boolean worksheetGroupInitialised() {
        return null != this.worksheetStartGroup;
    }

    private void startWorksheetGroupWith(String name) {
        this.contextTypes = new ContextTypes(this.generalDocument.conditionalParameters().worksheetConfigurations().metadataColumnsFor(name));
        this.worksheetStartGroup = new StartGroup(EMPTY, this.worksheetGroupIds.createId());
        this.worksheetStartGroup.setName(name);
        this.filterEvents.add(new Event(EventType.START_GROUP, this.worksheetStartGroup));
    }

    private void endWorksheetGroup() {
        if (this.worksheetGroupInitialised()) {
            if (((Event)this.filterEvents.get(this.filterEvents.size() - 1)).isStartGroup()) {
                this.filterEvents.remove(this.filterEvents.size() - 1);
            } else {
                this.filterEvents.add(new Event(EventType.END_GROUP, new Ending(this.worksheetStartGroup.getId())));
            }
            this.worksheetStartGroup = null;
        }
    }

    boolean rowGroupInitialised() {
        return null != this.rowStartGroup;
    }

    private void startRowGroupWith(String name) {
        this.groupContexts = new LinkedList<XLIFFContextGroup.Context>();
        this.rowStartGroup = new StartGroup(EMPTY, this.rowGroupIds.createId());
        this.rowStartGroup.setName(String.valueOf(name));
        this.filterEvents.add(new Event(EventType.START_GROUP, this.rowStartGroup));
    }

    private void endRowGroup() {
        if (this.rowGroupInitialised()) {
            if (((Event)this.filterEvents.get(this.filterEvents.size() - 1)).isStartGroup()) {
                this.filterEvents.remove(this.filterEvents.size() - 1);
            } else {
                if (!this.groupContexts.isEmpty()) {
                    this.rowStartGroup.setAnnotation(new XLIFFContextGroup(this.encoderManager, ROW_METADATA, null, null, this.groupContexts));
                }
                this.filterEvents.add(new Event(EventType.END_GROUP, new Ending(this.rowStartGroup.getId())));
            }
            this.rowStartGroup = null;
        }
    }

    private void addContextType(CellReferencesRange cellReferencesRange, String string) {
        this.contextTypes.add(cellReferencesRange, string);
    }

    private void addGroupContext(CellReferencesRange cellReferencesRange, String string) {
        XLIFFContextGroup.Context context = new XLIFFContextGroup.Context(this.encoderManager, this.contextTypes.valueFor(cellReferencesRange), null, null);
        context.value(string);
        this.groupContexts.add(context);
    }

    private void addTextUnitEvents(List<ITextUnit> textUnits) {
        for (ITextUnit tu : textUnits) {
            this.filterEvents.add(new Event(EventType.TEXT_UNIT, tu));
        }
    }

    private void addSubfilteredEvents(List<ITextUnit> textUnits) {
        int subfilterIndex = 0;
        for (ITextUnit tu : textUnits) {
            ISubFilter sf = ISubFilter.create(this.subfilter, this.encoderManager.getEncoder(), ++subfilterIndex, tu.getId(), tu.getName());
            try {
                this.filterEvents.addAll(sf.getEvents(new RawDocument(tu.getSource().getFirstContent().getText(), this.generalDocument.sourceLocale(), this.generalDocument.targetLocale())));
                this.filterEvents.add(sf.createRefEvent(tu));
            }
            finally {
                if (sf == null) continue;
                sf.close();
            }
        }
    }

    private static class ContextTypes {
        private static final String DELIMITER = ";";
        private final Set<String> metadataColumns;
        private final Map<CellReferencesRange, String> values;

        private ContextTypes(Set<String> metadataColumns) {
            this(metadataColumns, new LinkedHashMap<CellReferencesRange, String>());
        }

        private ContextTypes(Set<String> metadataColumns, Map<CellReferencesRange, String> values) {
            this.metadataColumns = metadataColumns;
            this.values = values;
        }

        void add(CellReferencesRange cellReferencesRange, String value) {
            this.values.put(cellReferencesRange, value);
        }

        String valueFor(CellReferencesRange cellReferencesRange) {
            String value = this.values.entrySet().stream().filter(e -> ((CellReferencesRange)e.getKey()).anyMatch(Collections.emptySet(), cellReferencesRange.columns())).map(e -> (String)e.getValue()).collect(Collectors.joining(DELIMITER));
            return value.isEmpty() ? String.join((CharSequence)DELIMITER, cellReferencesRange.columnMatches(this.metadataColumns)) : value;
        }
    }
}

