/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public interface SourceAndTargetColumns {
    public Set<String> source();

    public Set<String> target();

    public String sourceFor(String var1);

    public String targetFor(String var1);

    public static class Default
    implements SourceAndTargetColumns {
        private final Map<String, String> targetBySourceColumns;
        private final Map<String, String> sourceByTargetColumns;

        Default(List<String> sourceColumns, List<String> targetColumns) {
            this.targetBySourceColumns = IntStream.range(0, Math.min(sourceColumns.size(), targetColumns.size())).boxed().collect(Collectors.toMap(sourceColumns::get, targetColumns::get));
            this.sourceByTargetColumns = IntStream.range(0, Math.min(sourceColumns.size(), targetColumns.size())).boxed().collect(Collectors.toMap(targetColumns::get, sourceColumns::get));
        }

        @Override
        public Set<String> source() {
            return this.targetBySourceColumns.keySet();
        }

        @Override
        public Set<String> target() {
            return this.sourceByTargetColumns.keySet();
        }

        @Override
        public String targetFor(String source) {
            return this.targetBySourceColumns.get(source);
        }

        @Override
        public String sourceFor(String target) {
            return this.sourceByTargetColumns.get(target);
        }
    }
}

