/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupSkeleton;

final class StartElementMapping {
    private final ConditionalParameters parameters;
    private final XMLEventFactory eventFactory;
    private final IdGenerator documentPartIds;
    private final String hiddenAttributeName;
    private final Set<String> hiddenAttributeTrueValues;

    StartElementMapping(ConditionalParameters parameters, XMLEventFactory eventFactory, IdGenerator documentPartIds, String hiddenAttributeName, Set<String> hiddenAttributeTrueValues) {
        this.parameters = parameters;
        this.eventFactory = eventFactory;
        this.documentPartIds = documentPartIds;
        this.hiddenAttributeName = hiddenAttributeName;
        this.hiddenAttributeTrueValues = hiddenAttributeTrueValues;
    }

    List<Event> eventsFor(StartElement startElement, List<String> attributeNames) {
        ArrayList<TextUnit> textUnits = new ArrayList<TextUnit>();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        String documentPartId = this.documentPartIds.createId();
        IdGenerator nestedIds = new IdGenerator(null, documentPartId.concat("-sub"));
        Iterator<Attribute> it = startElement.getAttributes();
        int updatedAttributes = 0;
        while (it.hasNext()) {
            Attribute a = it.next();
            if (this.hiddenAttributeName.equals(a.getName().getLocalPart()) && this.hiddenFor(a.getValue(), startElement.getName().getPrefix())) {
                updatedAttributes = 0;
                break;
            }
            if (!a.getValue().isBlank() && attributeNames.contains(a.getName().getLocalPart())) {
                TextFragment tf = new TextFragment(a.getValue());
                this.applyCodeFindingTo(tf);
                TextUnit tu2 = new TextUnit(nestedIds.createId(), new TextContainer(tf), true, "text/xml");
                tu2.setPreserveWhitespaces(true);
                tu2.setParentId(documentPartId);
                textUnits.add(tu2);
                attributes.add(this.eventFactory.createAttribute(a.getName(), TextFragment.makeRefMarker(String.valueOf(nestedIds.getSequence()))));
                ++updatedAttributes;
                continue;
            }
            attributes.add(a);
        }
        Markup.General markup = 0 < updatedAttributes ? new Markup.General(List.of(new MarkupComponent.Start(this.eventFactory, this.eventFactory.createStartElement(startElement.getName(), attributes.iterator(), startElement.getNamespaces())))) : new Markup.General(List.of(new MarkupComponent.Start(this.eventFactory, startElement)));
        DocumentPart documentPart = new DocumentPart(documentPartId, 0 < updatedAttributes, new MarkupSkeleton(markup));
        documentPart.setReferenceCount(updatedAttributes);
        ArrayList<Event> events = new ArrayList<Event>(1 + textUnits.size());
        events.add(new Event(EventType.DOCUMENT_PART, documentPart));
        if (0 < updatedAttributes) {
            textUnits.forEach(tu -> events.add(new Event(EventType.TEXT_UNIT, (IResource)tu)));
        }
        return events;
    }

    private boolean hiddenFor(String value, String prefix) {
        return this.hiddenAttributeTrueValues.contains(value) && "p".equals(prefix) && !this.parameters.getTranslatePowerpointHidden();
    }

    private void applyCodeFindingTo(TextFragment textFragment) {
        if (this.parameters.getUseCodeFinder()) {
            this.parameters.getCodeFinder().process(textFragment);
        }
    }
}

