/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.annotation.Note;
import net.sf.okapi.common.annotation.NoteAnnotation;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupSkeleton;

final class StringCacheMapping {
    private static final String V = "v";
    private final IdGenerator documentPartIds;
    private final IdGenerator textUnitIds;
    private final XMLEventReader eventReader;
    private final String source;
    private final StartElement startElement;

    StringCacheMapping(IdGenerator documentPartIds, IdGenerator textUnitIds, XMLEventReader eventReader, String source, StartElement startElement) {
        this.documentPartIds = documentPartIds;
        this.textUnitIds = textUnitIds;
        this.eventReader = eventReader;
        this.source = source;
        this.startElement = startElement;
    }

    List<Event> events() throws XMLStreamException {
        ArrayList<Event> events = new ArrayList<Event>();
        ArrayList<XMLEvent> markupEvents = new ArrayList<XMLEvent>();
        markupEvents.add(this.startElement);
        while (this.eventReader.hasNext()) {
            XMLEvent e = this.eventReader.nextEvent();
            if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                markupEvents.add(e);
                break;
            }
            if (e.isStartElement() && V.equals(e.asStartElement().getName().getLocalPart())) {
                markupEvents.add(e);
                XMLEvent event = this.eventReader.nextEvent();
                if (event.isCharacters() && !event.asCharacters().getData().isBlank()) {
                    events.add(this.documentPartEventFor(markupEvents));
                    markupEvents = new ArrayList();
                    events.add(this.textUnitEventFor(event.asCharacters().getData()));
                    continue;
                }
                markupEvents.add(event);
                continue;
            }
            markupEvents.add(e);
        }
        events.add(this.documentPartEventFor(markupEvents));
        return events;
    }

    private Event documentPartEventFor(List<XMLEvent> events) {
        return new Event(EventType.DOCUMENT_PART, new DocumentPart(this.documentPartIds.createId(), false, new MarkupSkeleton(new Markup.General(Collections.singletonList(new MarkupComponent.General(events))))));
    }

    private Event textUnitEventFor(String value) {
        TextUnit tu = new TextUnit(this.textUnitIds.createId());
        tu.setMimeType("text/xml");
        tu.setPreserveWhitespaces(true);
        tu.setSource(new TextContainer(new TextFragment(value)));
        GenericSkeleton gs = new GenericSkeleton();
        gs.addContentPlaceholder(tu);
        tu.setSkeleton(gs);
        NoteAnnotation na = new NoteAnnotation();
        na.add(new Note(String.format("Source: %s", this.source)));
        tu.setAnnotation(na);
        return new Event(EventType.TEXT_UNIT, tu);
    }
}

