/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.openxml.BlockSkeleton;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.CrossSheetCellReference;
import net.sf.okapi.filters.openxml.ExcelWorksheetTransUnitProperty;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.StringItem;
import net.sf.okapi.filters.openxml.StringItemsPair;
import net.sf.okapi.filters.openxml.StyledTextMapping;
import net.sf.okapi.filters.openxml.TargetColumnsMaxCharacters;
import net.sf.okapi.filters.openxml.Text;
import net.sf.okapi.filters.openxml.XMLEventSerializer;

class StringItemsMapping
extends StyledTextMapping {
    private static final String CHAR = "char";
    private final LocaleId targetLocale;
    private final TargetColumnsMaxCharacters targetColumnsMaxCharacters;
    private final StringItemsPair stringItemsPair;
    private final CrossSheetCellReference crossSheetCellReference;

    StringItemsMapping(LocaleId targetLocale, ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, IdGenerator idGenerator, StringItemsPair stringItemsPair, CrossSheetCellReference crossSheetCellReference) {
        super(conditionalParameters, eventFactory, idGenerator);
        this.targetLocale = targetLocale;
        this.targetColumnsMaxCharacters = conditionalParameters.worksheetConfigurations().targetColumnsMaxCharactersFor(crossSheetCellReference.worksheetName());
        this.stringItemsPair = stringItemsPair;
        this.crossSheetCellReference = crossSheetCellReference;
    }

    @Override
    public List<ITextUnit> textUnits() {
        return this.stringItemsPair.secondAvailable() ? this.mapJoined() : this.mapSingle();
    }

    private List<ITextUnit> mapJoined() {
        return this.stringItemsPair.secondStyled() ? this.mapStyled(this.stringItemsPair.first(), this.stringItemsPair.second()) : this.mapPlain(this.stringItemsPair.first(), this.stringItemsPair.second());
    }

    private List<ITextUnit> mapSingle() {
        return this.stringItemsPair.firstStyled() ? this.mapStyled(this.stringItemsPair.first()) : this.mapPlain(this.stringItemsPair.first());
    }

    private List<ITextUnit> mapStyled(StringItem firstItem, StringItem secondItem) {
        ArrayList<ITextUnit> textUnits = new ArrayList<ITextUnit>(1);
        if (2 < secondItem.getChunks().size()) {
            ITextUnit textUnit = this.initialTextUnit();
            if (!firstItem.isStyled()) {
                stf = new TextFragment(firstItem.text());
                this.applyCodeFindingToPlain(stf);
                textUnit.setSource(new TextContainer(stf));
            } else {
                stf = new TextFragment();
                this.addStyledTextAndSkeleton(stf, textUnit, firstItem, true);
                textUnit.setSource(new TextContainer(stf));
            }
            TextFragment tf = new TextFragment();
            this.addStyledTextAndSkeleton(tf, textUnit, secondItem, false);
            textUnit.setTarget(this.targetLocale, new TextContainer(tf));
            textUnits.add(textUnit);
        }
        return textUnits;
    }

    private List<ITextUnit> mapStyled(StringItem stringItem) {
        ArrayList<ITextUnit> textUnits = new ArrayList<ITextUnit>(1);
        if (2 < stringItem.getChunks().size()) {
            ITextUnit textUnit = this.initialTextUnit();
            TextFragment tf = new TextFragment();
            this.addStyledTextAndSkeleton(tf, textUnit, stringItem, false);
            if (!tf.isEmpty()) {
                textUnit.setSource(new TextContainer(tf));
                textUnits.add(textUnit);
            }
        }
        return textUnits;
    }

    private void addStyledTextAndSkeleton(TextFragment textFragment, ITextUnit textUnit, StringItem stringItem, boolean skeletonRestricted) {
        List<Chunk> chunks = stringItem.getChunks().subList(1, stringItem.getChunks().size() - 1);
        this.baseRunPropertiesPairWithDetectedRunFonts(chunks, stringItem.getRunName());
        boolean textAvailable = false;
        for (Chunk chunk : chunks) {
            if (chunk instanceof Run) {
                textAvailable |= this.addRun(textFragment, (Run)chunk);
                continue;
            }
            this.addIsolatedCode(textFragment, chunk);
        }
        this.popAllRunCodes(textFragment);
        if (!(skeletonRestricted || !textAvailable && this.leadingCodes.isEmpty())) {
            this.applyCodeFindingTo(textFragment);
            BlockSkeleton skel = new BlockSkeleton(stringItem.getBlock(), this.baseRunPropertiesPairWithDetectedRunFonts, this.leadingCodes, this.codes);
            skel.setParent(textUnit);
            textUnit.setSkeleton(skel);
        } else {
            this.applyCodeFindingToPlain(textFragment);
            this.leadingCodes.clear();
            this.codes.clear();
        }
    }

    private List<ITextUnit> mapPlain(StringItem firstItem, StringItem secondItem) {
        ITextUnit textUnit = this.initialTextUnit();
        TextFragment stf = new TextFragment(firstItem.text());
        this.applyCodeFindingToPlain(stf);
        textUnit.setSource(new TextContainer(stf));
        Text target = (Text)secondItem.getChunks().get(1);
        TextFragment ttf = new TextFragment(target.characters().getData());
        this.applyCodeFindingToPlain(ttf);
        textUnit.setTarget(this.targetLocale, new TextContainer(ttf));
        GenericSkeleton skel = this.genericSkeletonFor(textUnit, secondItem, target);
        skel.setParent(textUnit);
        textUnit.setSkeleton(skel);
        return Collections.singletonList(textUnit);
    }

    private List<ITextUnit> mapPlain(StringItem stringItem) {
        if (stringItem.getChunks().size() < 2) {
            return Collections.emptyList();
        }
        ITextUnit textUnit = this.initialTextUnit();
        Text text = (Text)stringItem.getChunks().get(1);
        TextFragment tf = new TextFragment(text.characters().getData());
        this.applyCodeFindingToPlain(tf);
        textUnit.setSource(new TextContainer(tf));
        GenericSkeleton skel = this.genericSkeletonFor(textUnit, stringItem, text);
        skel.setParent(textUnit);
        textUnit.setSkeleton(skel);
        return Collections.singletonList(textUnit);
    }

    private void applyCodeFindingToPlain(TextFragment textFragment) {
        if (this.conditionalParameters.getUseCodeFinder()) {
            this.conditionalParameters.getCodeFinder().process(textFragment);
        }
    }

    private ITextUnit initialTextUnit() {
        TextUnit textUnit = new TextUnit(this.ids.createId());
        textUnit.setMimeType("text/xml");
        textUnit.setPreserveWhitespaces(true);
        textUnit.setName(this.crossSheetCellReference.toString());
        this.addPropertiesTo(textUnit);
        return textUnit;
    }

    private void addPropertiesTo(ITextUnit textUnit) {
        textUnit.setProperty(new Property(ExcelWorksheetTransUnitProperty.CELL_REFERENCE.getKeyName(), this.crossSheetCellReference.cellReference().toString(), true));
        textUnit.setProperty(new Property(ExcelWorksheetTransUnitProperty.SHEET_NAME.getKeyName(), this.crossSheetCellReference.worksheetName(), true));
        String maxWidth = this.targetColumnsMaxCharacters.maxCharactersFor(this.crossSheetCellReference.cellReference().column());
        if (!maxWidth.isBlank()) {
            textUnit.setProperty(new Property("maxwidth", maxWidth));
            textUnit.setProperty(new Property("size-unit", CHAR));
        }
    }

    private GenericSkeleton genericSkeletonFor(ITextUnit textUnit, StringItem secondItem, Text text) {
        GenericSkeleton skeleton = new GenericSkeleton();
        XMLEventSerializer serializer = new XMLEventSerializer();
        skeleton.add(XMLEventSerializer.serialize(secondItem.getChunks().get(0), serializer));
        skeleton.add(XMLEventSerializer.serialize(text.startElement(), serializer));
        skeleton.addContentPlaceholder(textUnit);
        skeleton.add(XMLEventSerializer.serialize(text.endElement(), serializer));
        skeleton.add(XMLEventSerializer.serialize(secondItem.getChunks().get(2), serializer));
        return skeleton;
    }
}

