/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockPropertiesFactory;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.IndexedColors;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.Property;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.SystemColorValues;
import net.sf.okapi.filters.openxml.Theme;

interface StyleOptimisation {
    public List<Chunk> applyTo(List<Chunk> var1) throws XMLStreamException;

    public static final class Default
    implements StyleOptimisation {
        private final Bypass bypassOptimisation;
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final PresetColorValues presetColorValues;
        private final PresetColorValues highlightColorValues;
        private final SystemColorValues systemColorValues;
        private final IndexedColors indexedColors;
        private final Theme theme;
        private final QName blockPropertiesName;
        private final QName innerBlockPropertyName;
        private final List<QName> exclusions;
        private final StyleDefinitions styleDefinitions;

        Default(Bypass bypassOptimisation, ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, PresetColorValues presetColorValues, PresetColorValues highlightColorValues, SystemColorValues systemColorValues, IndexedColors indexedColors, Theme theme, QName blockPropertiesName, QName innerBlockPropertyName, List<QName> exclusions, StyleDefinitions styleDefinitions) {
            this.bypassOptimisation = bypassOptimisation;
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.presetColorValues = presetColorValues;
            this.highlightColorValues = highlightColorValues;
            this.systemColorValues = systemColorValues;
            this.indexedColors = indexedColors;
            this.theme = theme;
            this.blockPropertiesName = blockPropertiesName;
            this.innerBlockPropertyName = innerBlockPropertyName;
            this.exclusions = exclusions;
            this.styleDefinitions = styleDefinitions;
        }

        @Override
        public List<Chunk> applyTo(List<Chunk> chunks) throws XMLStreamException {
            if (chunks.size() <= 2) {
                return this.bypassOptimisation.applyTo(chunks);
            }
            List<Chunk> innerChunks = chunks.subList(1, chunks.size() - 1);
            if (this.innerChunksContainExclusions(innerChunks)) {
                return this.bypassOptimisation.applyTo(chunks);
            }
            List<Property> commonRunProperties = this.commonRunPropertiesOf(innerChunks);
            if (commonRunProperties.isEmpty()) {
                return this.bypassOptimisation.applyTo(chunks);
            }
            Block.Markup firstMarkup = (Block.Markup)chunks.get(0);
            ParagraphBlockProperties paragraphBlockProperties = this.paragraphBlockPropertiesOf(firstMarkup);
            this.styleDefinitions.place(paragraphBlockProperties.paragraphStyle(), paragraphBlockProperties.withoutParagraphStyle(), this.runProperties(commonRunProperties));
            paragraphBlockProperties.refine(this.innerBlockPropertyName, this.styleDefinitions.placedId(), commonRunProperties);
            firstMarkup.updateOrAddBlockProperties(paragraphBlockProperties);
            this.refineRuns(innerChunks, commonRunProperties);
            return chunks;
        }

        private boolean innerChunksContainExclusions(List<Chunk> chunks) {
            for (Chunk chunk : chunks) {
                if (chunk instanceof RunContainer && this.innerChunksContainExclusions(((RunContainer)chunk).getChunks())) {
                    return true;
                }
                if (!(chunk instanceof Run)) continue;
                List names = ((Run)chunk).propertiesPair().direct().properties().stream().map(p -> p.getName()).collect(Collectors.toList());
                names.retainAll(this.exclusions);
                if (names.isEmpty()) continue;
                return true;
            }
            return false;
        }

        private ParagraphBlockProperties paragraphBlockPropertiesOf(Block.Markup markup) {
            ParagraphBlockProperties blockProperties = markup.paragraphBlockProperties();
            if (null == blockProperties) {
                StartElement startElement = this.eventFactory.createStartElement(this.blockPropertiesName.getPrefix(), this.blockPropertiesName.getNamespaceURI(), this.blockPropertiesName.getLocalPart());
                EndElement endElement = this.eventFactory.createEndElement(this.blockPropertiesName.getPrefix(), this.blockPropertiesName.getNamespaceURI(), this.blockPropertiesName.getLocalPart());
                return (ParagraphBlockProperties)BlockPropertiesFactory.createBlockProperties(this.conditionalParameters, this.eventFactory, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, startElement, endElement, new ArrayList<Property>());
            }
            return blockProperties;
        }

        private RunProperties runProperties(List<Property> commonRunProperties) {
            return new RunProperties.Default(this.conditionalParameters, this.eventFactory, this.eventFactory.createStartElement(this.innerBlockPropertyName, null, null), this.eventFactory.createEndElement(this.innerBlockPropertyName, null), new ArrayList<Property>(commonRunProperties));
        }

        private List<Property> commonRunPropertiesOf(List<Chunk> chunks) {
            ArrayList<Property> commonRunProperties = new ArrayList<Property>();
            boolean added = false;
            for (Chunk chunk : chunks) {
                if (chunk instanceof RunContainer) {
                    List<Property> crp = this.commonRunPropertiesOf(((RunContainer)chunk).getChunks());
                    if (crp.isEmpty()) {
                        commonRunProperties.clear();
                        break;
                    }
                    if (!added) {
                        commonRunProperties.addAll(crp);
                        added = true;
                    } else {
                        commonRunProperties.retainAll(crp);
                    }
                }
                if (!(chunk instanceof Run)) continue;
                Run run = (Run)chunk;
                if (run.propertiesPair().direct().properties().isEmpty()) {
                    commonRunProperties.clear();
                    break;
                }
                if (!added) {
                    commonRunProperties.addAll(run.propertiesPair().direct().properties());
                    added = true;
                    continue;
                }
                commonRunProperties.retainAll(run.propertiesPair().direct().properties());
            }
            return commonRunProperties;
        }

        private void refineRuns(List<Chunk> chunks, List<Property> commonRunProperties) {
            for (Chunk chunk : chunks) {
                if (chunk instanceof RunContainer) {
                    this.refineRuns(((RunContainer)chunk).getChunks(), commonRunProperties);
                }
                if (!(chunk instanceof Run)) continue;
                ((Run)chunk).refineRunProperties(commonRunProperties);
            }
        }
    }

    public static final class Bypass
    implements StyleOptimisation {
        @Override
        public List<Chunk> applyTo(List<Chunk> chunks) {
            return chunks;
        }
    }
}

