/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.EndSubfilter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.StartSubfilter;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockSkeleton;
import net.sf.okapi.filters.openxml.BlockTextUnitWriter;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.DispersedTranslations;
import net.sf.okapi.filters.openxml.IndexedColors;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupClarification;
import net.sf.okapi.filters.openxml.MarkupClarificationConfiguration;
import net.sf.okapi.filters.openxml.MarkupSkeleton;
import net.sf.okapi.filters.openxml.Nameable;
import net.sf.okapi.filters.openxml.OpenXMLFilter;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.SystemColorValues;
import net.sf.okapi.filters.openxml.TextUnitProperties;
import net.sf.okapi.filters.openxml.Theme;
import net.sf.okapi.filters.openxml.XMLEventSerializer;

class StyledTextSkeletonWriter
implements ISkeletonWriter {
    static final String XML_VERSION = "1.0";
    static final String XML_ENCODING = OpenXMLFilter.ENCODING.name();
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"" + XML_ENCODING + "\"?>";
    private static final String EMPTY_STRING = "";
    private final ConditionalParameters parameters;
    private final XMLEventFactory eventFactory;
    private final PresetColorValues presetColorValues;
    private final PresetColorValues highlightColorValues;
    private final SystemColorValues systemColorValues;
    private final IndexedColors indexedColors;
    private final Theme theme;
    private final LocaleId sourceLocale;
    private LocaleId targetLocale;
    private final DispersedTranslations dispersedTranslations;
    private final FontMappings applicableFontMappings;
    private final StyleDefinitions styleDefinitions;
    private final GenericSkeletonWriter genericSkeletonWriter;
    private Map<String, String> processedReferents = new HashMap<String, String>();
    private Deque<Referring> referrings = new ArrayDeque<Referring>();

    StyledTextSkeletonWriter(ConditionalParameters parameters, XMLEventFactory eventFactory, PresetColorValues presetColorValues, PresetColorValues highlightColorValues, SystemColorValues systemColorValues, IndexedColors indexedColors, Theme theme, LocaleId sourceLocale, LocaleId targetLocale, DispersedTranslations dispersedTranslations, FontMappings applicableFontMappings, StyleDefinitions styleDefinitions, GenericSkeletonWriter genericSkeletonWriter) {
        this.parameters = parameters;
        this.eventFactory = eventFactory;
        this.presetColorValues = presetColorValues;
        this.highlightColorValues = highlightColorValues;
        this.systemColorValues = systemColorValues;
        this.indexedColors = indexedColors;
        this.theme = theme;
        this.sourceLocale = sourceLocale;
        this.targetLocale = targetLocale;
        this.dispersedTranslations = dispersedTranslations;
        this.applicableFontMappings = applicableFontMappings;
        this.styleDefinitions = styleDefinitions;
        this.genericSkeletonWriter = genericSkeletonWriter;
    }

    @Override
    public void close() {
    }

    @Override
    public String processStartDocument(LocaleId outputLocale, String outputEncoding, EncoderManager encoderManager, StartDocument resource) {
        this.targetLocale = outputLocale;
        this.genericSkeletonWriter.setOutputLoc(outputLocale);
        return XML_HEADER;
    }

    @Override
    public String processEndDocument(Ending resource) {
        return EMPTY_STRING;
    }

    @Override
    public String processStartSubDocument(StartSubDocument resource) {
        return XML_HEADER;
    }

    @Override
    public String processEndSubDocument(Ending resource) {
        return EMPTY_STRING;
    }

    @Override
    public String processStartGroup(StartGroup resource) {
        return EMPTY_STRING;
    }

    @Override
    public String processEndGroup(Ending resource) {
        return EMPTY_STRING;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String processTextUnit(ITextUnit tu) {
        String serialized;
        if (!EMPTY_STRING.equals(this.parameters.getSubfilter()) && null == tu.getSkeleton() || tu.getSkeleton() instanceof GenericSkeleton) {
            return this.genericSkeletonWriter.processTextUnit(tu);
        }
        TextContainer target = this.getTargetForOutput(tu);
        if (this.parameters.getAllowEmptyTargets() && target == null) {
            return EMPTY_STRING;
        }
        XMLEventSerializer writing = new XMLEventSerializer();
        if (tu.getSkeleton() != null) {
            if (!(tu.getSkeleton() instanceof BlockSkeleton)) throw new IllegalArgumentException("TextUnit " + tu.getId() + " has no associated block content");
            BlockSkeleton skel = (BlockSkeleton)tu.getSkeleton();
            Block block = skel.block();
            List<Chunk> chunks = block.getChunks();
            chunks.forEach(c -> c.apply(this.applicableFontMappings));
            Nameable nameableMarkupComponent = ((Markup)((Object)chunks.get(0))).nameableComponent();
            MarkupClarificationConfiguration mcc = new MarkupClarificationConfiguration(this.parameters, this.eventFactory, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, this.sourceLocale, this.targetLocale, this.dispersedTranslations);
            mcc.prepareFor(nameableMarkupComponent);
            new MarkupClarification(mcc).performFor((Markup)((Object)chunks.get(0)));
            writing.addAll((Collection<XMLEvent>)chunks.get(0).getEvents());
            new BlockTextUnitWriter(this.parameters, this.eventFactory, this.targetLocale, skel.block().getRunName(), skel.block().getTextName(), skel.baseRunPropertiesPairWithDetectedRunFonts(), skel.leadingCodes(), skel.codes(), writing, mcc.runPropertiesClarification()).write(target);
            writing.addAll((Collection<XMLEvent>)chunks.get(chunks.size() - 1).getEvents());
            serialized = writing.toString();
            return this.processReferences(tu, serialized);
        } else {
            serialized = writing.getAttributeEncoder().encode(target.toString(), EncoderContext.INLINE);
        }
        return this.processReferences(tu, serialized);
    }

    private String processReferences(ITextUnit tu, String serialized) {
        String output = EMPTY_STRING;
        if (tu.isReferent()) {
            if (TextUnitProperties.integer(tu, "references") == 0) {
                this.processedReferents.put(tu.getId(), serialized);
                ++this.referrings.peek().foundReferents;
                while (!this.referrings.isEmpty() && this.referrings.peek().isLastFoundReferent()) {
                    Referring r = this.referrings.pop();
                    String resolved = this.resolveReferences(r.id, r.serialized);
                    if (this.processedReferents.containsKey(r.id)) {
                        this.processedReferents.put(r.id, resolved);
                        continue;
                    }
                    output = resolved;
                    break;
                }
            } else {
                this.processedReferents.put(tu.getId(), serialized);
                ++this.referrings.peek().foundReferents;
                this.referrings.push(new Referring(tu.getId(), serialized, TextUnitProperties.integer(tu, "references")));
            }
        } else if (TextUnitProperties.integer(tu, "references") == 0) {
            output = serialized;
        } else {
            this.referrings.push(new Referring(tu.getId(), serialized, TextUnitProperties.integer(tu, "references")));
        }
        return output;
    }

    private String resolveReferences(String id, String original) {
        StringBuilder sb = new StringBuilder(original);
        Object[] markerInfo = TextFragment.getRefMarker(sb);
        while (markerInfo != null) {
            String processedReferent = this.processedReferents.get(this.referenceIdOf(id, (String)markerInfo[0]));
            sb.replace((Integer)markerInfo[1], (Integer)markerInfo[2], processedReferent);
            markerInfo = TextFragment.getRefMarker(sb);
        }
        return sb.toString();
    }

    private String referenceIdOf(String parentId, String id) {
        return parentId.concat("-sub").concat(id);
    }

    private TextContainer getTargetForOutput(ITextUnit tu) {
        if (!this.parameters.getAllowEmptyTargets() && this.targetLocale == null) {
            return tu.getSource();
        }
        TextContainer trgCont = tu.getTarget(this.targetLocale);
        if (!this.parameters.getAllowEmptyTargets() && (trgCont == null || trgCont.isEmpty())) {
            return tu.getSource();
        }
        return trgCont;
    }

    @Override
    public String processDocumentPart(DocumentPart documentPart) {
        String output;
        if (documentPart.getSkeleton() instanceof GenericSkeleton) {
            return this.genericSkeletonWriter.processDocumentPart(documentPart);
        }
        MarkupSkeleton markupSkeleton = (MarkupSkeleton)documentPart.getSkeleton();
        Markup markup = markupSkeleton.getMarkup();
        markup.apply(this.applicableFontMappings);
        Nameable nameableMarkupComponent = markup.nameableComponent();
        if (null != nameableMarkupComponent) {
            MarkupClarificationConfiguration mcc = new MarkupClarificationConfiguration(this.parameters, this.eventFactory, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, this.sourceLocale, this.targetLocale, this.dispersedTranslations);
            mcc.prepareFor(nameableMarkupComponent);
            new MarkupClarification(mcc).performFor(markup);
        }
        String serialized = XMLEventSerializer.serialize(markup);
        if (documentPart.isReferent()) {
            this.referrings.push(new Referring(documentPart.getId(), serialized, documentPart.getReferenceCount()));
            output = EMPTY_STRING;
        } else {
            output = serialized;
        }
        return output;
    }

    @Override
    public String processStartSubfilter(StartSubfilter resource) {
        return this.genericSkeletonWriter.processStartSubfilter(resource);
    }

    @Override
    public String processEndSubfilter(EndSubfilter resource) {
        return this.genericSkeletonWriter.processEndSubfilter(resource);
    }

    private static final class Referring {
        private final String id;
        private final String serialized;
        private final int references;
        private int foundReferents;

        Referring(String id, String serialized, int references) {
            this.id = id;
            this.serialized = serialized;
            this.references = references;
        }

        boolean isLastFoundReferent() {
            return this.references == this.foundReferents;
        }
    }
}

