/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.CellReferencesRange;
import net.sf.okapi.filters.openxml.Formula;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

interface Table {
    public static final String COLUMN = "tableColumn";

    public String name();

    public CellReferencesRange cellReferencesRange();

    public Set<String> columnNames();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static final class Default
    implements Table {
        private static final String TABLE = "table";
        private static final QName NAME = new QName("name");
        private static final QName REF = new QName("ref");
        private final XMLEventFactory eventFactory;
        private final String worksheetName;
        private final Set<String> columnNames;
        private MarkupBuilder markupBuilder;
        private String name;
        private CellReferencesRange cellReferencesRange;

        Default(XMLEventFactory eventFactory, String worksheetName) {
            this(eventFactory, worksheetName, new HashSet<String>());
        }

        Default(XMLEventFactory eventFactory, String worksheetName, Set<String> columnNames) {
            this.eventFactory = eventFactory;
            this.worksheetName = worksheetName;
            this.columnNames = columnNames;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public CellReferencesRange cellReferencesRange() {
            return this.cellReferencesRange;
        }

        @Override
        public Set<String> columnNames() {
            return this.columnNames;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.markupBuilder = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>()));
            while (reader.hasNext()) {
                EndElement ee;
                XMLEvent e = reader.nextEvent();
                if (e.isStartElement()) {
                    StartElement se = e.asStartElement();
                    if (TABLE.equals(se.getName().getLocalPart()) && "".equals(se.getName().getPrefix())) {
                        this.cellReferencesRange = new CellReferencesRange(XMLEventHelpers.getAttributeValue(se, REF));
                        this.name = XMLEventHelpers.getAttributeValue(se, NAME);
                    } else {
                        if (Table.COLUMN.equals(se.getName().getLocalPart())) {
                            this.columnNames.add(XMLEventHelpers.getAttributeValue(se, NAME));
                            this.markupBuilder.add(new MarkupComponent.Start(this.eventFactory, se, new MarkupComponent.Context.Default(this.name)));
                            continue;
                        }
                        if ("calculatedColumnFormula".equals(se.getName().getLocalPart()) || "totalsRowFormula".equals(se.getName().getLocalPart())) {
                            Formula.Default formula = new Formula.Default(se, new MarkupComponent.Context.Default(this.worksheetName));
                            formula.readWith(reader);
                            this.markupBuilder.add(formula);
                            continue;
                        }
                    }
                } else if (e.isEndElement() && Table.COLUMN.equals((ee = e.asEndElement()).getName().getLocalPart())) {
                    this.markupBuilder.add(new MarkupComponent.End(ee));
                    continue;
                }
                this.markupBuilder.add(e);
            }
        }

        @Override
        public Markup asMarkup() {
            return this.markupBuilder.build();
        }
    }
}

