/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public interface TargetColumnsMaxCharacters {
    public String maxCharactersFor(String var1);

    public static class Default
    implements TargetColumnsMaxCharacters {
        private static final String EMPTY = "";
        private final Map<String, String> maxCharactersByTargetColumns;

        Default(List<String> targetColumns, List<String> maxCharacters) {
            this.maxCharactersByTargetColumns = IntStream.range(0, Math.min(targetColumns.size(), maxCharacters.size())).boxed().collect(Collectors.toMap(targetColumns::get, maxCharacters::get));
        }

        @Override
        public String maxCharactersFor(String target) {
            return this.maxCharactersByTargetColumns.getOrDefault(target, EMPTY);
        }
    }
}

