/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.XMLEventsReader;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.Color;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.IndexedColors;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentParser;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesParser;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.RunSkippableElements;
import net.sf.okapi.filters.openxml.SkippableElement;
import net.sf.okapi.filters.openxml.SkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.StyleDefinition;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleType;
import net.sf.okapi.filters.openxml.SystemColorValues;
import net.sf.okapi.filters.openxml.Theme;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

interface WordStyleDefinition
extends StyleDefinition {
    public static final String UNEXPECTED_STRUCTURE = "Unexpected structure : ";
    public static final String EMPTY = "";
    public static final String RPR = "rPr";

    public StyleType type();

    public String id();

    public boolean isDefault();

    public String parentId();

    public void parentId(String var1);

    public String linkedId();

    public void paragraphProperties(ParagraphBlockProperties var1);

    public void runProperties(RunProperties var1);

    public static final class General
    implements WordStyleDefinition {
        static final String TYPE = "type";
        static final String STYLE_ID = "styleId";
        static final String DEFAULT = "default";
        private static final String NAME = "name";
        private static final String BASED_ON = "basedOn";
        private static final String LINK = "link";
        private static final String VAL = "val";
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final PresetColorValues presetColorValues;
        private final PresetColorValues highlightColorValues;
        private final SystemColorValues systemColorValues;
        private final IndexedColors indexedColors;
        private final Theme theme;
        private final StartElement startElement;
        private final StrippableAttributes strippableAttributes;
        private final SkippableElements skippableElements;
        private StyleType type;
        private String id;
        private boolean shouldBeDefault;
        private String parentId;
        private String linkedId;
        private List<XMLEvent> eventsBeforeParagraphProperties;
        private ParagraphBlockProperties paragraphProperties;
        private List<XMLEvent> eventsBeforeRunProperties;
        private RunProperties runProperties;
        private List<XMLEvent> eventsBeforeTableProperties;
        private BlockProperties tableProperties;
        private List<XMLEvent> eventsBeforeEndElement;
        private EndElement endElement;
        private boolean attributesRead;

        General(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, PresetColorValues presetColorValues, PresetColorValues highlightColorValues, SystemColorValues systemColorValues, IndexedColors indexedColors, Theme theme, StartElement startElement) {
            this(conditionalParameters, eventFactory, presetColorValues, highlightColorValues, systemColorValues, indexedColors, theme, startElement, new StrippableAttributes.DrawingRunProperties(conditionalParameters, eventFactory), new SkippableElements.Property(new SkippableElements.Default(SkippableElement.BlockProperty.BLOCK_PROPERTY_BIDI_VISUAL, SkippableElement.RunProperty.RUN_PROPERTY_LANGUAGE), conditionalParameters));
        }

        General(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, PresetColorValues presetColorValues, PresetColorValues highlightColorValues, SystemColorValues systemColorValues, IndexedColors indexedColors, Theme theme, StartElement startElement, StrippableAttributes strippableAttributes, SkippableElements skippableElements) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.presetColorValues = presetColorValues;
            this.highlightColorValues = highlightColorValues;
            this.systemColorValues = systemColorValues;
            this.indexedColors = indexedColors;
            this.theme = theme;
            this.startElement = startElement;
            this.strippableAttributes = strippableAttributes;
            this.skippableElements = skippableElements;
        }

        @Override
        public StyleType type() {
            if (!this.attributesRead) {
                this.readAttributes();
            }
            return this.type;
        }

        @Override
        public String id() {
            if (!this.attributesRead) {
                this.readAttributes();
            }
            return this.id;
        }

        @Override
        public boolean isDefault() {
            if (!this.attributesRead) {
                this.readAttributes();
            }
            return this.shouldBeDefault;
        }

        @Override
        public String parentId() {
            return this.parentId;
        }

        @Override
        public void parentId(String parentId) {
            this.parentId = parentId;
        }

        @Override
        public String linkedId() {
            return this.linkedId;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.readAttributes();
            this.readElements(reader);
        }

        private void readAttributes() {
            this.readType();
            this.readStyleId();
            this.readDefault();
            this.attributesRead = true;
        }

        private void readType() {
            this.type = StyleType.fromString(XMLEventHelpers.getAttributeValue(this.startElement, new QName(this.startElement.getName().getNamespaceURI(), TYPE, this.startElement.getName().getPrefix())));
            if (this.type == StyleType.UNSUPPORTED) {
                this.type = StyleType.PARAGRAPH;
            }
        }

        private void readStyleId() {
            this.id = XMLEventHelpers.getAttributeValue(this.startElement, new QName(this.startElement.getName().getNamespaceURI(), STYLE_ID, this.startElement.getName().getPrefix()));
        }

        private void readDefault() {
            this.shouldBeDefault = XMLEventHelpers.getBooleanAttributeValue(this.startElement, new QName(this.startElement.getName().getNamespaceURI(), DEFAULT, this.startElement.getName().getPrefix()), XMLEventHelpers.DEFAULT_BOOLEAN_ATTRIBUTE_FALSE_VALUE);
        }

        private void readElements(XMLEventReader reader) throws XMLStreamException {
            List<XMLEvent> currentEvents = this.eventsBeforeParagraphProperties = new LinkedList<XMLEvent>();
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                    if (null == this.paragraphProperties) {
                        this.paragraphProperties = new ParagraphBlockProperties.Word(new BlockProperties.Default(this.eventFactory, this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), "pPr"), this.conditionalParameters, this.eventFactory, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, new StrippableAttributes.Default(this.eventFactory));
                    }
                    if (null == this.runProperties || 0 == this.runProperties.count()) {
                        this.runProperties = new RunProperties.Default(this.conditionalParameters, this.eventFactory, this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), WordStyleDefinition.RPR);
                    }
                    if (StyleType.TABLE == this.type && null == this.tableProperties) {
                        this.tableProperties = new BlockProperties.Default(this.eventFactory, this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), "tblPr");
                    }
                    this.endElement = event.asEndElement();
                    return;
                }
                if (event.isStartElement()) {
                    String localPart = event.asStartElement().getName().getLocalPart();
                    if (BASED_ON.equals(localPart)) {
                        this.parentId = XMLEventHelpers.getAttributeValue(event.asStartElement(), XMLEventHelpers.WPML_VAL);
                    } else if (LINK.equals(localPart)) {
                        this.linkedId = XMLEventHelpers.getAttributeValue(event.asStartElement(), XMLEventHelpers.WPML_VAL);
                    } else {
                        if ("pPr".equals(localPart)) {
                            this.paragraphProperties = this.paragraphProperties(event.asStartElement(), reader);
                            this.eventsBeforeRunProperties = new LinkedList<XMLEvent>();
                            currentEvents = this.eventsBeforeRunProperties;
                            continue;
                        }
                        if (WordStyleDefinition.RPR.equals(localPart)) {
                            this.runProperties = this.runProperties(event.asStartElement(), reader);
                            this.eventsBeforeTableProperties = new LinkedList<XMLEvent>();
                            currentEvents = this.eventsBeforeTableProperties;
                            continue;
                        }
                        if ("tblPr".equals(localPart)) {
                            this.tableProperties = this.blockProperties(event.asStartElement(), reader);
                            this.eventsBeforeEndElement = new LinkedList<XMLEvent>();
                            currentEvents = this.eventsBeforeEndElement;
                            continue;
                        }
                        if ("trPr".equals(localPart) || "tcPr".equals(localPart)) {
                            if (null == this.eventsBeforeEndElement) {
                                this.eventsBeforeEndElement = new LinkedList<XMLEvent>();
                                currentEvents = this.eventsBeforeEndElement;
                            }
                        } else if ("tblStylePr".equals(localPart)) {
                            if (null == this.eventsBeforeEndElement) {
                                this.eventsBeforeEndElement = new LinkedList<XMLEvent>();
                                currentEvents = this.eventsBeforeEndElement;
                            }
                            currentEvents.add(event);
                            currentEvents.addAll(this.eventsToEndElement(reader, "tblStylePr"));
                            continue;
                        }
                    }
                }
                currentEvents.add(event);
            }
            throw new IllegalStateException(WordStyleDefinition.UNEXPECTED_STRUCTURE.concat(this.startElement.getName().getLocalPart()).concat(" end element is absent"));
        }

        private ParagraphBlockProperties paragraphProperties(StartElement startElement, XMLEventReader reader) throws XMLStreamException {
            return new MarkupComponentParser().parseParagraphBlockProperties(new StartElementContext(startElement, reader, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, this.eventFactory, this.conditionalParameters), this.strippableAttributes, this.skippableElements);
        }

        private BlockProperties blockProperties(StartElement startElement, XMLEventReader reader) throws XMLStreamException {
            return new MarkupComponentParser().parseBlockProperties(new StartElementContext(startElement, reader, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, this.eventFactory, this.conditionalParameters), this.strippableAttributes, this.skippableElements);
        }

        private RunProperties runProperties(StartElement startElement, XMLEventReader reader) throws XMLStreamException {
            StartElementContext startElementContext = new StartElementContext(startElement, reader, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, this.eventFactory, this.conditionalParameters);
            return new RunPropertiesParser(startElementContext, new RunSkippableElements(startElementContext)).parse();
        }

        private List<XMLEvent> eventsToEndElement(XMLEventReader reader, String name) throws XMLStreamException {
            LinkedList<XMLEvent> events = new LinkedList<XMLEvent>();
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                events.add(event);
                if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(name)) continue;
                return events;
            }
            throw new IllegalStateException(WordStyleDefinition.UNEXPECTED_STRUCTURE.concat(name).concat(" end element is absent"));
        }

        @Override
        public ParagraphBlockProperties paragraphProperties() {
            if (null == this.paragraphProperties) {
                this.paragraphProperties = new ParagraphBlockProperties.Word(new BlockProperties.Default(this.eventFactory, this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), "pPr"), this.conditionalParameters, this.eventFactory, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, new StrippableAttributes.Default(this.eventFactory));
            }
            return this.paragraphProperties;
        }

        @Override
        public void paragraphProperties(ParagraphBlockProperties paragraphBlockProperties) {
            this.paragraphProperties = paragraphBlockProperties;
        }

        @Override
        public RunProperties runProperties() {
            return this.runProperties;
        }

        @Override
        public void runProperties(RunProperties runProperties) {
            this.runProperties = runProperties;
        }

        @Override
        public Markup asMarkup() {
            Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
            markup.addComponent(new MarkupComponent.Start(this.eventFactory, this.startElement));
            if (null == this.eventsBeforeParagraphProperties) {
                this.readElements();
            }
            markup.addComponent(new MarkupComponent.General(this.eventsBeforeParagraphProperties));
            if (null != this.paragraphProperties) {
                markup.addComponent(this.paragraphProperties);
            }
            if (null != this.eventsBeforeRunProperties) {
                markup.addComponent(new MarkupComponent.General(this.eventsBeforeRunProperties));
            }
            markup.addComponent(this.runProperties);
            if (null != this.eventsBeforeTableProperties) {
                markup.addComponent(new MarkupComponent.General(this.eventsBeforeTableProperties));
            }
            if (null != this.tableProperties) {
                markup.addComponent(this.tableProperties);
            }
            if (null != this.eventsBeforeEndElement) {
                markup.addComponent(new MarkupComponent.General(this.eventsBeforeEndElement));
            }
            markup.addComponent(new MarkupComponent.End(this.endElement));
            return markup;
        }

        private void readElements() {
            this.eventsBeforeParagraphProperties = new LinkedList<XMLEvent>();
            this.readNameElement();
            this.readBasedOnElement();
            this.readEndElement();
        }

        private void readNameElement() {
            this.readElementWith(NAME, this.id());
        }

        private void readBasedOnElement() {
            this.readElementWith(BASED_ON, this.parentId);
        }

        private void readElementWith(String name, String value) {
            if (null == value) {
                return;
            }
            List<Attribute> attributes = Collections.singletonList(this.eventFactory.createAttribute(new QName(this.startElement.getName().getNamespaceURI(), VAL, this.startElement.getName().getPrefix()), value));
            this.eventsBeforeParagraphProperties.add(this.eventFactory.createStartElement(new QName(this.startElement.getName().getNamespaceURI(), name, this.startElement.getName().getPrefix()), attributes.iterator(), null));
            this.eventsBeforeParagraphProperties.add(this.eventFactory.createEndElement(new QName(this.startElement.getName().getNamespaceURI(), name, this.startElement.getName().getPrefix()), null));
        }

        private void readEndElement() {
            this.endElement = this.eventFactory.createEndElement(this.startElement.getName(), null);
        }
    }

    public static final class Latent
    implements WordStyleDefinition {
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private final List<XMLEvent> innerEvents;
        private EndElement endElement;

        Latent(XMLEventFactory eventFactory, String prefix, String namespaceUri, String name) {
            this(eventFactory, eventFactory.createStartElement(prefix, namespaceUri, name));
        }

        Latent(XMLEventFactory eventFactory, StartElement startElement) {
            this(eventFactory, startElement, new LinkedList<XMLEvent>());
        }

        Latent(XMLEventFactory eventFactory, StartElement startElement, List<XMLEvent> innerEvents) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
            this.innerEvents = innerEvents;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.innerEvents.clear();
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = event.asEndElement();
                    return;
                }
                this.innerEvents.add(event);
            }
            throw new IllegalStateException(WordStyleDefinition.UNEXPECTED_STRUCTURE.concat(this.startElement.getName().getLocalPart()).concat(" end element is absent"));
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public StyleType type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDefault() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String parentId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void parentId(String parentId) {
        }

        @Override
        public String linkedId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ParagraphBlockProperties paragraphProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void paragraphProperties(ParagraphBlockProperties paragraphBlockProperties) {
        }

        @Override
        public RunProperties runProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void runProperties(RunProperties runProperties) {
        }

        @Override
        public Markup asMarkup() {
            if (this.innerEvents.isEmpty()) {
                return new Markup.Empty();
            }
            if (null == this.endElement) {
                this.endElement = this.eventFactory.createEndElement(this.startElement.getName(), this.startElement.getNamespaces());
            }
            Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
            markup.addComponent(new MarkupComponent.Start(this.eventFactory, this.startElement));
            markup.addComponent(new MarkupComponent.General(this.innerEvents));
            markup.addComponent(new MarkupComponent.End(this.endElement));
            return markup;
        }
    }

    public static final class DocumentDefaults
    implements WordStyleDefinition {
        static final String PPR_DEFAULT = "pPrDefault";
        static final String RPR_DEFAULT = "rPrDefault";
        private static final String PPR = "pPr";
        private static final String EXPLICIT_DEFAULT_HIGHLIGHT_PROPERTY_VALUE = "none";
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final PresetColorValues presetColorValues;
        private final PresetColorValues highlightColorValues;
        private final SystemColorValues systemColorValues;
        private final IndexedColors indexedColors;
        private final Theme theme;
        private final StartElement startElement;
        private final String explicitDefaultColorPropertyValue;
        private StartElement paragraphPropertiesDefaultStartElement;
        private ParagraphBlockProperties paragraphProperties;
        private EndElement paragraphPropertiesDefaultEndElement;
        private StartElement runPropertiesDefaultStartElement;
        private RunProperties runProperties;
        private EndElement runPropertiesDefaultEndElement;
        private EndElement endElement;

        DocumentDefaults(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, PresetColorValues presetColorValues, PresetColorValues highlightColorValues, SystemColorValues systemColorValues, IndexedColors indexedColors, Theme theme, String prefix, String namespaceUri, String name) {
            this(conditionalParameters, eventFactory, presetColorValues, highlightColorValues, systemColorValues, indexedColors, theme, eventFactory.createStartElement(prefix, namespaceUri, name));
        }

        DocumentDefaults(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, PresetColorValues presetColorValues, PresetColorValues highlightColorValues, SystemColorValues systemColorValues, IndexedColors indexedColors, Theme theme, StartElement startElement) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.presetColorValues = presetColorValues;
            this.highlightColorValues = highlightColorValues;
            this.systemColorValues = systemColorValues;
            this.indexedColors = indexedColors;
            this.theme = theme;
            this.startElement = startElement;
            this.explicitDefaultColorPropertyValue = systemColorValues.valueFor("windowText").asRgb();
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isEndElement()) {
                    if (event.asEndElement().getName().equals(this.startElement.getName())) {
                        this.endElement = event.asEndElement();
                        this.addExplicitDefaults();
                        return;
                    }
                    if (event.asEndElement().getName().getLocalPart().equals(PPR_DEFAULT)) {
                        this.paragraphPropertiesDefaultEndElement = event.asEndElement();
                        continue;
                    }
                    if (!event.asEndElement().getName().getLocalPart().equals(RPR_DEFAULT)) continue;
                    this.runPropertiesDefaultEndElement = event.asEndElement();
                    continue;
                }
                if (!event.isStartElement()) continue;
                switch (event.asStartElement().getName().getLocalPart()) {
                    case "pPrDefault": {
                        this.paragraphPropertiesDefaultStartElement = event.asStartElement();
                        break;
                    }
                    case "rPrDefault": {
                        this.runPropertiesDefaultStartElement = event.asStartElement();
                        break;
                    }
                    case "pPr": {
                        this.paragraphProperties = this.paragraphProperties(reader, event);
                        break;
                    }
                    case "rPr": {
                        this.runProperties = this.runProperties(reader, event);
                    }
                }
            }
            throw new IllegalStateException(WordStyleDefinition.UNEXPECTED_STRUCTURE.concat(this.startElement.getName().getLocalPart()).concat(" end element is absent"));
        }

        private void addExplicitDefaults() throws XMLStreamException {
            if (!this.runProperties().contains("shd") && !this.runProperties().contains("highlight")) {
                List<Attribute> attributes = List.of(this.eventFactory.createAttribute(new QName(this.startElement.getName().getNamespaceURI(), "val", this.startElement.getName().getPrefix()), EXPLICIT_DEFAULT_HIGHLIGHT_PROPERTY_VALUE));
                this.runProperties().add(new RunProperty.HighlightRunProperty(this.highlightColorValues, List.of(this.eventFactory.createStartElement(this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), "highlight", attributes.iterator(), null), this.eventFactory.createEndElement(this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), "highlight"))));
            }
            if (!this.runProperties().contains("color")) {
                QName valueName = new QName(this.startElement.getName().getNamespaceURI(), "val", this.startElement.getName().getPrefix());
                List<Attribute> attributes = List.of(this.eventFactory.createAttribute(valueName, this.explicitDefaultColorPropertyValue));
                StartElement se = this.eventFactory.createStartElement(this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), "color", attributes.iterator(), null);
                List<XMLEvent> events = List.of(this.eventFactory.createEndElement(this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), "color"));
                Color.Default color = new Color.Default(this.presetColorValues, se, valueName);
                color.readWith(new XMLEventsReader(events));
                this.runProperties().add(new RunProperty.ColorRunProperty(this.conditionalParameters, this.presetColorValues, color));
            }
        }

        private ParagraphBlockProperties paragraphProperties(XMLEventReader reader, XMLEvent event) throws XMLStreamException {
            return new MarkupComponentParser().parseParagraphBlockProperties(new StartElementContext(event.asStartElement(), reader, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, this.eventFactory, this.conditionalParameters), new StrippableAttributes.DrawingRunProperties(this.conditionalParameters, this.eventFactory), new SkippableElements.Property(new SkippableElements.Default(SkippableElement.BlockProperty.BLOCK_PROPERTY_BIDI_VISUAL, SkippableElement.RunProperty.RUN_PROPERTY_LANGUAGE), this.conditionalParameters));
        }

        private RunProperties runProperties(XMLEventReader reader, XMLEvent event) throws XMLStreamException {
            StartElementContext startElementContext = new StartElementContext(event.asStartElement(), reader, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, this.eventFactory, this.conditionalParameters);
            return new RunPropertiesParser(startElementContext, new RunSkippableElements(startElementContext)).parse();
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public StyleType type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDefault() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String parentId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void parentId(String parentId) {
        }

        @Override
        public String linkedId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ParagraphBlockProperties paragraphProperties() {
            if (null == this.paragraphProperties) {
                this.paragraphProperties = new ParagraphBlockProperties.Word(new BlockProperties.Default(this.eventFactory, this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), PPR), this.conditionalParameters, this.eventFactory, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, new StrippableAttributes.Default(this.eventFactory));
            }
            return this.paragraphProperties;
        }

        @Override
        public void paragraphProperties(ParagraphBlockProperties paragraphBlockProperties) {
            this.paragraphProperties = paragraphBlockProperties;
        }

        @Override
        public RunProperties runProperties() {
            if (null == this.runProperties) {
                this.runProperties = new RunProperties.Default(this.conditionalParameters, this.eventFactory, this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), WordStyleDefinition.RPR);
            }
            return this.runProperties;
        }

        @Override
        public void runProperties(RunProperties runProperties) {
            this.runProperties = runProperties;
        }

        @Override
        public Markup asMarkup() {
            Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
            if (null == this.endElement) {
                return markup;
            }
            this.removeExplicitDefaults();
            markup.addComponent(new MarkupComponent.Start(this.eventFactory, this.startElement));
            if (null != this.paragraphPropertiesDefaultStartElement && null != this.paragraphPropertiesDefaultEndElement) {
                markup.addComponent(new MarkupComponent.StyledStart(new MarkupComponent.Start(this.eventFactory, this.paragraphPropertiesDefaultStartElement), new StyleDefinitions.Empty()));
                markup.addComponent(this.paragraphProperties());
                markup.addComponent(new MarkupComponent.End(this.paragraphPropertiesDefaultEndElement));
            }
            if (null != this.runPropertiesDefaultStartElement && null != this.runProperties && null != this.runPropertiesDefaultEndElement) {
                markup.addComponent(new MarkupComponent.Start(this.eventFactory, this.runPropertiesDefaultStartElement));
                markup.addComponent(this.runProperties);
                markup.addComponent(new MarkupComponent.End(this.runPropertiesDefaultEndElement));
            }
            markup.addComponent(new MarkupComponent.End(this.endElement));
            return markup;
        }

        private void removeExplicitDefaults() {
            RunProperty.ColorRunProperty crp;
            RunProperty.HighlightRunProperty hrp = this.runProperties().getHighlightProperty();
            if (Objects.nonNull(hrp) && EXPLICIT_DEFAULT_HIGHLIGHT_PROPERTY_VALUE.equals(hrp.value())) {
                this.runProperties().removeBy(hrp.getName());
            }
            if (Objects.nonNull(crp = this.runProperties().getColorRunProperty()) && this.explicitDefaultColorPropertyValue.equals(crp.value())) {
                this.runProperties().removeBy(crp.getName());
            }
        }
    }
}

