/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.okapi.filters.openxml.SourceAndTargetColumns;
import net.sf.okapi.filters.openxml.TargetColumnsMaxCharacters;
import net.sf.okapi.filters.openxml.WorksheetConfiguration;

public interface WorksheetConfigurations {
    public boolean matches(String var1);

    public SourceAndTargetColumns sourceAndTargetColumnsFor(String var1);

    public TargetColumnsMaxCharacters targetColumnsMaxCharactersFor(String var1);

    public Set<Integer> excludedRowsFor(String var1);

    public Set<String> excludedColumnsFor(String var1);

    public Set<Integer> metadataRowsFor(String var1);

    public Set<String> metadataColumnsFor(String var1);

    public void addFrom(Input var1);

    public <T> T writtenTo(Output<T> var1);

    public static interface Output<T> {
        public T writtenWith(Iterator<WorksheetConfiguration> var1);
    }

    public static interface Input {
        public Iterator<WorksheetConfiguration> read();
    }

    public static final class Default
    implements WorksheetConfigurations {
        private final List<WorksheetConfiguration> configurations;

        public Default(WorksheetConfiguration ... configurations) {
            this(new LinkedList<WorksheetConfiguration>(Arrays.asList(configurations)));
        }

        public Default(List<WorksheetConfiguration> configurations) {
            this.configurations = configurations;
        }

        @Override
        public boolean matches(String worksheetName) {
            return this.configurations.stream().anyMatch(c -> c.matches(worksheetName));
        }

        @Override
        public SourceAndTargetColumns sourceAndTargetColumnsFor(String worksheetName) {
            return new SourceAndTargetColumns.Default(this.configurations.stream().filter(c -> c.matches(worksheetName)).flatMap(c -> c.sourceColumns().stream()).collect(Collectors.toList()), this.configurations.stream().filter(c -> c.matches(worksheetName)).flatMap(c -> c.targetColumns().stream()).collect(Collectors.toList()));
        }

        @Override
        public TargetColumnsMaxCharacters targetColumnsMaxCharactersFor(String worksheetName) {
            return new TargetColumnsMaxCharacters.Default(this.configurations.stream().filter(c -> c.matches(worksheetName)).flatMap(c -> c.targetColumns().stream()).collect(Collectors.toList()), this.configurations.stream().filter(c -> c.matches(worksheetName)).flatMap(c -> c.targetColumnsMaxCharacters().stream()).collect(Collectors.toList()));
        }

        @Override
        public Set<Integer> excludedRowsFor(String worksheetName) {
            return this.configurations.stream().filter(c -> c.matches(worksheetName)).flatMap(c -> c.excludedRows().stream()).collect(Collectors.toSet());
        }

        @Override
        public Set<String> excludedColumnsFor(String worksheetName) {
            return this.configurations.stream().filter(c -> c.matches(worksheetName)).flatMap(c -> c.excludedColumns().stream()).collect(Collectors.toSet());
        }

        @Override
        public Set<Integer> metadataRowsFor(String worksheetName) {
            return this.configurations.stream().filter(c -> c.matches(worksheetName)).flatMap(c -> c.metadataRows().stream()).collect(Collectors.toSet());
        }

        @Override
        public Set<String> metadataColumnsFor(String worksheetName) {
            return this.configurations.stream().filter(c -> c.matches(worksheetName)).flatMap(c -> c.metadataColumns().stream()).collect(Collectors.toSet());
        }

        @Override
        public void addFrom(Input input) {
            Iterator<WorksheetConfiguration> iterator = input.read();
            while (iterator.hasNext()) {
                this.configurations.add(iterator.next());
            }
        }

        @Override
        public <T> T writtenTo(Output<T> output) {
            return output.writtenWith(this.configurations.iterator());
        }
    }
}

