/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.pdf;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filters.WrapMode;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.pdf.Parameters;
import net.sf.okapi.filters.plaintext.paragraphs.ParaPlainTextFilter;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

@UsingParameters(value=Parameters.class)
public class PdfFilter
implements IFilter {
    private Parameters params = new Parameters();
    private EncoderManager encoderManager;
    private RawDocument input;
    private ParaPlainTextFilter textFilter;

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
        }
        if (this.textFilter != null) {
            this.textFilter.close();
        }
    }

    @Override
    public String getName() {
        return "okf_pdf";
    }

    @Override
    public String getDisplayName() {
        return "PDF Filter";
    }

    @Override
    public String getMimeType() {
        return "application/pdf";
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration("okf_pdf", "application/pdf", this.getClass().getName(), "PDF (Portable Document Format)", "Configuration for PDF documents", null, ".pdf;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("application/pdf", "net.sf.okapi.common.encoder.DefaultEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.input = input;
        if (this.params.getUseCodeFinder()) {
            this.params.codeFinder.compile();
        }
        PDDocument pdf = null;
        StringWriter pdfWriter = new StringWriter();
        try {
            RandomAccessReadBuffer randomAccessBuffer = new RandomAccessReadBuffer(input.getStream());
            pdf = Loader.loadPDF((RandomAccessRead)randomAccessBuffer);
            PDFTextStripper textStripper = new PDFTextStripper();
            textStripper.setLineSeparator(this.params.getLineSeparator());
            textStripper.setParagraphEnd(this.params.getParagraphSeparator());
            textStripper.setIndentThreshold(Float.parseFloat(this.params.getIndentThreshold()));
            textStripper.setSpacingTolerance(Float.parseFloat(this.params.getSpacingTolerance()));
            textStripper.setSortByPosition(this.params.getSortByPosition());
            textStripper.writeText(pdf, (Writer)pdfWriter);
            this.textFilter = new ParaPlainTextFilter();
            RawDocument rd = new RawDocument(pdfWriter.toString(), input.getSourceLocale());
            rd.setFilterConfigId("okf_plaintext");
            rd.setEncoding(input.getEncoding());
            rd.setId(input.getId());
            net.sf.okapi.filters.plaintext.paragraphs.Parameters p = (net.sf.okapi.filters.plaintext.paragraphs.Parameters)this.textFilter.getParameters();
            p.trimLeading = true;
            p.trimTrailing = true;
            p.extractParagraphs = true;
            p.preserveWS = this.params.getPreserveWhitespace();
            p.wrapMode = WrapMode.SPACES;
            p.useCodeFinder = this.params.getUseCodeFinder();
            p.codeFinderRules = this.params.codeFinder.toString();
            this.textFilter.setParameters(p);
            this.textFilter.open(rd, generateSkeleton);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error parsing PDF file", e);
        }
        finally {
            try {
                pdfWriter.close();
                if (pdf != null) {
                    pdf.close();
                }
            }
            catch (IOException e) {
                throw new OkapiIOException("Error closing the PDF parser.", e);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.textFilter.hasNext();
    }

    @Override
    public Event next() {
        return this.textFilter.next();
    }
}

