/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.rainbowkit;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sf.okapi.common.DefaultParameters;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Tags;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.XLIFFReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLIFF2Filter
implements IFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private XLIFFReader reader;
    private net.sf.okapi.common.Event nextEvent;
    private IdGenerator otherId;
    private Stack<String> groupIds;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private DefaultParameters params;

    @Override
    public String getName() {
        return "okf_xliff2";
    }

    @Override
    public String getDisplayName() {
        return "XLIFF-v2 Filter";
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.close();
        this.reader = new XLIFFReader(255);
        if (input.getInputURI() != null) {
            this.reader.open(input.getInputURI());
        } else if (input.getInputCharSequence() != null) {
            this.reader.open(input.getInputCharSequence().toString());
        } else {
            this.reader.open(input.getStream());
        }
        this.otherId = new IdGenerator(null, "d");
        this.groupIds = new Stack();
    }

    @Override
    public void close() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.read();
    }

    @Override
    public net.sf.okapi.common.Event next() {
        return this.nextEvent;
    }

    @Override
    public void cancel() {
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (DefaultParameters)params;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return null;
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return null;
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public String getMimeType() {
        return "application/x-xliff+xml";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/x-xliff+xml", this.getClass().getName(), "XLIFF v2", "Configuration for XLIFF v2 documents.", null, ".xlf;"));
        return list;
    }

    private boolean read() {
        try {
            block13: while (this.reader.hasNext()) {
                Event xEvent = this.reader.next();
                switch (xEvent.getType()) {
                    case INSIGNIFICANT_PART: 
                    case START_DOCUMENT: 
                    case MID_FILE: 
                    case SKELETON: {
                        continue block13;
                    }
                    case END_DOCUMENT: {
                        this.close();
                        return false;
                    }
                    case START_XLIFF: {
                        StartXliffData dd = xEvent.getStartXliffData();
                        StartDocument sd = new StartDocument("_sd");
                        this.srcLoc = LocaleId.fromBCP47(dd.getSourceLanguage());
                        this.trgLoc = dd.getTargetLanguage() == null ? null : LocaleId.fromBCP47(dd.getTargetLanguage());
                        sd.setLocale(this.srcLoc);
                        this.nextEvent = new net.sf.okapi.common.Event(EventType.START_DOCUMENT, sd);
                        return true;
                    }
                    case END_XLIFF: {
                        this.nextEvent = new net.sf.okapi.common.Event(EventType.END_DOCUMENT, new Ending(this.otherId.createId()));
                        return true;
                    }
                    case START_FILE: {
                        StartFileData sfd = xEvent.getStartFileData();
                        StartSubDocument ssd = new StartSubDocument("_sd", sfd.getId());
                        this.nextEvent = new net.sf.okapi.common.Event(EventType.START_SUBDOCUMENT, ssd);
                        return true;
                    }
                    case END_FILE: {
                        this.nextEvent = new net.sf.okapi.common.Event(EventType.END_SUBDOCUMENT, new Ending(this.otherId.createId()));
                        return true;
                    }
                    case START_GROUP: {
                        StartGroupData sgd = xEvent.getStartGroupData();
                        StartGroup sg = new StartGroup(this.groupIds.isEmpty() ? null : this.groupIds.peek(), sgd.getId());
                        sg.setIsTranslatable(sgd.getTranslate());
                        this.groupIds.push(sg.getId());
                        this.nextEvent = new net.sf.okapi.common.Event(EventType.START_GROUP, sg);
                        return true;
                    }
                    case END_GROUP: {
                        this.nextEvent = new net.sf.okapi.common.Event(EventType.END_GROUP, new Ending(this.otherId.createId()));
                        this.groupIds.pop();
                        return true;
                    }
                    case TEXT_UNIT: {
                        this.nextEvent = this.createTextUnit(xEvent.getUnit());
                        return true;
                    }
                }
            }
        }
        catch (Throwable e) {
            this.logger.error("Error while reading XLIFF2 document.", e);
            throw new OkapiIOException("Error while reading XLIFF2 document.", e);
        }
        return false;
    }

    private net.sf.okapi.common.Event createTextUnit(Unit unit) {
        TextUnit tu = new TextUnit(unit.getId());
        TextContainer srcTc = tu.getSource();
        TextContainer trgTc = this.trgLoc == null ? null : tu.createTarget(this.trgLoc, false, 0);
        for (Part part : unit) {
            srcTc.append(this.createTextFragment(part, true));
            if (trgTc == null) continue;
            trgTc.append(this.createTextFragment(part, false));
        }
        net.sf.okapi.common.Event event = new net.sf.okapi.common.Event(EventType.TEXT_UNIT, tu);
        return event;
    }

    private TextFragment createTextFragment(Part part, boolean source) {
        TextFragment tf = new TextFragment();
        Fragment frag = null;
        Tags markers = null;
        if (source) {
            frag = part.getSource();
            markers = part.getSourceTags();
        } else if (part.hasTarget()) {
            frag = part.getTarget();
            markers = part.getTargetTags();
        } else {
            frag = part.getSource();
            markers = part.getSourceTags();
        }
        String ct = frag.getCodedText();
        block12: for (int i = 0; i < ct.length(); ++i) {
            char ch = ct.charAt(i);
            switch (ch) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    CTag cm = (CTag)markers.get((CharSequence)ct, i);
                    ++i;
                    TagType xTagType = cm.getTagType();
                    Code code = new Code(null);
                    switch (xTagType) {
                        case CLOSING: {
                            code.setTagType(TextFragment.TagType.CLOSING);
                            break;
                        }
                        case OPENING: {
                            code.setTagType(TextFragment.TagType.OPENING);
                            break;
                        }
                        case STANDALONE: {
                            code.setTagType(TextFragment.TagType.PLACEHOLDER);
                        }
                    }
                    code.setData(cm.getData());
                    code.setType(cm.getType() == null ? "x" : cm.getType());
                    try {
                        code.setId(Integer.parseInt(cm.getId()));
                    }
                    catch (NumberFormatException e) {
                        this.logger.error("Unexpected id value '{}' for inline code.", (Object)cm.getId());
                        code.setId(StringUtil.generateIntId(cm.getId()));
                    }
                    tf.append(code);
                    continue block12;
                }
                case '\ue104': 
                case '\ue105': {
                    ++i;
                    continue block12;
                }
                case '\ue106': {
                    ++i;
                    continue block12;
                }
                default: {
                    tf.append(ch);
                }
            }
        }
        return tf;
    }
}

