/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.regex;

import java.util.regex.Pattern;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.common.filters.InlineCodeFinder;

public class Rule {
    public static final int RULETYPE_STRING = 0;
    public static final int RULETYPE_CONTENT = 1;
    public static final int RULETYPE_COMMENT = 2;
    public static final int RULETYPE_NOTRANS = 3;
    public static final int RULETYPE_OPENGROUP = 4;
    public static final int RULETYPE_CLOSEGROUP = 5;
    protected String ruleName;
    protected String expr;
    protected int ruleType;
    protected boolean preserveWS;
    protected boolean useCodeFinder;
    protected InlineCodeFinder codeFinder;
    protected boolean collapseNewline;
    protected String propertyName;
    protected String propertyValue;
    protected String sample;
    protected int sourceGroup;
    protected int targetGroup;
    protected int nameGroup;
    protected int noteGroup;
    protected Pattern pattern;

    public Rule() {
        this.ruleName = "";
        this.expr = "";
        this.sourceGroup = -1;
        this.targetGroup = -1;
        this.nameGroup = -1;
        this.noteGroup = -1;
        this.codeFinder = new InlineCodeFinder();
        this.preserveWS = true;
        this.collapseNewline = false;
        this.sample = "";
    }

    public Rule(Rule obj) {
        this.ruleName = obj.ruleName;
        this.expr = obj.expr;
        this.sourceGroup = obj.sourceGroup;
        this.targetGroup = obj.targetGroup;
        this.nameGroup = obj.nameGroup;
        this.noteGroup = obj.noteGroup;
        this.ruleType = obj.ruleType;
        this.preserveWS = obj.preserveWS;
        this.useCodeFinder = obj.useCodeFinder;
        this.codeFinder = obj.codeFinder.clone();
        this.collapseNewline = obj.collapseNewline;
        this.propertyName = obj.propertyName;
        this.propertyValue = obj.propertyValue;
        this.sample = obj.sample;
        this.pattern = obj.pattern;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String value) {
        this.ruleName = value;
    }

    public String getExpression() {
        return this.expr;
    }

    public void setExpression(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.expr = value;
    }

    public String getSample() {
        return this.sample;
    }

    public void setSample(String value) {
        this.sample = value == null ? "" : value;
    }

    public int getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(int value) {
        this.ruleType = value;
    }

    public int getSourceGroup() {
        return this.sourceGroup;
    }

    public void setSourceGroup(int index) {
        this.sourceGroup = index;
    }

    public int getTargetGroup() {
        return this.targetGroup;
    }

    public void setTargetGroup(int index) {
        this.targetGroup = index;
    }

    public int getNameGroup() {
        return this.nameGroup;
    }

    public void setNameGroup(int index) {
        this.nameGroup = index;
    }

    public int getNoteGroup() {
        return this.noteGroup;
    }

    public void setNoteGroup(int index) {
        this.noteGroup = index;
    }

    public boolean preserveWS() {
        return this.preserveWS;
    }

    public void setPreserveWS(boolean value) {
        this.preserveWS = value;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String value) {
        this.propertyName = value;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public void setPropertyValue(String value) {
        this.propertyValue = value;
    }

    public boolean useCodeFinder() {
        return this.useCodeFinder;
    }

    public void setUseCodeFinder(boolean value) {
        this.useCodeFinder = value;
    }

    public String getCodeFinderRules() {
        return this.codeFinder.toString();
    }

    public void setCodeFinderRules(String value) {
        this.codeFinder.fromString(value);
    }

    public boolean getCollapseNewline() {
        return this.collapseNewline;
    }

    public void setCollapseNewline(boolean value) {
        this.collapseNewline = value;
    }

    public String toString() {
        ParametersString tmp = new ParametersString();
        tmp.setString("ruleName", this.ruleName);
        tmp.setInteger("ruleType", this.ruleType);
        tmp.setString("expr", this.expr);
        tmp.setInteger("groupSource", this.sourceGroup);
        tmp.setInteger("groupTarget", this.targetGroup);
        tmp.setInteger("groupName", this.nameGroup);
        tmp.setInteger("groupNote", this.noteGroup);
        tmp.setBoolean("preserveWS", this.preserveWS);
        tmp.setBoolean("useCodeFinder", this.useCodeFinder);
        tmp.setString("propertyName", this.propertyName);
        tmp.setString("propertyValue", this.propertyValue);
        tmp.setString("sample", this.sample);
        tmp.setGroup("codeFinderRules", this.codeFinder.toString());
        tmp.setBoolean("collapseNewline", this.collapseNewline);
        return tmp.toString();
    }

    public void fromString(String data) {
        ParametersString tmp = new ParametersString(data);
        this.ruleName = tmp.getString("ruleName", this.ruleName);
        this.ruleType = tmp.getInteger("ruleType", this.ruleType);
        this.expr = tmp.getString("expr", this.expr);
        this.sourceGroup = tmp.getInteger("groupSource", this.sourceGroup);
        this.targetGroup = tmp.getInteger("groupTarget", this.targetGroup);
        this.nameGroup = tmp.getInteger("groupName", this.nameGroup);
        this.noteGroup = tmp.getInteger("groupNote", this.noteGroup);
        this.preserveWS = tmp.getBoolean("preserveWS", this.preserveWS);
        this.propertyName = tmp.getString("propertyName", this.propertyName);
        this.propertyValue = tmp.getString("propertyValue", this.propertyValue);
        this.sample = tmp.getString("sample", this.sample);
        this.useCodeFinder = tmp.getBoolean("useCodeFinder", this.useCodeFinder);
        this.codeFinder.fromString(tmp.getGroup("codeFinderRules", ""));
        this.collapseNewline = tmp.getBoolean("collapseNewline", this.collapseNewline);
    }
}

