/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.subtitles;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.okapi.common.annotation.IAnnotation;

public class CaptionAnnotation
implements IAnnotation,
Iterable<CaptionTiming> {
    private ArrayList<CaptionTiming> timings;
    private DateTimeFormatter formatter;
    private int maxChar = 0;
    private int maxLine = 0;

    public CaptionAnnotation(DateTimeFormatter formatter) {
        this.formatter = formatter;
        this.timings = new ArrayList(2);
    }

    public void setMaxChar(int maxChar) {
        this.maxChar = maxChar;
    }

    public void setMaxLine(int maxLine) {
        this.maxLine = maxLine;
    }

    public int getMaxChar() {
        return this.maxChar;
    }

    public int getMaxLine() {
        return this.maxLine;
    }

    public void add(CaptionTiming timing) {
        this.timings.add(timing);
    }

    public void add(String beginTime, String endTime) {
        this.add(new CaptionTiming(beginTime, endTime));
    }

    public void add(LocalTime beginTime, LocalTime endTime) {
        this.add(new CaptionTiming(beginTime, endTime));
    }

    public int getSize() {
        return this.timings.size();
    }

    public CaptionTiming getFirst() {
        return this.timings.get(0);
    }

    public CaptionTiming getLast() {
        return this.timings.get(this.getSize() - 1);
    }

    @Override
    public Iterator<CaptionTiming> iterator() {
        return new Iterator<CaptionTiming>(){
            private int current = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The method remove() not supported.");
            }

            @Override
            public CaptionTiming next() {
                if (this.current >= CaptionAnnotation.this.timings.size()) {
                    throw new NoSuchElementException("No more content parts.");
                }
                return CaptionAnnotation.this.timings.get(this.current++);
            }

            @Override
            public boolean hasNext() {
                return this.current < CaptionAnnotation.this.timings.size();
            }
        };
    }

    public class CaptionTiming {
        private LocalTime begin;
        private LocalTime end;
        private String beginString;
        private String endString;

        private CaptionTiming(String begin, String end) {
            this.beginString = begin;
            this.endString = end;
            try {
                this.begin = this.parseTime(begin);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
            try {
                this.end = this.parseTime(end);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }

        private CaptionTiming(LocalTime begin, LocalTime end) {
            this.begin = begin;
            this.end = end;
        }

        public String getBeginString() {
            return this.beginString;
        }

        public String getEndString() {
            return this.endString;
        }

        public LocalTime getBeginTime() {
            return this.begin;
        }

        public LocalTime getEndTime() {
            return this.end;
        }

        private LocalTime parseTime(String time) {
            if (CaptionAnnotation.this.formatter == null) {
                return LocalTime.parse(time);
            }
            return LocalTime.parse(time, CaptionAnnotation.this.formatter);
        }
    }
}

