/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.subtitles;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SplitCaption
implements Iterable<ArrayList<String>> {
    private static final int DEFAULT_MAXLINE = 2;
    private static final int DEFAULT_MAXCHAR = 47;
    private ArrayList<ArrayList<String>> captions;
    private final boolean dontSplitWords;
    private final int trueMaxChar;
    private final boolean isCJK;

    public SplitCaption(ArrayList<ArrayList<String>> captions) {
        this(true, 47, false);
        this.captions = captions;
    }

    public SplitCaption(String s, int numCaptions) {
        this(true, 47, false);
        for (String caption : SplitCaption.splitEqually(s, numCaptions)) {
            ArrayList<String> captionList = new ArrayList<String>();
            captionList.add(caption);
            this.captions.add(captionList);
        }
    }

    private SplitCaption(boolean dontSplitWords, int trueMaxChar, boolean isCJK) {
        this.dontSplitWords = dontSplitWords;
        this.trueMaxChar = trueMaxChar;
        this.isCJK = isCJK;
        this.captions = new ArrayList();
    }

    private SplitCaption(String s, int maxLine, int maxChar, int widthPerCaption, int numCaptions, boolean dontSplitWords, int trueMaxChar, boolean isCJK) {
        this(dontSplitWords, trueMaxChar, isCJK);
        for (String caption : SplitCaption.splitEqually(s, numCaptions)) {
            this.addAndSplitCaption(caption, maxLine, maxChar, false);
        }
    }

    private int numCaptions() {
        return this.captions.size();
    }

    private void addAndSplitCaptionDontSplitWords(String s, int maxLine, boolean attemptMinFill) {
        int maxChar = SplitCaption.minParts(s, maxLine);
        if (attemptMinFill) {
            maxChar = this.trueMaxChar;
        }
        ArrayList<String> caption = new ArrayList<String>();
        String[] captionWords = SplitCaption.split(s, this.isCJK, this.dontSplitWords);
        int indexCaptionWords = 0;
        do {
            StringBuilder line = new StringBuilder();
            while (indexCaptionWords < captionWords.length) {
                line.append(captionWords[indexCaptionWords]);
                if (line.length() > maxChar || ++indexCaptionWords == captionWords.length) break;
                if (this.isCJK && SplitCaption.wordIsAlphabet(captionWords[indexCaptionWords - 1]) && indexCaptionWords != captionWords.length && SplitCaption.wordIsAlphabet(captionWords[indexCaptionWords])) {
                    line.append(" ");
                    continue;
                }
                if (this.isCJK) continue;
                line.append(" ");
            }
            caption.add(line.toString().stripTrailing());
        } while (indexCaptionWords != captionWords.length);
        if (!attemptMinFill && caption.size() < maxLine) {
            this.addAndSplitCaptionDontSplitWords(s, maxLine, true);
            return;
        }
        this.captions.add(caption);
    }

    private void addAndSplitCaption(String s, int maxLine, int maxChar, boolean attemptMaxFill) {
        if (this.dontSplitWords) {
            this.addAndSplitCaptionDontSplitWords(s, maxLine, false);
            return;
        }
        ArrayList<String> caption = new ArrayList<String>();
        String[] captionWords = SplitCaption.split(s, this.isCJK, false);
        int indexCaptionWords = 0;
        int averageLengthPerLine = s.length() / maxLine;
        do {
            StringBuilder line = new StringBuilder();
            int lastWordIndex = 0;
            while (indexCaptionWords < captionWords.length) {
                line.append(captionWords[indexCaptionWords]);
                if (!attemptMaxFill && line.length() > averageLengthPerLine || line.length() > maxChar || ++indexCaptionWords == captionWords.length) break;
                lastWordIndex = line.length();
                line.append(" ");
            }
            if (line.length() > maxChar) {
                if (lastWordIndex == 0 || caption.size() == maxLine - 1) {
                    this.addEqually(s, maxChar, maxLine);
                    return;
                }
                --indexCaptionWords;
                line.delete(lastWordIndex, line.length());
            }
            caption.add(line.toString().stripTrailing());
        } while (indexCaptionWords != captionWords.length);
        if (indexCaptionWords == captionWords.length) {
            this.captions.add(caption);
            return;
        }
        if (!attemptMaxFill) {
            this.addAndSplitCaption(s, maxLine, maxChar, true);
            return;
        }
        this.addEqually(s, maxChar, maxLine);
    }

    private void addEqually(String s, int maxChar, int maxLine) {
        this.captions.add(SplitCaption.splitEquallyIntoMinParts(s, maxChar, maxLine));
    }

    public ArrayList<ArrayList<String>> getCaptions() {
        return this.captions;
    }

    @Override
    public Iterator<ArrayList<String>> iterator() {
        return new Iterator<ArrayList<String>>(){
            int current = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The method remove() not supported.");
            }

            @Override
            public ArrayList<String> next() {
                if (this.current >= SplitCaption.this.captions.size()) {
                    throw new NoSuchElementException("No more content parts.");
                }
                return SplitCaption.this.captions.get(this.current++);
            }

            @Override
            public boolean hasNext() {
                return this.current < SplitCaption.this.captions.size();
            }
        };
    }

    private static ArrayList<String> splitEquallyIntoMinParts(String s, int maxChar, int maxParts) {
        return SplitCaption.splitEqually(s, Math.min(maxParts, SplitCaption.minParts(s, maxChar)));
    }

    private static ArrayList<String> splitEqually(String s, int parts) {
        int increment;
        int maxChar = s.length() / parts;
        int modLength = SplitCaption.modLength(s, parts);
        ArrayList<String> result = new ArrayList<String>();
        for (int index = 0; index < s.length(); index += increment) {
            increment = maxChar;
            if (modLength > 0) {
                ++increment;
                --modLength;
            }
            result.add(s.substring(index, Math.min(index + increment, s.length())).trim());
        }
        while (result.size() < parts) {
            result.add("");
        }
        return result;
    }

    private static int modLength(String s, int maxLength) {
        return s.length() % maxLength;
    }

    private static int minParts(String s, int maxLength) {
        if (maxLength == 0) {
            return 0;
        }
        return s.length() / maxLength + (SplitCaption.modLength(s, maxLength) == 0 ? 0 : 1);
    }

    public static SplitCaption splitCaptionDontSplitWords(String wholeCaption, int numCaptions, int maxLine, int maxChar, int trueMaxChar, boolean attemptMinFill, boolean isCJK) {
        String[] captionWords = SplitCaption.split(wholeCaption, isCJK, true);
        SplitCaption splitCaption = new SplitCaption(true, trueMaxChar, isCJK);
        int widthPerCaption = maxLine * maxChar;
        int indexCaptionWords = 0;
        for (int i = 0; i < numCaptions; ++i) {
            StringBuilder caption = new StringBuilder();
            int lastWordIndex = 0;
            while (indexCaptionWords < captionWords.length) {
                caption.append(captionWords[indexCaptionWords]);
                if (caption.length() >= widthPerCaption || ++indexCaptionWords == captionWords.length) break;
                lastWordIndex = caption.length();
                if (isCJK && SplitCaption.wordIsAlphabet(captionWords[indexCaptionWords - 1]) && indexCaptionWords != captionWords.length && SplitCaption.wordIsAlphabet(captionWords[indexCaptionWords])) {
                    caption.append(" ");
                    continue;
                }
                if (isCJK) continue;
                caption.append(" ");
            }
            if (attemptMinFill && caption.length() > widthPerCaption && lastWordIndex != 0) {
                caption.delete(lastWordIndex, caption.length());
                --indexCaptionWords;
            }
            splitCaption.addAndSplitCaptionDontSplitWords(caption.toString(), maxLine, false);
        }
        if (!attemptMinFill && splitCaption.numCaptions() < numCaptions) {
            return SplitCaption.splitCaptionDontSplitWords(wholeCaption, numCaptions, maxLine, trueMaxChar, trueMaxChar, true, isCJK);
        }
        return splitCaption;
    }

    private static String[] split(String string, boolean isCJK, boolean dontSplitWords) {
        if (isCJK && dontSplitWords) {
            return SplitCaption.splitCJKWithWords(string);
        }
        if (isCJK) {
            return SplitCaption.splitCJK(string);
        }
        return SplitCaption.split(string);
    }

    public static String[] split(String string) {
        return string.split("\\s+");
    }

    public static String[] splitCJK(String string) {
        return string.split("[\\s+]|(?<=\u3001)|(?<=\u3002)");
    }

    private static boolean isAlphabet(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean wordIsAlphabet(String word) {
        return word.matches("^[a-zA-z]*$");
    }

    private static String[] splitCJKWithWords(String string) {
        ArrayList<Object> split = new ArrayList<Object>();
        StringBuilder currentWord = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (SplitCaption.isAlphabet(c)) {
                currentWord.append(c);
                continue;
            }
            if (currentWord.length() > 0) {
                split.add(currentWord.toString());
                currentWord = new StringBuilder();
            }
            if ((Character.isWhitespace(c) || c == '\u3002' || c == '\u3001') && split.size() > 0) {
                String lastWord = (String)split.remove(split.size() - 1);
                split.add(lastWord + c);
                continue;
            }
            split.add(String.valueOf(c));
        }
        if (currentWord.length() > 0) {
            split.add(currentWord.toString());
        }
        String[] array = new String[split.size()];
        return split.toArray(array);
    }

    public static SplitCaption splitCaption(String wholeCaption, int numCaptions, int maxLine, int maxChar, boolean attemptMaxFill, boolean attemptMinFill, boolean dontSplitWords, boolean isCJK) {
        int lenCaption = wholeCaption.length();
        if (maxLine == 0) {
            maxLine = 2;
        }
        if (maxChar == 0) {
            maxChar = 47;
        }
        int trueMaxChar = maxChar;
        if (lenCaption > numCaptions * maxLine * maxChar) {
            maxChar = SplitCaption.minParts(wholeCaption, numCaptions * maxLine);
        }
        int maxWidthPerCaption = maxLine * maxChar;
        String[] captionWords = SplitCaption.split(wholeCaption, isCJK, dontSplitWords);
        if (captionWords.length < numCaptions) {
            return new SplitCaption(wholeCaption, maxLine, maxChar, maxWidthPerCaption, numCaptions, dontSplitWords, trueMaxChar, isCJK);
        }
        SplitCaption splitCaption = new SplitCaption(dontSplitWords, trueMaxChar, isCJK);
        int indexCaptionWords = 0;
        int captionLengthLeft = lenCaption;
        for (int i = 0; i < numCaptions; ++i) {
            if (indexCaptionWords == captionWords.length) {
                if (attemptMinFill) {
                    return new SplitCaption(wholeCaption, maxLine, maxChar, maxWidthPerCaption, numCaptions, dontSplitWords, trueMaxChar, isCJK);
                }
                return SplitCaption.splitCaption(wholeCaption, numCaptions, maxLine, maxChar, attemptMaxFill, true, dontSplitWords, isCJK);
            }
            int widthPerCaption = captionLengthLeft / (numCaptions - i);
            widthPerCaption = Math.min(widthPerCaption, maxWidthPerCaption);
            StringBuilder caption = new StringBuilder();
            int lastWordIndex = 0;
            while (indexCaptionWords < captionWords.length) {
                caption.append(captionWords[indexCaptionWords]);
                if (!attemptMaxFill && caption.length() >= widthPerCaption || caption.length() >= maxWidthPerCaption || ++indexCaptionWords == captionWords.length) break;
                lastWordIndex = caption.length();
                if (isCJK && dontSplitWords && SplitCaption.wordIsAlphabet(captionWords[indexCaptionWords - 1]) && indexCaptionWords != captionWords.length && SplitCaption.wordIsAlphabet(captionWords[indexCaptionWords])) {
                    caption.append(" ");
                    continue;
                }
                if (isCJK && dontSplitWords) continue;
                caption.append(" ");
            }
            if (caption.length() > maxWidthPerCaption) {
                if (lastWordIndex == 0 || splitCaption.numCaptions() == numCaptions - 1) {
                    if (dontSplitWords) {
                        return SplitCaption.splitCaptionDontSplitWords(wholeCaption, numCaptions, maxLine, maxChar, trueMaxChar, false, isCJK);
                    }
                    return new SplitCaption(wholeCaption, maxLine, maxChar, maxWidthPerCaption, numCaptions, dontSplitWords, trueMaxChar, isCJK);
                }
                caption.delete(lastWordIndex, caption.length());
                --indexCaptionWords;
            }
            if (attemptMinFill && caption.length() > widthPerCaption && lastWordIndex != 0) {
                caption.delete(lastWordIndex, caption.length());
                --indexCaptionWords;
            }
            splitCaption.addAndSplitCaption(caption.toString(), maxLine, maxChar, false);
            captionLengthLeft -= caption.length();
        }
        if (indexCaptionWords == captionWords.length) {
            return splitCaption;
        }
        if (attemptMaxFill) {
            return new SplitCaption(wholeCaption, maxLine, maxChar, maxWidthPerCaption, numCaptions, dontSplitWords, trueMaxChar, isCJK);
        }
        return SplitCaption.splitCaption(wholeCaption, numCaptions, maxLine, maxChar, true, attemptMinFill, dontSplitWords, isCJK);
    }
}

