/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.subtitles;

import net.sf.okapi.common.IResource;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.filters.EventBuilder;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.subtitles.CaptionAnnotation;
import net.sf.okapi.filters.subtitles.SubtitleFilter;

public class SubtitleEventBuilder
extends EventBuilder {
    private SubtitleFilter filter;
    private InlineCodeFinder codeFinder;

    public SubtitleEventBuilder(String rootId, IFilter filter) {
        super(rootId, filter);
        this.setMimeType(filter.getMimeType());
        this.codeFinder = null;
        this.filter = (SubtitleFilter)filter;
    }

    private void addMaxWidth(IResource resource) {
        if (this.filter.getMaxChar() > 0 && this.filter.getMaxLine() > 0) {
            CaptionAnnotation annotation = resource.getAnnotation(CaptionAnnotation.class);
            int numCaptions = 0;
            if (annotation != null) {
                numCaptions = annotation.getSize();
                annotation.setMaxChar(this.filter.getMaxChar());
                annotation.setMaxLine(this.filter.getMaxLine());
            }
            Property maxWidth = new Property("maxwidth", Integer.toString(this.filter.getMaxChar() * this.filter.getMaxLine() * numCaptions), Property.DISPLAY_ONLY);
            resource.setProperty(maxWidth);
            Property sizeUnit = new Property("size-unit", "char", Property.DISPLAY_ONLY);
            resource.setProperty(sizeUnit);
            if (this.filter.getParameters().getWriteCharAnnotations()) {
                GenericAnnotations anns = new GenericAnnotations();
                anns.add(new GenericAnnotation("misc-metadata", "max_chars_per_line", Integer.toString(this.filter.getMaxChar())));
                anns.add(new GenericAnnotation("misc-metadata", "max_lines_count", Integer.toString(this.filter.getMaxLine() * numCaptions)));
                GenericAnnotations.addAnnotations(resource, anns);
            }
        }
    }

    @Override
    protected ITextUnit postProcessTextUnit(ITextUnit textUnit) {
        TextFragment text = textUnit.getSource().getFirstContent();
        if (this.codeFinder != null) {
            this.codeFinder.process(text);
        }
        this.addMaxWidth(textUnit);
        return textUnit;
    }

    public void setCodeFinder(InlineCodeFinder codeFinder) {
        this.codeFinder = codeFinder;
    }
}

