/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.subtitles;

import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.subtitles.CaptionAnnotation;
import net.sf.okapi.filters.subtitles.SubtitleEventBuilder;
import net.sf.okapi.filters.subtitles.SubtitleParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=SubtitleParameters.class)
public abstract class SubtitleFilter
extends AbstractFilter {
    protected static final String DEFAULT_TIME_FORMAT = "HH:mm:ss.SSS";
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected SubtitleEventBuilder eventBuilder;
    protected SubtitleParameters params;
    protected boolean hasUtf8Bom;
    protected boolean hasUtf8Encoding;
    protected boolean skipNextWhiteSpace = false;
    protected int maxChar = 0;
    protected int maxLine = 0;
    protected DateTimeFormatter formatter;
    protected Pattern terminalPattern = Pattern.compile(this.getTerminalRegex());

    @Override
    public void setParameters(IParameters params) {
        this.params = (SubtitleParameters)params;
    }

    @Override
    public SubtitleParameters getParameters() {
        return this.params;
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
        this.LOGGER.debug("{} has opened an input document", (Object)this.getName());
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        super.open(input, generateSkeleton);
        this.formatter = SubtitleFilter.getDateTimeFormatter(this.params.getTimeFormat());
        if (input.getInputURI() != null) {
            this.setDocumentName(input.getInputURI().getPath());
        }
        this.detectEncoding(input);
        this.setOptions(input.getSourceLocale(), input.getTargetLocale(), this.getEncoding(), generateSkeleton);
        if (this.eventBuilder == null) {
            this.eventBuilder = new SubtitleEventBuilder(this.getParentId(), this);
            this.eventBuilder.setMimeType(this.getMimeType());
        } else {
            this.eventBuilder.reset(this.getParentId(), this);
        }
        if (this.params.getUseCodeFinder()) {
            this.params.getCodeFinder().compile();
            this.eventBuilder.setCodeFinder(this.params.getCodeFinder());
        }
        this.eventBuilder.addFilterEvent(this.createStartFilterEvent());
    }

    public static DateTimeFormatter getDateTimeFormatter(String timeFormat) {
        if (timeFormat.isEmpty()) {
            return DateTimeFormatter.ofPattern(DEFAULT_TIME_FORMAT);
        }
        return DateTimeFormatter.ofPattern(timeFormat);
    }

    @Override
    protected boolean isUtf8Encoding() {
        return this.hasUtf8Encoding;
    }

    @Override
    protected boolean isUtf8Bom() {
        return this.hasUtf8Bom;
    }

    private void detectEncoding(RawDocument input) {
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        if (input.getInputCharSequence() != null) {
            detector.detectBom();
        } else {
            detector.detectAndRemoveBom();
        }
        this.setEncoding(detector.getEncoding());
        this.hasUtf8Bom = detector.hasUtf8Bom();
        this.hasUtf8Encoding = detector.hasUtf8Encoding();
        this.setNewlineType(detector.getNewlineType().toString());
    }

    public static boolean isCJK(LocaleId localeId) {
        return localeId.sameLanguageAs(LocaleId.CHINA_CHINESE) || localeId.sameLanguageAs(LocaleId.KOREAN) || localeId.sameLanguageAs(LocaleId.JAPANESE);
    }

    public int getMaxChar() {
        if (this.maxChar == 0) {
            if (SubtitleFilter.isCJK(this.getTrgLoc())) {
                return this.params.getCjkCharsPerLine();
            }
            return this.params.getMaxCharsPerLine();
        }
        return this.maxChar;
    }

    public int getMaxLine() {
        if (this.maxLine == 0) {
            return this.params.getMaxLinesPerCaption();
        }
        return this.maxLine;
    }

    @Override
    public boolean hasNext() {
        return this.eventBuilder.hasNext();
    }

    protected void endFilter() {
        this.eventBuilder.flushRemainingTempEvents();
        this.eventBuilder.addFilterEvent(this.createEndFilterEvent());
    }

    protected void addString(String string) {
        if (this.isInsideTextRun()) {
            this.addToTextUnit(string);
        } else {
            this.addToDocumentPart(string);
        }
    }

    protected boolean isInsideTextRun() {
        return this.eventBuilder.isInsideTextRun();
    }

    protected void addToDocumentPart(String part) {
        if (Util.isEmpty(part)) {
            return;
        }
        this.eventBuilder.addToDocumentPart(part);
    }

    protected void addToTextUnit(String text) {
        if (Util.isEmpty(text)) {
            return;
        }
        if (text.trim().isEmpty()) {
            return;
        }
        ITextUnit tu = this.eventBuilder.peekMostRecentTextUnit();
        if (tu == null) {
            return;
        }
        if (this.skipNextWhiteSpace) {
            this.skipNextWhiteSpace = false;
        } else if (!SubtitleFilter.isCJK(this.getSrcLoc()) && SubtitleFilter.needToAppendWhitespace(tu.getSource().getFirstContent().getText()) && SubtitleFilter.needToPrependWhitespace(text)) {
            this.eventBuilder.addToTextUnit(" ");
        }
        this.eventBuilder.addToTextUnit(text);
    }

    protected static boolean needToAppendWhitespace(String str) {
        if (str.isEmpty()) {
            return false;
        }
        return !Character.isWhitespace(str.charAt(str.length() - 1));
    }

    protected static boolean needToPrependWhitespace(String str) {
        if (str.isEmpty()) {
            return false;
        }
        return !Character.isWhitespace(str.charAt(0));
    }

    protected void addCaptionAnnotation(String startTime, String endTime) {
        Event tempEvent = this.eventBuilder.peekTempEvent();
        CaptionAnnotation annotation = tempEvent.getResource().getAnnotation(CaptionAnnotation.class);
        if (annotation == null) {
            annotation = this.makeCaptionAnnotation();
            tempEvent.getResource().setAnnotation(annotation);
        }
        annotation.add(startTime, endTime);
    }

    public CaptionAnnotation makeCaptionAnnotation() {
        return new CaptionAnnotation(this.formatter);
    }

    protected abstract String getTerminalRegex();

    protected boolean endsWithPunctuation(String str) {
        if (str.trim().isEmpty()) {
            return false;
        }
        Matcher matcher = this.terminalPattern.matcher(str);
        return matcher.find();
    }
}

