/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.subtitles;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.CodeFinderPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SpinInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;

public class SubtitleParameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String TIMEFORMAT = "timeFormat";
    private static final String MAXLINESPERCAPTION = "maxLinesPerCaption";
    private static final String MAXCHARSPERLINE = "maxCharsPerLine";
    private static final String CJKCHARSPERLINE = "cjkCharsPerLine";
    private static final String KEEPTIMECODES = "keepTimecodes";
    private static final String SPLITWORDS = "splitWords";
    private static final String WRITECHARANNOTATIONS = "writeCharAnnotations";
    private static final String MERGECAPTIONS = "mergeCaptions";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String CODEFINDERRULES = "codeFinderRules";
    private InlineCodeFinder codeFinder;

    public String getTimeFormat() {
        return this.getString(TIMEFORMAT);
    }

    public void setTimeFormat(String timeFormat) {
        this.setString(TIMEFORMAT, timeFormat);
    }

    public int getMaxLinesPerCaption() {
        return this.getInteger(MAXLINESPERCAPTION);
    }

    public void setMaxLinesPerCaption(int maxLinesPerCaption) {
        this.setInteger(MAXLINESPERCAPTION, maxLinesPerCaption);
    }

    public int getMaxCharsPerLine() {
        return this.getInteger(MAXCHARSPERLINE);
    }

    public void setMaxCharsPerLine(int maxCharsPerLine) {
        this.setInteger(MAXCHARSPERLINE, maxCharsPerLine);
    }

    public int getCjkCharsPerLine() {
        return this.getInteger(CJKCHARSPERLINE);
    }

    public void setCjkCharsPerLine(int cjkCharsPerLine) {
        this.setInteger(CJKCHARSPERLINE, cjkCharsPerLine);
    }

    public boolean getKeepTimecodes() {
        return this.getBoolean(KEEPTIMECODES);
    }

    public void setKeepTimecodes(boolean keepTimecodes) {
        this.setBoolean(KEEPTIMECODES, keepTimecodes);
    }

    public boolean getSplitWords() {
        return this.getBoolean(SPLITWORDS);
    }

    public void setSplitWords(boolean splitWords) {
        this.setBoolean(SPLITWORDS, splitWords);
    }

    public boolean getWriteCharAnnotations() {
        return this.getBoolean(WRITECHARANNOTATIONS);
    }

    public void setWriteCharAnnotations(boolean writeCharAnnotations) {
        this.setBoolean(WRITECHARANNOTATIONS, writeCharAnnotations);
    }

    public boolean getMergeCaptions() {
        return this.getBoolean(MERGECAPTIONS);
    }

    public void setMergeCaptions(boolean mergeCaptions) {
        this.setBoolean(MERGECAPTIONS, mergeCaptions);
    }

    public boolean getUseCodeFinder() {
        return this.getBoolean(USECODEFINDER);
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.setBoolean(USECODEFINDER, useCodeFinder);
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public String getCodeFinderRules() {
        return this.codeFinder.toString();
    }

    public void setCodeFinderRules(String data) {
        this.codeFinder.fromString(data);
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.codeFinder.fromString(this.buffer.getGroup(CODEFINDERRULES, ""));
    }

    @Override
    public String toString() {
        this.buffer.setGroup(CODEFINDERRULES, this.codeFinder.toString());
        return super.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.setTimeFormat("HH:mm:ss.SSS");
        this.setMaxLinesPerCaption(0);
        this.setMaxCharsPerLine(0);
        this.setCjkCharsPerLine(0);
        this.setKeepTimecodes(false);
        this.setSplitWords(true);
        this.setWriteCharAnnotations(false);
        this.setMergeCaptions(true);
        this.setUseCodeFinder(false);
        this.codeFinder = new InlineCodeFinder();
        this.codeFinder.setSample("&name; <tag></at><tag/> <tag attr='val'> </tag=\"val\">");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("</?([A-Z0-9a-z]*)\\b[^>]*>");
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(KEEPTIMECODES, "Keep timecodes", null);
        desc.add(TIMEFORMAT, "Time format", null);
        desc.add(MAXCHARSPERLINE, "Max characters per line", null);
        desc.add(MAXLINESPERCAPTION, "Max lines per caption", null);
        desc.add(CJKCHARSPERLINE, "Max characters per line for CJK", null);
        desc.add(SPLITWORDS, "Split words so that they don't go over the char limit", null);
        desc.add(WRITECHARANNOTATIONS, "Write character limit info as annotations to xliff", null);
        desc.add(MERGECAPTIONS, "Merge captions by sentence", null);
        desc.add(USECODEFINDER, "Has inline codes as defined below:", null);
        desc.add(CODEFINDERRULES, null, "Rules for inline codes");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        return this.createEditorDescription("Subtitle Filter Parameters", paramDesc);
    }

    protected EditorDescription createEditorDescription(String caption, ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription(caption, true, false);
        CheckboxPart cp = desc.addCheckboxPart(paramDesc.get(KEEPTIMECODES));
        TextInputPart tip = desc.addTextInputPart(paramDesc.get(TIMEFORMAT));
        tip.setAllowEmpty(false);
        SpinInputPart sip = desc.addSpinInputPart(paramDesc.get(MAXLINESPERCAPTION));
        sip.setRange(1, 9999999);
        sip = desc.addSpinInputPart(paramDesc.get(MAXCHARSPERLINE));
        sip.setRange(1, 9999999);
        sip = desc.addSpinInputPart(paramDesc.get(CJKCHARSPERLINE));
        sip.setRange(1, 9999999);
        cp = desc.addCheckboxPart(paramDesc.get(SPLITWORDS));
        cp = desc.addCheckboxPart(paramDesc.get(WRITECHARANNOTATIONS));
        cp = desc.addCheckboxPart(paramDesc.get(MERGECAPTIONS));
        CheckboxPart cbp = desc.addCheckboxPart(paramDesc.get(USECODEFINDER));
        CodeFinderPart cfp = desc.addCodeFinderPart(paramDesc.get(CODEFINDERRULES));
        cfp.setMasterPart(cbp, true);
        return desc;
    }
}

