/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.tex;

import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.IEncoder;

public class TEXEncoder
implements IEncoder {
    private static final String LINEBREAK = "\n";
    private static final Map<String, String> map = new ConcurrentHashMap<String, String>();

    public TEXEncoder() {
        this.reset();
    }

    public String encode(String text) {
        if (text == null) {
            return "";
        }
        return this.convertCodesToLetters(text);
    }

    @Override
    public String encode(String text, EncoderContext context) {
        if (text == null) {
            return "";
        }
        return this.convertCodesToLetters(text);
    }

    @Override
    public String encode(int value, EncoderContext context) {
        switch (value) {
            case 10: {
                return LINEBREAK;
            }
        }
        if (Character.isSupplementaryCodePoint(value)) {
            return new String(Character.toChars(value)).replace(LINEBREAK, LINEBREAK);
        }
        return String.valueOf((char)value).replace(LINEBREAK, LINEBREAK);
    }

    @Override
    public String encode(char value, EncoderContext context) {
        switch (value) {
            case '\n': {
                return LINEBREAK;
            }
        }
        return String.valueOf(value);
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return null;
    }

    @Override
    public String getLineBreak() {
        return LINEBREAK;
    }

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
    }

    @Override
    public String toNative(String propertyName, String value) {
        return this.convertLettersToCodes(value);
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public String getEncoding() {
        return "";
    }

    private String convertLettersToCodes(String line) {
        return this.convert(line, true);
    }

    private String convertCodesToLetters(String line) {
        return this.convert(line, false);
    }

    private String getKeyByValue(String value) {
        String key = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!Objects.equals(value, entry.getValue()) || key.length() >= entry.getKey().length()) continue;
            key = entry.getKey();
        }
        return key;
    }

    private String convert(String line, boolean convertLettersToCodes) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        if (convertLettersToCodes) {
            keys = new ArrayList<String>(map.values());
        }
        block0: while (line.length() > 0) {
            for (String k : keys) {
                if (!line.startsWith(k)) continue;
                if (convertLettersToCodes) {
                    sb.append(this.getKeyByValue(k));
                } else {
                    sb.append(map.get(k));
                }
                line = line.substring(k.length(), line.length());
                continue block0;
            }
            sb.append(line.charAt(0));
            line = line.substring(1, line.length());
        }
        return sb.toString();
    }

    @Override
    public void reset() {
        map.put("\\LaTeX", "\\LaTeX");
        map.put("\\%", "\\%");
        map.put("\\oe", "\u0153");
        map.put("\\OE", "\u0152");
        map.put("\\ae", "\u00e6");
        map.put("\\AE", "\u00c6");
        map.put("\\aa", "\u00e5");
        map.put("\\AA", "\u00c5");
        map.put("\\o", "\u00f8");
        map.put("\\O", "\u00d8");
        map.put("\\l", "\u0142");
        map.put("\\L", "\u0141");
        map.put("\\ss", "\u00df");
        map.put("\\j", "\u0237");
        map.put("\\`{a}", "\u00e0");
        map.put("\\`{A}", "\u00c0");
        map.put("\\'{a}", "\u00e1");
        map.put("\\'{A}", "\u00c1");
        map.put("\\^{a}", "\u00e2");
        map.put("\\^{A}", "\u00c2");
        map.put("\\\"{a}", "\u00e4");
        map.put("\\\"{A}", "\u00c4");
        map.put("\\~{a}", "\u00e3");
        map.put("\\~{A}", "\u00c3");
        map.put("\\={a}", "\u0101");
        map.put("\\=a", "\u0101");
        map.put("\\={A}", "\u0100");
        map.put("\\=A", "\u0100");
        map.put("\\.{a}", "\u0227");
        map.put("\\.{A}", "\u0226");
        map.put("\\u{a}", "\u0103");
        map.put("\\u{A}", "\u0102");
        map.put("\\v{a}", "\u01ce");
        map.put("\\v{A}", "\u01cd");
        map.put("\\H{a}", "\u0201");
        map.put("\\H{A}", "\u0200");
        map.put("\\c{a}", "\u0105");
        map.put("\\c{A}", "\u0104");
        map.put("\\d{a}", "\u1ea1");
        map.put("\\d{A}", "\u1ea0");
        map.put("\\k{a}", "\u1d8f");
        map.put("\\.{b}", "\u1e03");
        map.put("\\.{B}", "\u1e02");
        map.put("\\c{b}", "\u1e07");
        map.put("\\c{B}", "\u1e06");
        map.put("\\k{b}", "\u1d80");
        map.put("\\'{c}", "\u0107");
        map.put("\\'{C}", "\u0106");
        map.put("\\'c", "\u0107");
        map.put("\\'C", "\u0106");
        map.put("\\^{c}", "\u0109");
        map.put("\\^{C}", "\u0108");
        map.put("\\.{c}", "\u010b");
        map.put("\\.{C}", "\u010a");
        map.put("\\v{c}", "\u010d");
        map.put("\\v{C}", "\u010c");
        map.put("\\v c", "\u010d");
        map.put("\\v C", "\u010c");
        map.put("\\c{c}", "\u00e7");
        map.put("\\c{C}", "\u00c7");
        map.put("\\.{d}", "\u1e0b");
        map.put("\\.{D}", "\u1e0a");
        map.put("\\v{d}", "\u010f");
        map.put("\\v{D}", "\u010e");
        map.put("\\c{d}", "d\u0326");
        map.put("\\c{D}", "D\u0326");
        map.put("\\b{d}", "\u1e0f");
        map.put("\\b{D}", "\u1e0e");
        map.put("\\dj", "\u0111");
        map.put("\\DJ", "\u0110");
        map.put("\\`{e}", "\u00e8");
        map.put("\\`{E}", "\u00c8");
        map.put("\\'{e}", "\u00e9");
        map.put("\\'{E}", "\u00c9");
        map.put("\\^{e}", "\u00ea");
        map.put("\\^{E}", "\u00ca");
        map.put("\\\"{e}", "\u00eb");
        map.put("\\\"{E}", "\u00cb");
        map.put("\\~{e}", "\u1ebd");
        map.put("\\~{E}", "\u1ebc");
        map.put("\\={e}", "\u0113");
        map.put("\\={E}", "\u0112");
        map.put("\\=e", "\u0113");
        map.put("\\=E", "\u0112");
        map.put("\\.{e}", "\u0117");
        map.put("\\.{E}", "\u0116");
        map.put("\\u{e}", "\u0115");
        map.put("\\u{E}", "\u0114");
        map.put("\\v{e}", "\u011b");
        map.put("\\v{E}", "\u011a");
        map.put("\\H{e}", "\u0205");
        map.put("\\H{E}", "\u0204");
        map.put("\\c{e}", "\u0229");
        map.put("\\c{E}", "\u0228");
        map.put("\\d{e}", "\u1eb9");
        map.put("\\d{E}", "\u1eb8");
        map.put("\\k{e}", "\u0119");
        map.put("\\k{E}", "\u0118");
        map.put("\\.{f}", "\u1e1f");
        map.put("\\.{F}", "\u1e1e");
        map.put("\\'{g}", "\u01f5");
        map.put("\\'{G}", "\u01f4");
        map.put("\\^{g}", "\u011d");
        map.put("\\^{G}", "\u011c");
        map.put("\\.{g}", "\u0121");
        map.put("\\.{G}", "\u0120");
        map.put("\\u{g}", "\u011f");
        map.put("\\u{G}", "\u011e");
        map.put("\\v{g}", "\u0123");
        map.put("\\v g", "\u0123");
        map.put("\\v{G}", "\u01e6");
        map.put("\\c{g}", "\u0123");
        map.put("\\c{G}", "\u0122");
        map.put("\\c G", "\u0122");
        map.put("\\^{h}", "\u0125");
        map.put("\\^{H}", "\u0124");
        map.put("\\\"{h}", "\u1e27");
        map.put("\\\"{H}", "\u1e26");
        map.put("\\.{h}", "\u1e23");
        map.put("\\.{H}", "\u1e22");
        map.put("\\v{h}", "\u021f");
        map.put("\\v{H}", "\u021e");
        map.put("\\c{h}", "\u1e29");
        map.put("\\c{H}", "\u1e28");
        map.put("\\d{h}", "\u1e25");
        map.put("\\d{H}", "\u1e24");
        map.put("\\b{h}", "\u1e96");
        map.put("\\b{H}", "H\u0331");
        map.put("\\k{h}", "\u2c68");
        map.put("\\k{H}", "\u2c67");
        map.put("\\`{i}", "\u00ec");
        map.put("\\`{I}", "\u00cc");
        map.put("\\'{i}", "\u00ed");
        map.put("\\'{I}", "\u00cd");
        map.put("\\^{i}", "\u00ee");
        map.put("\\^{I}", "\u00ce");
        map.put("\\\"{i}", "\u00ef");
        map.put("\\\"{I}", "\u00cf");
        map.put("\\~{i}", "\u0129");
        map.put("\\~{I}", "\u0128");
        map.put("\\=\\i", "\u012b");
        map.put("\\={\\i}", "\u012b");
        map.put("\\={I}", "\u012a");
        map.put("\\=I", "\u012a");
        map.put("\\.{I}", "\u0130");
        map.put("\\u{i}", "\u012d");
        map.put("\\u{I}", "\u012c");
        map.put("\\v{i}", "\u01d0");
        map.put("\\v{I}", "\u01cf");
        map.put("\\H{i}", "\u0209");
        map.put("\\H{I}", "\u0208");
        map.put("\\k{i}", "\u012f");
        map.put("\\k{I}", "\u012e");
        map.put("\\^{j}", "\u0135");
        map.put("\\^{J}", "\u0134");
        map.put("\\v{j}", "\u01f0");
        map.put("\\v{J}", "J\u030c");
        map.put("\\'{k}", "\u1e31");
        map.put("\\'{K}", "\u1e30");
        map.put("\\v{k}", "\u01e9");
        map.put("\\v{K}", "\u01e8");
        map.put("\\c{k}", "\u0137");
        map.put("\\c{K}", "\u0136");
        map.put("\\c k", "\u0137");
        map.put("\\c K", "\u0136");
        map.put("\\d{k}", "\u1e33");
        map.put("\\d{K}", "\u1e32");
        map.put("\\k{k}", "\u2c6a");
        map.put("\\k{K}", "\u2c69");
        map.put("\\'{l}", "\u013a");
        map.put("\\'{L}", "\u0139");
        map.put("\\c{l}", "\u013c");
        map.put("\\c{L}", "\u013b");
        map.put("\\c l", "\u013c");
        map.put("\\c L", "\u013b");
        map.put("\\d{l}", "\u1e37");
        map.put("\\d{L}", "\u1e36");
        map.put("\\'{m}", "\u1e3f");
        map.put("\\'{M}", "\u1e3e");
        map.put("\\.{m}", "\u1e41");
        map.put("\\.{M}", "\u1e40");
        map.put("\\d{m}", "\u1e43");
        map.put("\\d{M}", "\u1e42");
        map.put("\\`{n}", "\u01f9");
        map.put("\\`{N}", "\u01f8");
        map.put("\\'{n}", "\u0144");
        map.put("\\'{N}", "\u0143");
        map.put("\\v{n}", "\u0148");
        map.put("\\v{N}", "\u0147");
        map.put("\\c{n}", "\u0146");
        map.put("\\c{N}", "\u0145");
        map.put("\\c n", "\u0146");
        map.put("\\c N", "\u0145");
        map.put("\\'{p}", "\u1e55");
        map.put("\\'{P}", "\u1e54");
        map.put("\\.{p}", "\u1e57");
        map.put("\\.{P}", "\u1e56");
        map.put("\\'{r}", "\u0155");
        map.put("\\'{R}", "\u0154");
        map.put("\\.{r}", "\u1e59");
        map.put("\\.{R}", "\u1e58");
        map.put("\\v{r}", "\u0159");
        map.put("\\v{R}", "\u0158");
        map.put("\\c{r}", "\u0157");
        map.put("\\c{R}", "\u0156");
        map.put("\\d{r}", "\u1e5b");
        map.put("\\d{R}", "\u1e5a");
        map.put("\\'{s}", "\u015b");
        map.put("\\'{S}", "\u015a");
        map.put("\\^{s}", "\u015d");
        map.put("\\^{S}", "\u015c");
        map.put("\\.{s}", "\u1e61");
        map.put("\\.{S}", "\u1e60");
        map.put("\\v{s}", "\u0161");
        map.put("\\v{S}", "\u0160");
        map.put("\\v s", "\u0161");
        map.put("\\v S", "\u0160");
        map.put("\\d{s}", "\u1e63");
        map.put("\\d{S}", "\u1e62");
        map.put("\\k{s}", "\u015f");
        map.put("\\k{S}", "\u015e");
        map.put("\\.{t}", "\u1e6b");
        map.put("\\.{T}", "\u1e6a");
        map.put("\\v{t}", "\u0165");
        map.put("\\v{T}", "\u0164");
        map.put("\\d{t}", "\u1e6d");
        map.put("\\d{T}", "\u1e6c");
        map.put("\\`{u}", "\u00f9");
        map.put("\\`{U}", "\u00d9");
        map.put("\\'{u}", "\u00fa");
        map.put("\\'{U}", "\u00da");
        map.put("\\^{u}", "\u00fb");
        map.put("\\^{U}", "\u00db");
        map.put("\\\"{u}", "\u00fc");
        map.put("\\\"{U}", "\u00dc");
        map.put("\\~{u}", "\u0169");
        map.put("\\~{U}", "\u0168");
        map.put("\\={u}", "\u016b");
        map.put("\\={U}", "\u016a");
        map.put("\\=u", "\u016b");
        map.put("\\=U", "\u016a");
        map.put("\\u{u}", "\u016d");
        map.put("\\u{U}", "\u016c");
        map.put("\\v{u}", "\u01d4");
        map.put("\\v{U}", "\u01d3");
        map.put("\\H{u}", "\u0215");
        map.put("\\H{U}", "\u0214");
        map.put("\\d{u}", "\u1ee5");
        map.put("\\d{U}", "\u1ee4");
        map.put("\\~{v}", "\u1e7d");
        map.put("\\~{V}", "\u1e7c");
        map.put("\\d{v}", "\u1e7f");
        map.put("\\d{V}", "\u1e7e");
        map.put("\\`{w}", "\u1e81");
        map.put("\\`{W}", "\u1e80");
        map.put("\\'{w}", "\u1e83");
        map.put("\\'{W}", "\u1e82");
        map.put("\\^{w}", "\u0175");
        map.put("\\^{W}", "\u0174");
        map.put("\\\"{w}", "\u1e85");
        map.put("\\\"{W}", "\u1e84");
        map.put("\\.{w}", "\u1e87");
        map.put("\\.{W}", "\u1e86");
        map.put("\\d{w}", "\u1e89");
        map.put("\\d{W}", "\u1e88");
        map.put("\\'{x}", "x\u0301");
        map.put("\\'{X}", "X\u0301");
        map.put("\\^{x}", "x\u0302");
        map.put("\\^{X}", "X\u0302");
        map.put("\\\"{x}", "\u1e8d");
        map.put("\\\"{X}", "\u1e8c");
        map.put("\\.{x}", "\u1e8b");
        map.put("\\.{X}", "\u1e8a");
        map.put("\\v{x}", "x\u030c");
        map.put("\\v{X}", "X\u030c");
        map.put("\\d{x}", "x\u0323");
        map.put("\\d{X}", "X\u0323");
        map.put("\\`{y}", "\u1ef3");
        map.put("\\`{Y}", "\u1ef2");
        map.put("\\'{y}", "\u00fd");
        map.put("\\'{Y}", "\u00dd");
        map.put("\\^{y}", "\u0177");
        map.put("\\^{Y}", "\u0176");
        map.put("\\\"{y}", "\u00ff");
        map.put("\\\"{Y}", "\u0178");
        map.put("\\~{y}", "\u1ef9");
        map.put("\\~{Y}", "\u1ef8");
        map.put("\\={y}", "\u0233");
        map.put("\\={Y}", "\u0232");
        map.put("\\.{y}", "\u1e8f");
        map.put("\\.{Y}", "\u1e8e");
        map.put("\\'{z}", "\u017a");
        map.put("\\'{Z}", "\u0179");
        map.put("\\^{z}", "\u1e91");
        map.put("\\^{Z}", "\u1e90");
        map.put("\\.{z}", "\u017c");
        map.put("\\.{Z}", "\u017b");
        map.put("\\v{z}", "\u017e");
        map.put("\\v{Z}", "\u017d");
        map.put("\\v z", "\u017e");
        map.put("\\v Z", "\u017d");
        map.put("\\d{z}", "\u1e93");
        map.put("\\d{Z}", "\u1e92");
    }
}

