/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.tex;

import java.util.LinkedList;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.EventBuilder;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.tex.TEXEncoder;
import net.sf.okapi.filters.tex.TEXSkeletonWriter;
import net.sf.okapi.filters.tex.parser.TEXParser;
import net.sf.okapi.filters.tex.parser.TEXToken;
import net.sf.okapi.filters.tex.parser.TEXTokenType;

@UsingParameters
public class TEXFilter
extends AbstractFilter {
    public static final String TEX_MIME_TYPE = "text/x-tex-text";
    private EncoderManager encoderManager;
    private RawDocument input;
    private EventBuilder eventBuilder;
    private BOMNewlineEncodingDetector detector;
    private TEXParser parser;
    private LinkedList<String> oneArgInlineText = new LinkedList();
    private LinkedList<String> oneArgParaText = new LinkedList();
    private LinkedList<String> oneArgNoText = new LinkedList();
    private LinkedList<String> accentedChars = new LinkedList();
    private LinkedList<String> accentedCharsNonLetters = new LinkedList();
    private boolean isHeaderMode = true;
    private boolean isLastCommandNewline = true;

    public TEXFilter() {
        this.parser = new TEXParser();
        this.setMimeType(TEX_MIME_TYPE);
        this.setMultilingual(false);
        this.setName("okf_tex");
        this.setDisplayName("TEX Filter");
        this.getEncoderManager();
        this.encoderManager.updateEncoder(TEX_MIME_TYPE);
        this.addConfiguration(new FilterConfiguration(this.getName(), TEX_MIME_TYPE, this.getClass().getName(), "Tex", "Tex files", null, ".tex;"));
        this.oneArgInlineText.add("\\bf");
        this.oneArgInlineText.add("\\em");
        this.oneArgInlineText.add("\\emph");
        this.oneArgInlineText.add("\\footnote");
        this.oneArgInlineText.add("\\hbox");
        this.oneArgInlineText.add("\\mbox");
        this.oneArgInlineText.add("\\textbackit");
        this.oneArgInlineText.add("\\textbf");
        this.oneArgInlineText.add("\\texttt");
        this.oneArgInlineText.add("\\textsf");
        this.oneArgInlineText.add("\\textit");
        this.oneArgInlineText.add("\\tt");
        this.oneArgInlineText.add("\\vbox");
        this.oneArgParaText.add("\\author");
        this.oneArgParaText.add("\\Chapter");
        this.oneArgParaText.add("\\chapter");
        this.oneArgParaText.add("\\index");
        this.oneArgParaText.add("\\typeout");
        this.oneArgParaText.add("\\title");
        this.oneArgParaText.add("\\titlerunning");
        this.oneArgParaText.add("\\section");
        this.oneArgParaText.add("\\subsection");
        this.oneArgParaText.add("\\caption");
        this.oneArgNoText.add("\\begin");
        this.oneArgNoText.add("\\cite");
        this.oneArgNoText.add("\\citealt");
        this.oneArgNoText.add("\\documentclass");
        this.oneArgNoText.add("\\end");
        this.oneArgNoText.add("\\hspace");
        this.oneArgNoText.add("\\hskip");
        this.oneArgNoText.add("\\includegraphics");
        this.oneArgNoText.add("\\newcite");
        this.oneArgNoText.add("\\label");
        this.oneArgNoText.add("\\put");
        this.oneArgNoText.add("\\pageref");
        this.oneArgNoText.add("\\pagestyle");
        this.oneArgNoText.add("\\ref");
        this.oneArgNoText.add("\\thispagestyle");
        this.oneArgNoText.add("\\usepackage");
        this.oneArgNoText.add("\\vspace");
        this.oneArgNoText.add("\\vskip");
        this.accentedChars.add("\\oe");
        this.accentedChars.add("\\OE");
        this.accentedChars.add("\\ae");
        this.accentedChars.add("\\AE");
        this.accentedChars.add("\\aa");
        this.accentedChars.add("\\AA");
        this.accentedChars.add("\\o");
        this.accentedChars.add("\\O");
        this.accentedChars.add("\\l");
        this.accentedChars.add("\\L");
        this.accentedChars.add("\\ss");
        this.accentedChars.add("\\j");
        this.accentedCharsNonLetters.add("\\`");
        this.accentedCharsNonLetters.add("\\'");
        this.accentedCharsNonLetters.add("\\^");
        this.accentedCharsNonLetters.add("\\\"");
        this.accentedCharsNonLetters.add("\\~");
        this.accentedCharsNonLetters.add("\\=");
        this.accentedCharsNonLetters.add("\\.");
        this.accentedCharsNonLetters.add("\\%");
        this.accentedChars.add("\\u");
        this.accentedChars.add("\\v");
        this.accentedChars.add("\\H");
        this.accentedChars.add("\\c");
        this.accentedChars.add("\\d");
        this.accentedChars.add("\\k");
        this.accentedChars.add("\\i");
    }

    @Override
    protected boolean isUtf8Bom() {
        return this.detector != null && this.detector.hasUtf8Bom();
    }

    @Override
    protected boolean isUtf8Encoding() {
        return this.detector != null && this.detector.hasUtf8Encoding();
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
            this.detector = null;
            this.eventBuilder = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.eventBuilder.hasQueuedEvents();
    }

    @Override
    public Event next() {
        if (this.hasNext()) {
            return this.eventBuilder.next();
        }
        throw new IllegalStateException("No events available");
    }

    private void generateTokens() {
        this.parser.setNewline(this.getNewlineType());
        try (Scanner scanner = new Scanner(this.input.getReader());){
            scanner.useDelimiter("\\A");
            if (scanner.hasNext()) {
                this.parser.parse(scanner.next());
            }
        }
    }

    private String getCommandType(String commandText) {
        if (this.oneArgNoText.contains(commandText)) {
            return "OneArgNoText";
        }
        if (this.oneArgInlineText.contains(commandText)) {
            return "OneArgInlineText";
        }
        if (this.oneArgParaText.contains(commandText)) {
            return "OneArgParText";
        }
        if (this.accentedChars.contains(commandText.trim())) {
            return "AccentedChar";
        }
        for (String accentedChar : this.accentedCharsNonLetters) {
            if (!commandText.startsWith(accentedChar.trim())) continue;
            return "AccentedChar";
        }
        return "UnknownCommand";
    }

    private void generateEvents() {
        while (this.parser.hasNextToken()) {
            String text;
            TEXToken token = this.parser.getNextToken();
            TEXToken next_token = this.parser.peekNextToken();
            if (token.getType() == TEXTokenType.COMMENT) {
                this.isLastCommandNewline = false;
                this.addDocumentPartToEventBuilder(token.getContent());
                if (!this.parser.hasNextToken() || next_token.getType() != TEXTokenType.NEWLINE) continue;
                this.addDocumentPartToEventBuilder(this.parser.getNextToken().getContent());
                continue;
            }
            if (token.getType() == TEXTokenType.NEWLINE) {
                if (this.isLastCommandNewline && this.eventBuilder.isCurrentTextUnit()) {
                    this.eventBuilder.endTextUnit();
                }
                this.isLastCommandNewline = true;
                this.addDocumentPartToEventBuilder(token.getContent());
                continue;
            }
            if (token.getType() == TEXTokenType.COMMAND) {
                this.isLastCommandNewline = false;
                this.processCommand(token);
                continue;
            }
            if (token.getType() == TEXTokenType.DOLLAR) {
                this.isLastCommandNewline = false;
                text = this.processMath(token.getContent());
                this.addDocumentPartToEventBuilder(text);
                continue;
            }
            if (token.getType() == TEXTokenType.AMPERSAND) {
                this.isLastCommandNewline = false;
                this.addDocumentPartToEventBuilder(token.getContent());
                continue;
            }
            if (token.getType() == TEXTokenType.HASHTAG) {
                this.isLastCommandNewline = false;
                this.addDocumentPartToEventBuilder(token.getContent());
                continue;
            }
            if (token.getType() == TEXTokenType.CARET) {
                this.isLastCommandNewline = false;
                this.addDocumentPartToEventBuilder(token.getContent());
                continue;
            }
            if (token.getType() == TEXTokenType.UNDERSCORE) {
                this.isLastCommandNewline = false;
                this.addDocumentPartToEventBuilder(token.getContent());
                continue;
            }
            if (token.getType() == TEXTokenType.IGNORED_CHAR) {
                this.isLastCommandNewline = false;
                this.addDocumentPartToEventBuilder(token.getContent());
                continue;
            }
            if (token.getType() == TEXTokenType.TILDE) {
                this.isLastCommandNewline = false;
                this.addDocumentPartToEventBuilder(token.getContent());
                continue;
            }
            if (token.getType() == TEXTokenType.OPEN_CURLY) {
                this.isLastCommandNewline = false;
                this.processOpenCurly(token);
                continue;
            }
            if (token.getType() == TEXTokenType.CLOSE_CURLY) {
                System.out.println("Found closing curly in main loop without opening and next is_" + next_token.getContent() + "_");
                continue;
            }
            this.isLastCommandNewline = false;
            text = token.getContent();
            if (this.isHeaderMode) {
                this.addDocumentPartToEventBuilder(text);
                continue;
            }
            this.addTextToTextUnit(text);
        }
    }

    private TEXToken processTextBlock() {
        TEXToken token = null;
        TEXToken next_token = null;
        while (this.parser.hasNextToken()) {
            token = this.parser.getNextToken();
            next_token = this.parser.peekNextToken();
            if (token.getType() == TEXTokenType.COMMENT) {
                this.isLastCommandNewline = false;
                this.addDocumentPartToEventBuilder(token.getContent());
                if (!this.parser.hasNextToken() || next_token.getType() != TEXTokenType.NEWLINE) continue;
                this.addDocumentPartToEventBuilder(this.parser.getNextToken().getContent());
                continue;
            }
            if (token.getType() == TEXTokenType.NEWLINE) {
                if (this.isLastCommandNewline && this.eventBuilder.isCurrentTextUnit()) {
                    this.eventBuilder.endTextUnit();
                }
                this.isLastCommandNewline = true;
                this.addDocumentPartToEventBuilder(token.getContent());
                continue;
            }
            if (token.getType() == TEXTokenType.COMMAND) {
                this.isLastCommandNewline = false;
                this.processCommand(token);
                continue;
            }
            if (token.getType() == TEXTokenType.DOLLAR) {
                this.isLastCommandNewline = false;
                String text = this.processMath(token.getContent());
                this.addDocumentPartToEventBuilder(text);
                continue;
            }
            if (token.getType() == TEXTokenType.AMPERSAND) {
                this.isLastCommandNewline = false;
                this.addDocumentPartToEventBuilder(token.getContent());
                continue;
            }
            if (token.getType() == TEXTokenType.HASHTAG) {
                this.isLastCommandNewline = false;
                this.addDocumentPartToEventBuilder(token.getContent());
                continue;
            }
            if (token.getType() == TEXTokenType.CARET) {
                this.isLastCommandNewline = false;
                this.addDocumentPartToEventBuilder(token.getContent());
                continue;
            }
            if (token.getType() == TEXTokenType.UNDERSCORE) {
                this.isLastCommandNewline = false;
                this.addDocumentPartToEventBuilder(token.getContent());
                continue;
            }
            if (token.getType() == TEXTokenType.IGNORED_CHAR) {
                this.isLastCommandNewline = false;
                this.addDocumentPartToEventBuilder(token.getContent());
                continue;
            }
            if (token.getType() == TEXTokenType.TILDE) {
                this.isLastCommandNewline = false;
                this.addDocumentPartToEventBuilder(token.getContent());
                continue;
            }
            if (token.getType() == TEXTokenType.OPEN_CURLY) {
                this.isLastCommandNewline = false;
                this.processOpenCurly(token);
                continue;
            }
            if (token.getType() == TEXTokenType.CLOSE_CURLY) {
                return token;
            }
            if (token.getType() == TEXTokenType.INVALID_CHAR) {
                this.isLastCommandNewline = false;
                this.addDocumentPartToEventBuilder(token.getContent());
                continue;
            }
            this.isLastCommandNewline = false;
            this.addTextToTextUnit(token.getContent());
        }
        return token;
    }

    private void processOpenCurly(TEXToken token) {
        TEXToken next_token = this.parser.peekNextToken();
        if (!this.isHeaderMode && next_token.getType() == TEXTokenType.COMMAND) {
            this.processOneArgInlineText(token);
            return;
        }
        Object text = token.getContent();
        int nestingLevel = 1;
        while (this.parser.hasNextToken()) {
            token = this.parser.getNextToken();
            text = (String)text + token.getContent();
            if (token.getType() == TEXTokenType.OPEN_CURLY) {
                ++nestingLevel;
            }
            if (token.getType() != TEXTokenType.CLOSE_CURLY || --nestingLevel >= 1) continue;
        }
        this.addDocumentPartToEventBuilder((String)text);
    }

    private String processAccentedChar(TEXToken token) {
        Object text = token.getContent();
        int nestingLevel = 0;
        while (this.parser.hasNextToken()) {
            token = this.parser.peekNextToken();
            if (token.getType() == TEXTokenType.OPEN_CURLY) {
                ++nestingLevel;
                text = (String)text + token.getContent();
            } else {
                if (token.getType() == TEXTokenType.CLOSE_CURLY) {
                    if (--nestingLevel < 0) {
                        return text;
                    }
                    text = (String)text + token.getContent();
                    break;
                }
                if (token.getType() == TEXTokenType.TEXT) {
                    text = (String)text + token.getContent();
                    if (nestingLevel < 1) {
                        break;
                    }
                } else {
                    if (token.getType() == TEXTokenType.COMMAND && this.getCommandType(token.getContent()).equals("AccentedChar")) {
                        text = (String)text + token.getContent();
                        this.parser.getNextToken();
                        continue;
                    }
                    return text;
                }
            }
            this.parser.getNextToken();
        }
        this.parser.getNextToken();
        return text;
    }

    private void processOneArgParText(TEXToken token) {
        if (this.eventBuilder.isCurrentTextUnit()) {
            this.eventBuilder.endTextUnit();
        }
        GenericSkeleton startMarker = new GenericSkeleton(token.getContent());
        if (this.parser.peekNextToken().getType() == TEXTokenType.OPEN_CURLY) {
            startMarker.add(this.parser.getNextToken().getContent());
        }
        if (this.parser.peekNextToken().getType() == TEXTokenType.COMMAND) {
            startMarker.add(this.parser.getNextToken().getContent());
        }
        if (this.parser.peekNextToken().getContent().startsWith(" ")) {
            startMarker.add(" ");
        }
        this.eventBuilder.startTextUnit(startMarker);
        token = this.processTextBlock();
        GenericSkeleton endMarker = new GenericSkeleton(token.getContent());
        if (this.eventBuilder.isCurrentTextUnit()) {
            this.eventBuilder.endTextUnit(endMarker);
        } else {
            System.out.println("No TextUnit to close with end marker, inserting as document part " + token.getContent());
            this.addDocumentPartToEventBuilder(token.getContent());
        }
    }

    private void processOneArgInlineText(TEXToken token) {
        if (!this.eventBuilder.isCurrentTextUnit()) {
            this.eventBuilder.startTextUnit();
        }
        Object openingTag = token.getContent();
        if (this.parser.peekNextToken().getType() == TEXTokenType.OPEN_CURLY | token.getType() == TEXTokenType.OPEN_CURLY) {
            openingTag = (String)openingTag + this.parser.getNextToken().getContent();
        }
        if (this.parser.peekNextToken().getContent().startsWith(" ")) {
            openingTag = (String)openingTag + " ";
        }
        this.addOpening((String)openingTag);
        token = this.processTextBlock();
        if (this.eventBuilder.isCurrentTextUnit()) {
            this.addClosing(token.getContent());
        } else {
            System.out.println("No TextUnit to close with closing code, inserting as document part" + token.getContent());
            this.addDocumentPartToEventBuilder(token.getContent());
        }
    }

    private void processCommand(TEXToken token) {
        String commandType;
        switch (commandType = this.getCommandType(token.getContent())) {
            case "AccentedChar": {
                String text = this.processAccentedChar(token);
                this.addTextToTextUnit(text);
                break;
            }
            case "OneArgNoText": 
            case "UnknownCommand": {
                Object text = token.getContent();
                int nestingLevel = 0;
                if (token.getContent().contains("|")) {
                    while (this.parser.hasNextToken()) {
                        token = this.parser.getNextToken();
                        text = (String)text + token.getContent();
                        if (!token.getContent().contains("|")) continue;
                    }
                    this.addDocumentPartToEventBuilder((String)text);
                    return;
                }
                if (this.parser.hasNextToken() && this.parser.peekNextToken().getType() != TEXTokenType.OPEN_CURLY) {
                    if (this.parser.peekNextToken().getContent().startsWith(" ")) {
                        this.addDocumentPartToEventBuilder(token.getContent() + " ");
                    } else {
                        this.addDocumentPartToEventBuilder(token.getContent());
                    }
                    return;
                }
                while (this.parser.hasNextToken()) {
                    token = this.parser.getNextToken();
                    if (token.getType() == TEXTokenType.COMMAND) {
                        text = (String)text + token.getContent();
                        continue;
                    }
                    if (token.getType() == TEXTokenType.OPEN_CURLY) {
                        ++nestingLevel;
                        text = (String)text + token.getContent();
                        continue;
                    }
                    if (token.getType() == TEXTokenType.CLOSE_CURLY) {
                        --nestingLevel;
                        if (((String)(text = (String)text + token.getContent())).matches(".*\\\\begin\\{.*document.*\\}")) {
                            this.isHeaderMode = false;
                        }
                        if (((String)text).matches(".*\\\\end\\{.*document.*\\}")) {
                            this.isHeaderMode = true;
                        }
                        if (nestingLevel >= 1) continue;
                        if (((String)text).contains("\\begin{") && this.eventBuilder.isCurrentTextUnit()) {
                            this.eventBuilder.endTextUnit();
                        }
                        if (((String)text).matches(".*\\\\begin\\{.*table.*\\}")) {
                            text = this.processTable((String)text);
                        }
                        if (((String)text).matches(".*\\\\begin\\{.*equation.*\\}")) {
                            text = this.processEquation((String)text);
                        }
                        if (!((String)text).matches(".*\\\\begin\\{.*figure.*\\}")) break;
                        text = this.processFigure((String)text);
                        break;
                    }
                    if (token.getType() == TEXTokenType.NEWLINE) {
                        text = (String)text + token.getContent();
                        continue;
                    }
                    if (nestingLevel < 1) {
                        System.out.println("TEXFilter @processCommand found broken " + (String)text);
                        break;
                    }
                    text = (String)text + token.getContent();
                }
                text = ((String)text).replaceAll(Pattern.quote("\\usepackage[latin1]{inputenc}"), Matcher.quoteReplacement("\\usepackage[utf8]{inputenc}"));
                this.addDocumentPartToEventBuilder((String)text);
                break;
            }
            case "OneArgInlineText": {
                this.processOneArgInlineText(token);
                break;
            }
            case "OneArgParText": {
                this.processOneArgParText(token);
            }
        }
    }

    private String processTable(String text) {
        while (this.parser.hasNextToken()) {
            TEXToken token = this.parser.getNextToken();
            text = (String)text + token.getContent();
            if (!Pattern.compile(".*\\\\end\\{.*table.*\\}").matcher((CharSequence)text).find()) continue;
            return text;
        }
        return text;
    }

    private String processEquation(String text) {
        while (this.parser.hasNextToken()) {
            TEXToken token = this.parser.getNextToken();
            text = (String)text + token.getContent();
            if (!Pattern.compile(".*\\\\end\\{.*equation.*\\}").matcher((CharSequence)text).find()) continue;
            return text;
        }
        return text;
    }

    private String processFigure(String text) {
        while (this.parser.hasNextToken()) {
            TEXToken token = this.parser.getNextToken();
            text = (String)text + token.getContent();
            if (!Pattern.compile(".*\\\\end\\{.*figure.*\\}").matcher((CharSequence)text).find()) continue;
            return text;
        }
        return text;
    }

    private String processMath(String text) {
        boolean lastTokenDollar = true;
        boolean centeredMathMode = false;
        while (this.parser.hasNextToken()) {
            TEXToken token = this.parser.getNextToken();
            if (token.getType() == TEXTokenType.DOLLAR) {
                if (lastTokenDollar && centeredMathMode) {
                    text = (String)text + token.getContent();
                    break;
                }
                if (!lastTokenDollar && centeredMathMode) {
                    lastTokenDollar = true;
                    text = (String)text + token.getContent();
                    continue;
                }
                if (lastTokenDollar && !centeredMathMode) {
                    centeredMathMode = true;
                    text = (String)text + token.getContent();
                    continue;
                }
                text = (String)text + token.getContent();
                break;
            }
            lastTokenDollar = false;
            text = (String)text + token.getContent();
        }
        return text;
    }

    private void addOpening(String text) {
        if (!this.eventBuilder.isCurrentTextUnit()) {
            this.eventBuilder.startTextUnit();
        }
        this.eventBuilder.addToTextUnit(new Code(TextFragment.TagType.OPENING, TEXTokenType.COMMAND.name(), text));
    }

    private void addClosing(String text) {
        this.eventBuilder.addToTextUnit(new Code(TextFragment.TagType.CLOSING, TEXTokenType.COMMAND.name(), text));
    }

    private void addDocumentPartToEventBuilder(String text) {
        if (this.eventBuilder.isCurrentTextUnit()) {
            this.eventBuilder.addToTextUnit(new Code(TextFragment.TagType.PLACEHOLDER, TEXTokenType.COMMAND.name(), text));
        } else {
            this.eventBuilder.addToDocumentPart(text);
        }
    }

    private void addTextToTextUnit(String text) {
        if (!this.eventBuilder.isCurrentTextUnit()) {
            this.eventBuilder.startTextUnit();
        }
        text = this.encoderManager.encode(text, EncoderContext.TEXT);
        this.eventBuilder.addToTextUnit(text);
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.input = input;
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), "UTF-8");
        detector.detectAndRemoveBom();
        this.setNewlineType(detector.getNewlineType().toString());
        input.setEncoding(detector.getEncoding());
        String encoding = input.getEncoding();
        this.setEncoding(encoding);
        this.setOptions(input.getSourceLocale(), input.getTargetLocale(), encoding, generateSkeleton);
        this.generateTokens();
        if (this.eventBuilder == null) {
            this.eventBuilder = new EventBuilder(this.getParentId(), this);
        } else {
            this.eventBuilder.reset(this.getParentId(), this);
        }
        this.eventBuilder.setPreserveWhitespace(true);
        this.eventBuilder.addFilterEvent(this.createStartFilterEvent());
        this.generateEvents();
        if (this.eventBuilder.isCurrentTextUnit()) {
            this.eventBuilder.endTextUnit();
        }
        if (this.eventBuilder.hasUnfinishedSkeleton()) {
            this.eventBuilder.endDocumentPart();
        }
        this.eventBuilder.addFilterEvent(this.createEndFilterEvent());
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
        }
        this.encoderManager.setMapping(TEX_MIME_TYPE, new TEXEncoder());
        return this.encoderManager;
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(new TEXSkeletonWriter(), this.getEncoderManager());
    }
}

