/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.ttml;

import net.sf.okapi.common.skeleton.GenericSkeletonPart;

public class TTMLSkeletonPart
extends GenericSkeletonPart {
    public int startBeginTime;
    public int endBeginTime;
    public int startEndTime;
    public int endEndTime;
    private boolean isHeader;

    public TTMLSkeletonPart(String data, int startBeginTime, int endBeginTime, int startEndTime, int endEndTime) {
        super(data);
        this.startBeginTime = startBeginTime;
        this.endBeginTime = endBeginTime;
        this.startEndTime = startEndTime;
        this.endEndTime = endEndTime;
        this.isHeader = true;
    }

    public TTMLSkeletonPart(String data) {
        super(data);
        this.isHeader = false;
    }

    public String reconstruct(String beginTime, String endTime) {
        if (!this.isHeader) {
            throw new IllegalStateException("Cannot reconstruct non-header ttml skeleton part");
        }
        StringBuilder tmp = new StringBuilder();
        String data = this.toString();
        if (this.startBeginTime < this.startEndTime) {
            tmp.append(data.substring(0, this.startBeginTime));
            tmp.append("begin");
            tmp.append("=\"");
            tmp.append(beginTime);
            tmp.append("\"");
            tmp.append(data.substring(this.endBeginTime, this.startEndTime));
            tmp.append("end");
            tmp.append("=\"");
            tmp.append(endTime);
            tmp.append("\"");
            tmp.append(data.substring(this.endEndTime));
        } else {
            tmp.append(data.substring(0, this.startEndTime));
            tmp.append("end");
            tmp.append("=\"");
            tmp.append(beginTime);
            tmp.append("\"");
            tmp.append(data.substring(this.endEndTime, this.startBeginTime));
            tmp.append("begin");
            tmp.append("=\"");
            tmp.append(endTime);
            tmp.append("\"");
            tmp.append(data.substring(this.endBeginTime));
        }
        return tmp.toString();
    }

    public boolean isHeader() {
        return this.isHeader;
    }
}

