/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.ttml;

import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.filters.subtitles.CaptionAnnotation;
import net.sf.okapi.filters.subtitles.SplitCaption;
import net.sf.okapi.filters.ttml.TTMLFilter;
import net.sf.okapi.filters.ttml.TTMLParameters;
import net.sf.okapi.filters.ttml.TTMLSkeletonPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTMLSkeletonWriter
extends GenericSkeletonWriter {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private DateTimeFormatter formatter;
    private TTMLParameters params;
    private boolean isCJK;

    @Override
    public String processStartDocument(LocaleId outputLocale, String outputEncoding, EncoderManager encoderManager, StartDocument resource) {
        this.params = (TTMLParameters)resource.getFilterParameters();
        this.formatter = TTMLFilter.getDateTimeFormatter(this.params.getTimeFormat());
        this.isCJK = TTMLSkeletonWriter.isCJ(outputLocale);
        return super.processStartDocument(outputLocale, outputEncoding, encoderManager, resource);
    }

    public static boolean isCJ(LocaleId localeId) {
        return localeId.sameLanguageAs(LocaleId.CHINA_CHINESE) || localeId.sameLanguageAs(LocaleId.JAPANESE);
    }

    @Override
    public String processTextUnit(ITextUnit resource) {
        SplitCaption decodedCaptions;
        CaptionAnnotation annotation = resource.getAnnotation(CaptionAnnotation.class);
        String wholeCaption = super.getContent(resource, this.outputLoc, EncoderContext.TEXT);
        if (this.params.getUseCodeFinder()) {
            TextFragment tf = new TextFragment(wholeCaption);
            this.params.getCodeFinder().process(tf);
            SplitCaption codedCaptions = this.params.getEscapeBrMode() ? SplitCaption.splitCaption(tf.getCodedText(), annotation.getSize(), annotation.getMaxLine(), annotation.getMaxChar(), false, false, !this.params.getSplitWords(), this.isCJK) : new SplitCaption(tf.getCodedText(), annotation.getSize());
            ArrayList<ArrayList<String>> newCaptions = new ArrayList<ArrayList<String>>();
            for (ArrayList arrayList : codedCaptions.getCaptions()) {
                ArrayList<String> newCaption = new ArrayList<String>();
                for (String caption : arrayList) {
                    TextFragment captionFragment = new TextFragment(tf);
                    captionFragment.setCodedText(caption, true);
                    newCaption.add(super.getContent(captionFragment, this.outputLoc, EncoderContext.TEXT));
                }
                newCaptions.add(newCaption);
            }
            decodedCaptions = new SplitCaption(newCaptions);
        } else {
            decodedCaptions = this.params.getEscapeBrMode() ? SplitCaption.splitCaption(wholeCaption, annotation.getSize(), annotation.getMaxLine(), annotation.getMaxChar(), false, false, !this.params.getSplitWords(), this.isCJK) : new SplitCaption(wholeCaption, annotation.getSize());
        }
        Iterator<String> startTagIterator = this.normalizeCaptionTimes(annotation, (GenericSkeleton)resource.getSkeleton()).iterator();
        Iterator<ArrayList<String>> captionIterator = decodedCaptions.iterator();
        StringBuilder tmp = new StringBuilder();
        for (GenericSkeletonPart genericSkeletonPart : ((GenericSkeleton)resource.getSkeleton()).getParts()) {
            TTMLSkeletonPart ttmlPart = (TTMLSkeletonPart)genericSkeletonPart;
            if (ttmlPart.isHeader()) {
                tmp.append(startTagIterator.next());
                tmp.append(this.mergeCaption(captionIterator.next()));
                continue;
            }
            tmp.append((CharSequence)ttmlPart.getData());
        }
        return tmp.toString();
    }

    private String mergeCaption(ArrayList<String> caption) {
        StringBuilder tmp = new StringBuilder();
        for (String line : caption) {
            tmp.append(line);
            if (!this.params.getEscapeBrMode()) continue;
            tmp.append("<br/>");
        }
        if (this.params.getEscapeBrMode()) {
            tmp.setLength(tmp.length() - 5);
        }
        return tmp.toString();
    }

    private ArrayList<String> normalizeCaptionTimes(CaptionAnnotation annotation, GenericSkeleton skeleton) {
        ArrayList<String> normalizedCaptionTimes = new ArrayList<String>();
        LocalTime beginTime = annotation.getFirst().getBeginTime();
        LocalTime endTime = annotation.getLast().getEndTime();
        if (this.params.getKeepTimecodes() || beginTime == null || endTime == null) {
            for (GenericSkeletonPart part : skeleton.getParts()) {
                normalizedCaptionTimes.add(part.toString());
            }
            return normalizedCaptionTimes;
        }
        Duration duration = Duration.between(beginTime, endTime);
        duration = duration.dividedBy(annotation.getSize());
        LocalTime prevTime = beginTime;
        for (GenericSkeletonPart part : skeleton.getParts()) {
            TTMLSkeletonPart ttmlPart = (TTMLSkeletonPart)part;
            if (!ttmlPart.isHeader()) continue;
            LocalTime nextTime = prevTime.plus(duration);
            normalizedCaptionTimes.add(ttmlPart.reconstruct(this.formatter.format(prevTime), this.formatter.format(nextTime)));
            prevTime = nextTime;
        }
        return normalizedCaptionTimes;
    }
}

