/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.vtt;

import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.filters.subtitles.CaptionAnnotation;
import net.sf.okapi.filters.subtitles.SplitCaption;
import net.sf.okapi.filters.vtt.VTTFilter;
import net.sf.okapi.filters.vtt.VTTParameters;
import net.sf.okapi.filters.vtt.VTTSkeletonPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VTTSkeletonWriter
extends GenericSkeletonWriter {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private String newLineType;
    private DateTimeFormatter formatter;
    private VTTParameters params;
    private boolean isCJ;

    @Override
    public String processStartDocument(LocaleId outputLocale, String outputEncoding, EncoderManager encoderManager, StartDocument resource) {
        this.newLineType = resource.getLineBreak();
        this.params = (VTTParameters)resource.getFilterParameters();
        this.formatter = VTTFilter.getDateTimeFormatter(this.params.getTimeFormat());
        this.isCJ = VTTSkeletonWriter.isCJ(outputLocale);
        return super.processStartDocument(outputLocale, outputEncoding, encoderManager, resource);
    }

    public static boolean isCJ(LocaleId localeId) {
        return localeId.sameLanguageAs(LocaleId.CHINA_CHINESE) || localeId.sameLanguageAs(LocaleId.JAPANESE);
    }

    @Override
    public String processTextUnit(ITextUnit resource) {
        SplitCaption decodedCaptions;
        CaptionAnnotation annotation = resource.getAnnotation(CaptionAnnotation.class);
        String wholeCaption = super.getContent(resource, this.outputLoc, EncoderContext.TEXT);
        if (this.params.getUseCodeFinder()) {
            TextFragment tf = new TextFragment(wholeCaption);
            this.params.getCodeFinder().process(tf);
            SplitCaption codedCaptions = SplitCaption.splitCaption(tf.getCodedText(), annotation.getSize(), annotation.getMaxLine(), annotation.getMaxChar(), false, false, !this.params.getSplitWords(), this.isCJ);
            ArrayList<ArrayList<String>> newCaptions = new ArrayList<ArrayList<String>>();
            for (ArrayList arrayList : codedCaptions.getCaptions()) {
                ArrayList<String> newCaption = new ArrayList<String>();
                for (String caption : arrayList) {
                    TextFragment captionFragment = new TextFragment(tf);
                    captionFragment.setCodedText(caption, true);
                    newCaption.add(super.getContent(captionFragment, this.outputLoc, EncoderContext.TEXT));
                }
                newCaptions.add(newCaption);
            }
            decodedCaptions = new SplitCaption(newCaptions);
        } else {
            decodedCaptions = SplitCaption.splitCaption(wholeCaption, annotation.getSize(), annotation.getMaxLine(), annotation.getMaxChar(), false, false, !this.params.getSplitWords(), this.isCJ);
        }
        Iterator<ArrayList<String>> captionIterator = decodedCaptions.iterator();
        Iterator<String> headerIterator = this.normalizeCaptionTimes(annotation).iterator();
        StringBuilder tmp = new StringBuilder();
        for (GenericSkeletonPart genericSkeletonPart : ((GenericSkeleton)resource.getSkeleton()).getParts()) {
            VTTSkeletonPart vttPart = (VTTSkeletonPart)genericSkeletonPart;
            if (vttPart.isHeader()) {
                tmp.append(headerIterator.next());
                tmp.append(this.getCueSettings(vttPart));
                tmp.append(this.newLineType);
                tmp.append(this.mergeCaption(captionIterator.next()));
                continue;
            }
            if (!vttPart.isEmpty()) {
                tmp.append((CharSequence)vttPart.getData());
            }
            tmp.append(this.newLineType);
        }
        return tmp.toString();
    }

    private String mergeCaption(ArrayList<String> caption) {
        StringBuilder tmp = new StringBuilder();
        for (String line : caption) {
            tmp.append(line);
            tmp.append(this.newLineType);
        }
        return tmp.toString();
    }

    private String getCueSettings(VTTSkeletonPart part) {
        if (!this.params.getCueSettings().isEmpty()) {
            return " " + this.params.getCueSettings();
        }
        if (this.params.getDiscardCues()) {
            return "";
        }
        Matcher matcher = VTTFilter.HEADER_PATTERN.matcher(part.getData());
        if (!matcher.find() || matcher.group(4).isEmpty()) {
            return "";
        }
        return " " + matcher.group(4);
    }

    private ArrayList<String> normalizeCaptionTimes(CaptionAnnotation annotation) {
        ArrayList<String> normalizedCaptionTimes = new ArrayList<String>();
        LocalTime beginTime = annotation.getFirst().getBeginTime();
        LocalTime endTime = annotation.getLast().getEndTime();
        if (this.params.getKeepTimecodes() || beginTime == null || endTime == null) {
            for (CaptionAnnotation.CaptionTiming timing : annotation) {
                normalizedCaptionTimes.add(this.formatAsHeader(timing.getBeginString(), timing.getEndString()));
            }
            return normalizedCaptionTimes;
        }
        Duration duration = Duration.between(beginTime, endTime);
        duration = duration.dividedBy(annotation.getSize());
        LocalTime prevTime = beginTime;
        for (CaptionAnnotation.CaptionTiming timing : annotation) {
            LocalTime nextTime = prevTime.plus(duration);
            normalizedCaptionTimes.add(this.formatAsHeader(prevTime, nextTime));
            prevTime = nextTime;
        }
        return normalizedCaptionTimes;
    }

    private String formatAsHeader(LocalTime begin, LocalTime end) {
        return this.formatAsHeader(this.formatter.format(begin), this.formatter.format(end));
    }

    private String formatAsHeader(String begin, String end) {
        return begin + " --> " + end;
    }
}

